/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.NativeJavaArray;
import org.mozilla.nb.javascript.NativeJavaObject;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapFactory {
    private boolean javaPrimitiveWrap = true;

    public Object wrap(Context context, Scriptable scriptable, Object object, Class<?> clazz) {
        Class<?> clazz2;
        if (object == null || object == Undefined.instance || object instanceof Scriptable) {
            return object;
        }
        if (clazz != null && clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return Undefined.instance;
            }
            if (clazz == Character.TYPE) {
                return new Integer(((Character)object).charValue());
            }
            return object;
        }
        if (!this.isJavaPrimitiveWrap()) {
            if (object instanceof String || object instanceof Number || object instanceof Boolean) {
                return object;
            }
            if (object instanceof Character) {
                return String.valueOf(((Character)object).charValue());
            }
        }
        if ((clazz2 = object.getClass()).isArray()) {
            return NativeJavaArray.wrap(scriptable, object);
        }
        return this.wrapAsJavaObject(context, scriptable, object, clazz);
    }

    public Scriptable wrapNewObject(Context context, Scriptable scriptable, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return NativeJavaArray.wrap(scriptable, object);
        }
        return this.wrapAsJavaObject(context, scriptable, object, null);
    }

    public Scriptable wrapAsJavaObject(Context context, Scriptable scriptable, Object object, Class<?> clazz) {
        NativeJavaObject nativeJavaObject = new NativeJavaObject(scriptable, object, clazz);
        return nativeJavaObject;
    }

    public final boolean isJavaPrimitiveWrap() {
        return this.javaPrimitiveWrap;
    }

    public final void setJavaPrimitiveWrap(boolean bl) {
        Context context = Context.getCurrentContext();
        if (context != null && context.isSealed()) {
            Context.onSealedMutation();
        }
        this.javaPrimitiveWrap = bl;
    }
}

