/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.BaseFunction;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Decompiler;
import org.mozilla.nb.javascript.EvaluatorException;
import org.mozilla.nb.javascript.NativeCall;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.UintMap;
import org.mozilla.nb.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context context, Scriptable scriptable) {
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
    }

    final String decompile(int n, int n2) {
        String string = this.getEncodedSource();
        if (string == null) {
            return super.decompile(n, n2);
        }
        UintMap uintMap = new UintMap(1);
        uintMap.put(1, n);
        return Decompiler.decompile(string, n2, uintMap);
    }

    public int getLength() {
        int n = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return n;
        }
        Context context = Context.getContext();
        NativeCall nativeCall = ScriptRuntime.findFunctionActivation(context, this);
        if (nativeCall == null) {
            return n;
        }
        return nativeCall.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    public Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        throw new EvaluatorException("resumeGenerator() not implemented");
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected boolean getParamOrVarConst(int n) {
        return false;
    }
}

