/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.JavaCodeGenerator;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.codegen.CodeUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiGuardedSection {
    private StyledDocument document;
    private String multiGuardedID;
    private ArrayList<SimpleSection> guardedSections = new ArrayList();
    private ArrayList<String> editableSectionIDs = new ArrayList();
    private int index = 0;
    private boolean guarded = true;
    private CodeWriter writer;

    private MultiGuardedSection(StyledDocument styledDocument, String string) {
        assert (string.indexOf(124) < 0);
        this.document = styledDocument;
        this.multiGuardedID = string;
        this.initialize();
        JavaCodeGenerator.getDefault().registerUsedMultiGuardedSection(styledDocument, this);
    }

    private void initialize() {
        String string;
        SimpleSection simpleSection;
        GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)this.document);
        Iterable iterable = guardedSectionManager.getGuardedSections();
        while ((simpleSection = CodeUtils.findSectionByPrefix(iterable, string = this.createSectionID(this.guardedSections.size(), null))) != null) {
            String string2 = simpleSection.getName().substring(string.length());
            this.addSection(simpleSection, string2);
        }
        if (this.guardedSections.size() <= 0) {
            string = this.createSectionID(0, null);
            this.addSection(CodeUtils.createSimpleSectionAfter(this.document, CodeUtils.findLast(iterable), string), null);
        }
    }

    public void switchToGuarded() {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is closed already", this.multiGuardedID});
        }
        if (this.guarded) {
            throw Debug.illegalState((Object[])new Object[]{"Cannot switch to guarded from guarded", this.multiGuardedID, this.index});
        }
        if (!this.isWriterCommitted()) {
            throw Debug.illegalState((Object[])new Object[]{"Writer is not committed yet", this.multiGuardedID, this.index});
        }
        this.writer = null;
        ++this.index;
        this.guarded = !this.guarded;
    }

    public void switchToEditable(String string) {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is already closed", this.multiGuardedID});
        }
        if (!this.guarded) {
            throw Debug.illegalState((Object[])new Object[]{"Cannot switch from editable to editable", this.multiGuardedID, this.index, string});
        }
        if (!this.isWriterCommitted()) {
            throw Debug.illegalState((Object[])new Object[]{"Writer is not committed yet", this.multiGuardedID, this.index});
        }
        this.writer = null;
        if (this.index + 1 >= this.guardedSections.size()) {
            GuardedSection guardedSection = CodeUtils.findLast(this.guardedSections);
            String string2 = this.createSectionID(this.guardedSections.size(), null);
            SimpleSection simpleSection = CodeUtils.createSimpleSectionAfter(this.document, guardedSection, string2);
            this.addSection(simpleSection, null);
        }
        this.editableSectionIDs.set(this.index, string);
        this.guarded = !this.guarded;
    }

    public CodeWriter getWriter() {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is closed already", this.multiGuardedID});
        }
        if (this.writer == null) {
            if (this.guarded) {
                this.writer = new CodeWriter(this.document, this.guardedSections.get(this.index));
            } else {
                String string = this.editableSectionIDs.get(this.index);
                this.writer = new CodeWriter(this.document, this.guardedSections.get(this.index), this.guardedSections.get(this.index + 1), JavaCodeGenerator.getDefault().getUserCode(this.document, this.multiGuardedID, string));
            }
        }
        return this.writer;
    }

    public void close() {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is closed already", this.multiGuardedID});
        }
        if (!this.guarded || !this.isWriterCommitted()) {
            throw Debug.illegalState((Object[])new Object[]{"Cannot close - last section is not properly commited", this.multiGuardedID, this.guarded, this.isWriterCommitted()});
        }
        int n = this.guardedSections.size();
        if (n > 0) {
            this.editableSectionIDs.set(n - 1, "");
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.guardedSections.get(i).setName(this.createSectionID(i, this.editableSectionIDs.get(i)));
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                throw Debug.error((Object[])new Object[]{propertyVetoException});
            }
        }
        Position position = this.guardedSections.get(this.index).getEndPosition();
        Position position2 = this.guardedSections.get(n - 1).getEndPosition();
        for (int i = this.index + 1; i < n; ++i) {
            this.guardedSections.get(i).removeSection();
        }
        try {
            this.document.remove(position.getOffset() + 1, position2.getOffset() - (position.getOffset() + 1));
        }
        catch (BadLocationException badLocationException) {
            throw Debug.error((Object[])new Object[]{badLocationException});
        }
        this.index = -1;
    }

    public static MultiGuardedSection create(StyledDocument styledDocument, String string) {
        return string != null ? new MultiGuardedSection(styledDocument, string) : null;
    }

    String getMultiGuardedID() {
        return this.multiGuardedID;
    }

    private void addSection(SimpleSection simpleSection, String string) {
        this.guardedSections.add(simpleSection);
        this.editableSectionIDs.add(string);
    }

    private String createSectionID(int n, String string) {
        return '|' + this.multiGuardedID + '|' + n + '|' + (string != null ? string : "");
    }

    static String createSectionIDPrefix(String string) {
        return '|' + string + '|';
    }

    private static String createSectionID(String string, int n, String string2) {
        return '|' + string + '|' + n + '|' + (string2 != null ? string2 : "");
    }

    private boolean isWriterCommitted() {
        return this.writer != null && this.writer.isCommitted();
    }

    public boolean isGuarded() {
        return this.guarded;
    }

    public static boolean isPartOfMultiGuardedSection(GuardedSection guardedSection) {
        return guardedSection.getName().startsWith("|");
    }

    static Object[] parsePartOfMultiGuardedSection(GuardedSection guardedSection) {
        assert (MultiGuardedSection.isPartOfMultiGuardedSection(guardedSection));
        String string = guardedSection.getName();
        Object[] objectArray = new Object[3];
        int n = string.indexOf(124, 1);
        assert (n >= 1);
        objectArray[0] = string.substring(1, n);
        int n2 = string.indexOf(124, ++n);
        assert (n2 >= 1);
        objectArray[1] = Integer.parseInt(string.substring(n, n2));
        objectArray[2] = string.substring(++n2);
        return objectArray;
    }

    public static boolean matches(GuardedSection guardedSection, String string, int n) {
        Object[] objectArray = MultiGuardedSection.parsePartOfMultiGuardedSection(guardedSection);
        return string.equals(objectArray[0]) && n == (Integer)objectArray[1];
    }

    public static boolean matches(GuardedSection guardedSection, String string, String string2) {
        Object[] objectArray = MultiGuardedSection.parsePartOfMultiGuardedSection(guardedSection);
        return string.equals(objectArray[0]) && string2.equals(objectArray[2]);
    }

    static GuardedSection findNextPartOfMultiGuardedSectionAfter(StyledDocument styledDocument, Object[] objectArray) {
        GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        return CodeUtils.findSectionByPrefix(guardedSectionManager.getGuardedSections(), MultiGuardedSection.createSectionID((String)objectArray[0], (Integer)objectArray[1] + 1, null));
    }

    public static void remove(StyledDocument styledDocument, String string) {
        Iterable iterable = GuardedSectionManager.getInstance((StyledDocument)styledDocument).getGuardedSections();
        ArrayList<SimpleSection> arrayList = CodeUtils.findSectionsByPrefix(iterable, MultiGuardedSection.createSectionIDPrefix(string));
        CodeUtils.sortSections(arrayList);
        Iterator<SimpleSection> iterator = arrayList.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        SimpleSection simpleSection = iterator.next();
        ArrayList<SimpleSection> arrayList2 = new ArrayList<SimpleSection>();
        arrayList2.add(simpleSection);
        int n = (Integer)MultiGuardedSection.parsePartOfMultiGuardedSection((GuardedSection)simpleSection)[1];
        while (iterator.hasNext()) {
            SimpleSection simpleSection2 = iterator.next();
            int n2 = (Integer)MultiGuardedSection.parsePartOfMultiGuardedSection((GuardedSection)simpleSection2)[1];
            if (n + 1 != n2) {
                MultiGuardedSection.removeSectionsBlock(styledDocument, arrayList2);
                Debug.warning((Object[])new Object[]{"Broken multi-guarded-section", "Missing sections between", n, n2});
            }
            arrayList2.add(simpleSection2);
            n = n2;
        }
        MultiGuardedSection.removeSectionsBlock(styledDocument, arrayList2);
    }

    private static void removeSectionsBlock(StyledDocument styledDocument, ArrayList<SimpleSection> arrayList) {
        Position position = arrayList.get(0).getStartPosition();
        Position position2 = arrayList.get(arrayList.size() - 1).getEndPosition();
        for (SimpleSection simpleSection : arrayList) {
            simpleSection.removeSection();
        }
        try {
            styledDocument.remove(position.getOffset(), position2.getOffset() - position.getOffset());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        arrayList.clear();
    }
}

