/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.impl.OQLQueryImpl;
import org.netbeans.modules.profiler.oql.engine.api.impl.Snapshot;

public class OQLEngineImpl {
    private static final Logger LOGGER = Logger.getLogger(OQLEngineImpl.class.getName());
    private static boolean oqlSupported;
    private ScriptEngine engine;
    private Snapshot snapshot;

    public static boolean isOQLSupported() {
        return oqlSupported;
    }

    public OQLEngineImpl(Snapshot snapshot) {
        if (!OQLEngineImpl.isOQLSupported()) {
            throw new UnsupportedOperationException("OQL not supported");
        }
        this.init(snapshot);
    }

    public Snapshot getHeapHelper() {
        return this.snapshot;
    }

    public synchronized void executeQuery(String string, OQLEngine.ObjectVisitor objectVisitor) throws OQLException {
        LOGGER.log(Level.FINE, string);
        OQLEngine.OQLQuery oQLQuery = this.parseQuery(string);
        if (oQLQuery == null) {
            try {
                Object object = this.evalScript(string);
                this.dispatchValue(object, objectVisitor);
            }
            catch (Exception exception) {
                throw new OQLException(exception);
            }
            return;
        }
        this.executeQuery((OQLQueryImpl)oQLQuery, objectVisitor);
    }

    public OQLEngine.OQLQuery parseQuery(String string) throws OQLException {
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (!string3.equals("select")) {
                return null;
            }
        } else {
            throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_NO_SELECT_CLAUSE"));
        }
        string3 = "";
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("from")) {
                bl = true;
                break;
            }
            string3 = string3 + " " + string2;
        }
        if (string3.equals("")) {
            throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_EMPTY_SELECT"));
        }
        string2 = null;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        if (bl) {
            String string6;
            if (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
                if (string6.equals("instanceof")) {
                    bl2 = true;
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_INSTANCEOF_NO_CLASSNAME"));
                    }
                    string2 = stringTokenizer.nextToken();
                } else {
                    string2 = string6;
                }
            } else {
                throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_FROM_NO_CLASSNAME"));
            }
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                if (string5.equals("where")) {
                    throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_NO_IDENTIFIER"));
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                    if (!string6.equals("where")) {
                        throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_EXPECTING_WHERE"));
                    }
                    string4 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = string4 + " " + stringTokenizer.nextToken();
                    }
                    if (string4.equals("")) {
                        throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_EMPTY_WHERE"));
                    }
                }
            } else {
                throw new OQLException(ResourceBundle.getBundle("org/netbeans/modules/profiler/oql/engine/api/impl/Bundle").getString("ERROR_NO_IDENTIFIER"));
            }
        }
        return new OQLQueryImpl(string3, bl2, string2, string5, string4);
    }

    private void executeQuery(OQLQueryImpl oQLQueryImpl, OQLEngine.ObjectVisitor objectVisitor) throws OQLException {
        CharSequence charSequence;
        objectVisitor = objectVisitor != null ? objectVisitor : OQLEngine.ObjectVisitor.DEFAULT;
        JavaClass javaClass = null;
        if (oQLQueryImpl.className != null && (javaClass = this.snapshot.findClass((String)(charSequence = oQLQueryImpl.className))) == null) {
            throw new OQLException((String)charSequence + " is not found!");
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("function __select__(");
        if (oQLQueryImpl.identifier != null) {
            ((StringBuffer)charSequence).append(oQLQueryImpl.identifier);
        }
        ((StringBuffer)charSequence).append(") { return ");
        ((StringBuffer)charSequence).append(oQLQueryImpl.selectExpr.replace('\n', ' '));
        ((StringBuffer)charSequence).append("; }\n");
        ((StringBuffer)charSequence).append("__select__(" + oQLQueryImpl.identifier + ")");
        String string = ((StringBuffer)charSequence).toString();
        try {
            Bindings bindings = this.engine.getBindings(100);
            CompiledScript compiledScript = null;
            CompiledScript compiledScript2 = null;
            compiledScript2 = ((Compilable)((Object)this.engine)).compile(string);
            if (oQLQueryImpl.whereExpr != null) {
                compiledScript = ((Compilable)((Object)this.engine)).compile(oQLQueryImpl.whereExpr.replace('\n', ' '));
            }
            if (oQLQueryImpl.className != null) {
                Stack<Object> stack = new Stack<Object>();
                HashSet hashSet = new HashSet();
                stack.push(javaClass);
                Object e = null;
                while (!stack.isEmpty()) {
                    Iterator iterator2;
                    e = stack.pop();
                    hashSet.add(e);
                    JavaClass javaClass2 = (JavaClass)e;
                    if (oQLQueryImpl.isInstanceOf) {
                        for (Iterator iterator2 : javaClass2.getSubClasses()) {
                            if (hashSet.contains(iterator2) || stack.contains(iterator2)) continue;
                            stack.push(iterator2);
                        }
                    }
                    List list = javaClass2.getInstances();
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        Object object;
                        boolean bl;
                        Object e2 = iterator2.next();
                        Object object2 = this.wrapJavaObject((Instance)e2);
                        boolean bl2 = bl = compiledScript == null;
                        if (!bl) {
                            bindings.put(oQLQueryImpl.identifier, object2);
                            object = compiledScript.eval(bindings);
                            if (object instanceof Boolean) {
                                bl = (Boolean)object;
                            } else if (object instanceof Number) {
                                bl = ((Number)object).intValue() != 0;
                            } else {
                                boolean bl3 = bl = object != null;
                            }
                        }
                        if (!bl) continue;
                        bindings.put(oQLQueryImpl.identifier, object2);
                        object = compiledScript2.eval(bindings);
                        if (!this.dispatchValue(object, objectVisitor)) continue;
                        return;
                    }
                }
            } else {
                Object object = compiledScript2.eval();
                if (this.dispatchValue(object, objectVisitor)) {
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new OQLException(exception);
        }
    }

    private boolean dispatchValue(Object object, OQLEngine.ObjectVisitor objectVisitor) {
        if (object == null) {
            return false;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (!this.dispatchValue(iterator.next(), objectVisitor)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!this.dispatchValue(e, objectVisitor)) continue;
                return true;
            }
            return false;
        }
        Object object2 = this.unwrapJavaObject(object, true);
        if (object2 instanceof Object[]) {
            for (Object object3 : (Object[])object2) {
                if (!this.dispatchValue(object3, objectVisitor)) continue;
                return true;
            }
            return false;
        }
        return objectVisitor.visit(object2);
    }

    public Object evalScript(String string) throws Exception {
        CompiledScript compiledScript = ((Compilable)((Object)this.engine)).compile(string);
        return compiledScript.eval();
    }

    public Object wrapJavaObject(Instance instance) throws Exception {
        return this.call("wrapJavaObject", new Object[]{instance});
    }

    public Object toHtml(Object object) throws Exception {
        return this.call("toHtml", new Object[]{object});
    }

    public Object call(String string, Object[] objectArray) throws Exception {
        return ((Invocable)((Object)this.engine)).invokeFunction(string, objectArray);
    }

    public Object unwrapJavaObject(Object object) {
        return this.unwrapJavaObject(object, false);
    }

    public Object unwrapJavaObject(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        boolean bl2 = object.getClass().getName().contains(".javascript.");
        try {
            Object object2 = ((Invocable)((Object)this.engine)).invokeFunction("unwrapJavaObject", object);
            if (bl2 && (object2 == null || object2 == object) && bl) {
                object2 = ((Invocable)((Object)this.engine)).invokeFunction("unwrapMap", object);
            }
            return object2;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error unwrapping JS object", exception);
            return null;
        }
    }

    private void init(Snapshot snapshot) throws RuntimeException {
        this.snapshot = snapshot;
        try {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            this.engine = scriptEngineManager.getEngineByName("JavaScript");
            InputStream inputStream = this.getInitStream();
            CompiledScript compiledScript = ((Compilable)((Object)this.engine)).compile(new InputStreamReader(inputStream));
            compiledScript.eval();
            Object object = ((Invocable)((Object)this.engine)).invokeFunction("wrapHeapSnapshot", snapshot);
            this.engine.put("heap", object);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error initializing snapshot", exception);
            throw new RuntimeException(exception);
        }
    }

    private InputStream getInitStream() {
        return this.getClass().getResourceAsStream("/org/netbeans/modules/profiler/oql/engine/api/impl/hat.js");
    }

    static {
        try {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
            oqlSupported = scriptEngine != null;
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.INFO, "OQLEngine init", throwable);
            oqlSupported = false;
        }
    }
}

