/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatJaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String[] SHARED_METRO_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String[] GLOBAL_METRO_LIBS = new String[]{"lib/webservices-rt.jar", "lib/webservices-tools.jar"};
    private int TOOLS_JAR_INDEX = 1;
    private static final String KEYSTORE_LOCATION = "certs/server-keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "certs/server-truststore.jks";
    private static final String KEYSTORE_CLIENT_LOCATION = "certs/client-keystore.jks";
    private static final String TRUSTSTORE_CLIENT_LOCATION = "certs/client-truststore.jks";
    private File catalinaHome;
    private String version;
    private JaxWs jaxWs;

    public TomcatJaxWsStack(File file) {
        this.catalinaHome = file;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.4";
            }
        }
        catch (IOException iOException) {
            this.version = "2.1.4";
        }
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return WSStackFactory.createWSStackVersion((String)this.version);
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (tool == JaxWs.Tool.WSIMPORT && this.isWsit()) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (tool == JaxWs.Tool.WSGEN && this.isWsit()) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.TESTER_PAGE) {
            return true;
        }
        if (feature == JaxWs.Feature.WSIT) {
            return this.isWsit();
        }
        return false;
    }

    private boolean isWsit() {
        return this.isWsit(true) || this.isWsit(false);
    }

    private boolean isWsit(boolean bl) {
        String[] stringArray = bl ? SHARED_METRO_LIBS : GLOBAL_METRO_LIBS;
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (new File(this.catalinaHome, stringArray[i]).exists()) continue;
            bl2 = false;
        }
        return bl2;
    }

    private String[] getDetectedMetroLibs() {
        return this.isWsit(false) ? GLOBAL_METRO_LIBS : SHARED_METRO_LIBS;
    }

    private boolean isKeystore() {
        return new File(this.catalinaHome, KEYSTORE_LOCATION).exists();
    }

    private boolean isKeystoreClient() {
        return new File(this.catalinaHome, KEYSTORE_CLIENT_LOCATION).exists();
    }

    private boolean isTruststore() {
        return new File(this.catalinaHome, TRUSTSTORE_LOCATION).exists();
    }

    private boolean isTruststoreClient() {
        return new File(this.catalinaHome, TRUSTSTORE_CLIENT_LOCATION).exists();
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        String[] stringArray = this.getDetectedMetroLibs();
        File file = new File(this.catalinaHome, stringArray[this.TOOLS_JAR_INDEX]);
        if (file.exists() && (jarEntry = (jarFile = new JarFile(file)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (!string3.startsWith("major-version=")) continue;
                string2 = string3.substring(14);
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }
        };
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            String[] stringArray = TomcatJaxWsStack.this.getDetectedMetroLibs();
            URL[] uRLArray = new URL[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    uRLArray[i] = new File(TomcatJaxWsStack.this.catalinaHome, stringArray[i]).toURI().toURL();
                }
                return uRLArray;
            }
            catch (MalformedURLException malformedURLException) {
                return new URL[0];
            }
        }
    }
}

