/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboModel;
import org.netbeans.modules.bugtracking.util.RepositoryComboRenderer;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class RepositoryComboSupport
implements ItemListener,
Runnable {
    static final String LOADING_REPOSITORIES = "loading";
    static final String NO_REPOSITORIES = "no repositories";
    static final String SELECT_REPOSITORY = "select";
    private static final Logger LOG = Logger.getLogger(RepositoryComboSupport.class.getName());
    private final JComboBox comboBox;
    private final File refFile;
    private final boolean preselectSingleRepo;
    private RepositoryComboModel comboBoxModel;
    private DisplayabilityListener displayabilityListener;
    private boolean shutdown;
    private boolean repositoriesDisplayed = false;
    private boolean defaultRepoSelected = false;
    private volatile Node[] selectedNodes;
    private volatile Repository[] repositories;
    private volatile boolean defaultRepoComputationPending;
    private volatile Repository defaultRepo;
    private final ThreadLocal<Progress> progress = new ThreadLocal();
    private volatile ChangeListener progressListener;

    public static RepositoryComboSupport setup(JComponent jComponent, JComboBox jComboBox, boolean bl) {
        RepositoryComboSupport repositoryComboSupport = new RepositoryComboSupport(jComboBox, null, null, bl);
        if (jComponent != null) {
            repositoryComboSupport.setupDisplayabilityTrigger(jComponent);
        }
        return repositoryComboSupport;
    }

    public static RepositoryComboSupport setup(JComponent jComponent, JComboBox jComboBox, Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("default repository must be specified");
        }
        RepositoryComboSupport repositoryComboSupport = new RepositoryComboSupport(jComboBox, repository, null, false);
        if (jComponent != null) {
            repositoryComboSupport.setupDisplayabilityTrigger(jComponent);
        }
        return repositoryComboSupport;
    }

    public static RepositoryComboSupport setup(JComponent jComponent, JComboBox jComboBox, File file) {
        if (file == null) {
            throw new IllegalArgumentException("reference file must be specified");
        }
        RepositoryComboSupport repositoryComboSupport = new RepositoryComboSupport(jComboBox, null, file, false);
        if (jComponent != null) {
            repositoryComboSupport.setupDisplayabilityTrigger(jComponent);
        }
        return repositoryComboSupport;
    }

    private RepositoryComboSupport(JComboBox jComboBox, Repository repository, File file, boolean bl) {
        if (jComboBox == null) {
            throw new IllegalArgumentException("combo-box must be specified");
        }
        this.checkAtMostOneSpecified(repository, file);
        this.comboBox = jComboBox;
        this.defaultRepo = repository;
        this.refFile = file;
        this.preselectSingleRepo = bl;
        this.defaultRepoComputationPending = repository == null;
        this.progress.set(Progress.INITIALIZED);
    }

    private void checkOldComboBoxModel(JComboBox jComboBox) {
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        if (comboBoxModel != null && comboBoxModel.getSize() != 0) {
            throw new IllegalStateException("The combo-box must be empty.");
        }
    }

    private void setComboBoxData(Object[] objectArray) {
        this.comboBox.setPopupVisible(false);
        this.comboBoxModel.setData(objectArray);
    }

    private void checkAtMostOneSpecified(Object ... objectArray) {
        boolean bl = false;
        for (Object object : objectArray) {
            if (object == null) continue;
            if (bl) {
                throw new IllegalArgumentException("At most one item may be specified.");
            }
            bl = true;
        }
    }

    void start() {
        assert (EventQueue.isDispatchThread());
        LOG.finer("start()");
        if (this.defaultRepo == null && this.refFile == null) {
            Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
            if (nodeArray == null) {
                nodeArray = new Node[]{};
            }
            this.selectedNodes = nodeArray;
        }
        this.checkOldComboBoxModel(this.comboBox);
        this.comboBoxModel = new RepositoryComboModel();
        this.comboBox.setModel(this.comboBoxModel);
        this.comboBox.setRenderer(new RepositoryComboRenderer());
        this.setComboBoxData(new Object[]{LOADING_REPOSITORIES});
        this.updateProgress(Progress.STARTED);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    private void shutdown() {
        assert (EventQueue.isDispatchThread());
        LOG.finer("shutdown()");
        this.shutdownDisplayabilityTrigger();
        this.comboBox.removeItemListener(this);
        this.shutdown = true;
    }

    private void setupDisplayabilityTrigger(Component component) {
        assert (EventQueue.isDispatchThread());
        LOG.finer("setupDisplayabilityTrigger(Component)");
        if (component.isDisplayable()) {
            throw new IllegalStateException("The trigger component must not be initially displayable.");
        }
        this.displayabilityListener = new DisplayabilityListener(component);
        component.addHierarchyListener(this.displayabilityListener);
    }

    private void shutdownDisplayabilityTrigger() {
        assert (EventQueue.isDispatchThread());
        LOG.finer("shutdownDisplayabilityTrigger()");
        if (this.displayabilityListener != null) {
            this.displayabilityListener.dispose();
            this.displayabilityListener = null;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2 && itemEvent.getItem() == SELECT_REPOSITORY && this.comboBox.getItemAt(0) == SELECT_REPOSITORY) {
            if (this.comboBox.isPopupVisible()) {
                this.comboBox.removeItemListener(this);
                this.comboBox.addPopupMenuListener(new PopupMenuListener(){

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                        RepositoryComboSupport.this.comboBox.addItemListener(RepositoryComboSupport.this);
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                        RepositoryComboSupport.this.comboBox.addItemListener(RepositoryComboSupport.this);
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                        if (RepositoryComboSupport.this.comboBox.getSelectedItem() != RepositoryComboSupport.SELECT_REPOSITORY) {
                            RepositoryComboSupport.this.comboBoxModel.removeElementAt(0);
                        } else {
                            RepositoryComboSupport.this.comboBox.addItemListener(RepositoryComboSupport.this);
                        }
                    }
                });
            } else {
                this.comboBoxModel.removeElementAt(0);
                this.comboBox.removeItemListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (RequestProcessor.getDefault().isRequestProcessorThread()) {
            this.loadRepositories();
            if (this.defaultRepoComputationPending) {
                if (this.repositories.length == 0) {
                    this.defaultRepoComputationPending = false;
                } else if (this.repositories.length == 1 && this.preselectSingleRepo) {
                    this.defaultRepo = this.repositories[0];
                    this.defaultRepoComputationPending = false;
                }
            }
            this.updateProgress(Progress.WILL_SCHEDULE_DISPLAY_OF_REPOS);
            EventQueue.invokeLater(this);
            this.updateProgress(Progress.SCHEDULED_DISPLAY_OF_REPOS);
            if (this.defaultRepoComputationPending) {
                try {
                    this.findDefaultRepository();
                }
                finally {
                    this.defaultRepoComputationPending = false;
                }
                if (this.defaultRepo != null) {
                    this.updateProgress(Progress.WILL_SCHEDULE_SELECTION_OF_DEFAULT_REPO);
                    EventQueue.invokeLater(this);
                    this.updateProgress(Progress.SCHEDULED_SELECTION_OF_DEFAULT_REPO);
                }
            }
            this.notifyProgressDone();
        } else {
            this.doGuiJob();
        }
    }

    private void doGuiJob() {
        assert (EventQueue.isDispatchThread());
        if (this.repositoriesDisplayed && this.defaultRepoSelected) {
            LOG.finest("run() called from AWT - nothing to do - all work already done");
            return;
        }
        if (this.shutdown) {
            LOG.finest(" - too late - the component has been already closed");
            return;
        }
        this.shutdownDisplayabilityTrigger();
        if (!this.repositoriesDisplayed) {
            this.displayRepositories();
        } else {
            this.selectDefaultRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayRepositories() {
        this.updateProgress(Progress.WILL_DISPLAY_REPOS);
        boolean bl = this.defaultRepoComputationPending;
        Repository repository = bl ? null : this.defaultRepo;
        LOG.finest("going to display the list of repositories");
        if (repository != null && LOG.isLoggable(Level.FINEST)) {
            LOG.finest("  - default repository: " + repository.getDisplayName());
        }
        try {
            this.setRepositories(this.repositories, repository);
            this.repositoriesDisplayed = true;
            this.defaultRepoSelected = !bl;
        }
        catch (Throwable throwable) {
            this.repositoriesDisplayed = true;
            this.defaultRepoSelected = !bl;
            this.updateProgress(Progress.DISPLAYED_REPOS);
            throw throwable;
        }
        this.updateProgress(Progress.DISPLAYED_REPOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectDefaultRepository() {
        assert (!this.defaultRepoComputationPending && this.defaultRepo != null);
        LOG.finest("going to select the default repository");
        this.updateProgress(Progress.WILL_SELECT_DEFAULT_REPO);
        try {
            if (this.comboBox.getSelectedItem() instanceof Repository && !this.comboBox.isPopupVisible()) {
            } else {
                this.preselectRepository(this.defaultRepo);
            }
        }
        finally {
            this.defaultRepoSelected = true;
            this.updateProgress(Progress.SELECTED_DEFAULT_REPO);
        }
    }

    private void preselectRepository(final Repository repository) {
        assert (EventQueue.isDispatchThread());
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("preselectRepository(" + repository.getDisplayName() + ')');
        }
        if (this.comboBox.isPopupVisible()) {
            LOG.finest(" - the popup is visible - deferred");
            this.comboBox.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    LOG.finer("popupMenuWillBecomeInvisible()");
                    RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    LOG.finer("popupMenuCanceled()");
                    RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                    LOG.finest(" - processing deferred selection");
                    RepositoryComboSupport.this.preselectItemUnconditionally(repository);
                }
            });
        } else {
            this.preselectItemUnconditionally(repository);
        }
    }

    private void preselectItemUnconditionally(Object object) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("preselectItemUnconditionally(" + RepositoryComboSupport.getItemName(object) + ')');
        }
        this.comboBox.setSelectedItem(object);
    }

    private static String getItemName(Object object) {
        if (object instanceof Repository) {
            return ((Repository)object).getDisplayName();
        }
        return object.toString();
    }

    private void setRepositories(Repository[] repositoryArray, Repository repository) {
        Object[] objectArray;
        assert (EventQueue.isDispatchThread());
        int n = repositoryArray != null ? repositoryArray.length : 0;
        int n2 = 0;
        if (n == 0) {
            objectArray = new Object[]{NO_REPOSITORIES};
        } else if (repository == null) {
            objectArray = new Object[n + 1];
            objectArray[n2++] = SELECT_REPOSITORY;
        } else {
            objectArray = new Object[n];
        }
        if (n != 0) {
            System.arraycopy(repositoryArray, 0, objectArray, n2, n);
        }
        this.setComboBoxData(objectArray);
        if (repository != null) {
            this.comboBox.setSelectedItem(repository);
        } else if (n != 0) {
            assert (this.comboBox.getSelectedItem() == SELECT_REPOSITORY);
            this.comboBox.addItemListener(this);
        }
    }

    private void refreshComboBoxData(Repository[] repositoryArray) {
        Object[] objectArray;
        if (repositoryArray.length == 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = NO_REPOSITORIES;
        } else {
            objectArray = repositoryArray;
        }
        this.setComboBoxData(objectArray);
    }

    public void refreshRepositoryModel() {
        LOG.finer("refreshRepositoryModel()");
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                    RepositoryComboSupport.this.loadRepositories();
                    EventQueue.invokeLater(this);
                } else {
                    assert (EventQueue.isDispatchThread());
                    RepositoryComboSupport.this.refreshComboBoxData(RepositoryComboSupport.this.repositories);
                }
            }
        });
    }

    private void loadRepositories() {
        assert (RequestProcessor.getDefault().isRequestProcessorThread());
        LOG.finer("loadRepositories()");
        this.updateProgress(Progress.WILL_LOAD_REPOS);
        long l = System.currentTimeMillis();
        this.repositories = BugtrackingUtil.getKnownRepositories();
        long l2 = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BugtrackingUtil.getKnownRepositories() took " + (l2 - l) + " ms.");
        }
        this.updateProgress(Progress.LOADED_REPOS);
    }

    private void findDefaultRepository() {
        Repository repository;
        assert (RequestProcessor.getDefault().isRequestProcessorThread());
        LOG.finer("findDefaultRepository()");
        this.updateProgress(Progress.WILL_DETERMINE_DEFAULT_REPO);
        long l = System.currentTimeMillis();
        assert (this.refFile == null ^ this.selectedNodes == null);
        if (this.refFile != null) {
            repository = BugtrackingOwnerSupport.getInstance().getRepository(this.refFile, false);
        } else {
            assert (this.selectedNodes != null);
            repository = BugtrackingOwnerSupport.getInstance().getRepository(this.selectedNodes);
        }
        long l2 = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BugtrackingOwnerSupport.getRepository(...) took " + (l2 - l) + " ms.");
        }
        if (repository != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - default repository: " + repository.getDisplayName());
            }
            this.defaultRepo = repository;
        } else {
            LOG.finest(" - default repository: <null>");
        }
        this.updateProgress(Progress.DETERMINED_DEFAULT_REPO);
    }

    private void notifyProgressDone() {
        if (this.progressListener != null) {
            assert (!EventQueue.isDispatchThread());
            Runnable runnable = new Runnable(){

                public void run() {
                    RepositoryComboSupport.this.updateProgress(Progress.THREAD_PROGRESS_DONE);
                }
            };
            runnable.run();
            EventQueue.invokeLater(runnable);
        }
    }

    private void updateProgress(Progress progress) {
        this.progress.set(progress);
        this.fireProgressChange();
    }

    private void fireProgressChange() {
        if (this.progressListener != null) {
            this.progressListener.stateChanged(new ChangeEvent(this));
        }
    }

    void setProgressListener(ChangeListener changeListener) {
        this.progressListener = changeListener;
    }

    Progress getProgress() {
        return this.progress.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Progress {
        INITIALIZED,
        STARTED,
        WILL_LOAD_REPOS,
        LOADED_REPOS,
        WILL_SCHEDULE_DISPLAY_OF_REPOS,
        SCHEDULED_DISPLAY_OF_REPOS,
        WILL_DISPLAY_REPOS,
        DISPLAYED_REPOS,
        WILL_DETERMINE_DEFAULT_REPO,
        DETERMINED_DEFAULT_REPO,
        WILL_SCHEDULE_SELECTION_OF_DEFAULT_REPO,
        SCHEDULED_SELECTION_OF_DEFAULT_REPO,
        WILL_SELECT_DEFAULT_REPO,
        SELECTED_DEFAULT_REPO,
        WILL_DISPLAY_REPOS_AND_SELECT_DEFAULT,
        DISPLAYED_REPOS_AND_SELECTED_DEFAULT,
        THREAD_PROGRESS_DONE;

    }

    private final class DisplayabilityListener
    implements HierarchyListener {
        private final Component triggerComponent;

        private DisplayabilityListener(Component component) {
            this.triggerComponent = component;
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) == 0L) {
                return;
            }
            assert (hierarchyEvent.getChanged() == this.triggerComponent);
            if (this.triggerComponent.isDisplayable()) {
                LOG.finer("trigger component became displayable");
                RepositoryComboSupport.this.start();
            } else {
                LOG.finer("trigger component became non-displayable");
                RepositoryComboSupport.this.shutdown();
            }
        }

        private void dispose() {
            this.triggerComponent.removeHierarchyListener(this);
        }
    }
}

