/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingOptionsPanel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class BugtrackingOptions
extends OptionsPanelController {
    private BugtrackingOptionsPanel panel;
    private boolean initialized = false;
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();

    public BugtrackingOptions() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.panel = new BugtrackingOptionsPanel();
        Lookup lookup = Lookups.forPath((String)"BugtrackingOptionsDialog");
        for (AdvancedOption advancedOption : lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
            String string = advancedOption.getDisplayName();
            OptionsPanelController optionsPanelController = advancedOption.create();
            this.categoryToController.put(string, optionsPanelController);
        }
    }

    public JComponent getComponent(Lookup lookup) {
        for (Map.Entry<String, OptionsPanelController> entry : this.categoryToController.entrySet()) {
            this.panel.addPanel(entry.getKey(), entry.getValue().getComponent(lookup));
        }
        return this.panel;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (OptionsPanelController optionsPanelController : this.categoryToController.values()) {
            optionsPanelController.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (OptionsPanelController optionsPanelController : this.categoryToController.values()) {
            optionsPanelController.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void update() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().update();
        }
    }

    public void applyChanges() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().applyChanges();
        }
    }

    public void cancel() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().cancel();
        }
    }

    public boolean isValid() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isChanged()) continue;
            return true;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BugtrackingOptions.class);
    }
}

