/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingConfig;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IssueStorage {
    private static IssueStorage instance;
    private File storage;
    private static final String STORAGE_FILE = "storage";
    private static final String STORAGE_VERSION_1_0 = "1.0";
    private static final String STORAGE_VERSION_1_1 = "1.1";
    private static final String STORAGE_VERSION = "1.1";
    private String QUERY_ARCHIVED_SUFIX = ".qa";
    private String QUERY_SUFIX = ".q";
    private String ISSUE_SUFIX = ".i";
    private final Map<String, Object> referenceTimeLocks = new HashMap<String, Object>();

    private IssueStorage() {
    }

    public static IssueStorage getInstance() {
        if (instance == null) {
            instance = new IssueStorage();
            instance.initStorage();
        }
        return instance;
    }

    private void initStorage() {
        this.storage = this.getStorageRootFile();
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
        this.writeStorage();
        RequestProcessor.Task task = BugtrackingManager.getInstance().getRequestProcessor().create(new Runnable(){

            public void run() {
                IssueStorage.this.cleanup();
            }
        });
        task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    long getReferenceTime(String string) throws IOException {
        Object object;
        long l;
        DataOutputStream dataOutputStream;
        long l2;
        File file;
        block47: {
            block44: {
                Object object2;
                long l3;
                DataInputStream dataInputStream;
                block45: {
                    File file2 = this.getNameSpaceFolder(string);
                    file = new File(file2, "data");
                    Object object3 = null;
                    Object object4 = this.referenceTimeLocks;
                    // MONITORENTER : object4
                    object3 = this.referenceTimeLocks.get(file.getAbsolutePath());
                    if (object3 == null) {
                        object3 = new Object();
                    }
                    this.referenceTimeLocks.put(file.getAbsolutePath(), object3);
                    // MONITOREXIT : object4
                    object4 = object3;
                    // MONITORENTER : object4
                    l2 = -1L;
                    if (!file.exists()) break block44;
                    dataInputStream = null;
                    dataInputStream = this.getDataInputStream(file);
                    l3 = l2 = dataInputStream.readLong();
                    if (!BugtrackingManager.LOG.isLoggable(Level.FINE)) break block45;
                    object2 = l2 > -1L ? new SimpleDateFormat().format(new Date(l2)) : "null";
                    BugtrackingManager.LOG.log(Level.FINE, "finished reading greference time {0} - {1}", new Object[]{string, object2});
                }
                try {
                    if (dataInputStream != null) {
                        dataInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                object2 = this.referenceTimeLocks;
                // MONITORENTER : object2
                this.referenceTimeLocks.remove(file.getAbsolutePath());
                // MONITOREXIT : object2
                return l3;
                catch (EOFException eOFException) {
                    Object object5;
                    long l4;
                    block46: {
                        BugtrackingManager.LOG.log(Level.SEVERE, file.getAbsolutePath(), eOFException);
                        l4 = -1L;
                        if (!BugtrackingManager.LOG.isLoggable(Level.FINE)) break block46;
                        object5 = l2 > -1L ? new SimpleDateFormat().format(new Date(l2)) : "null";
                        {
                            catch (Throwable throwable) {
                                if (BugtrackingManager.LOG.isLoggable(Level.FINE)) {
                                    String string2 = l2 > -1L ? new SimpleDateFormat().format(new Date(l2)) : "null";
                                    BugtrackingManager.LOG.log(Level.FINE, "finished reading greference time {0} - {1}", new Object[]{string, string2});
                                }
                                try {
                                    if (dataInputStream == null) throw throwable;
                                    dataInputStream.close();
                                    throw throwable;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        BugtrackingManager.LOG.log(Level.FINE, "finished reading greference time {0} - {1}", new Object[]{string, object5});
                    }
                    try {
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    object5 = this.referenceTimeLocks;
                    // MONITORENTER : object5
                    this.referenceTimeLocks.remove(file.getAbsolutePath());
                    // MONITOREXIT : object5
                    return l4;
                    catch (InterruptedException interruptedException) {
                        BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                        IOException iOException = new IOException(interruptedException.getMessage());
                        iOException.initCause(interruptedException);
                        throw iOException;
                    }
                }
                {
                    catch (Throwable throwable) {
                        Map<String, Object> map = this.referenceTimeLocks;
                        // MONITORENTER : map
                        this.referenceTimeLocks.remove(file.getAbsolutePath());
                        // MONITOREXIT : map
                        throw throwable;
                    }
                }
            }
            file.createNewFile();
            l2 = System.currentTimeMillis();
            dataOutputStream = null;
            dataOutputStream = this.getDataOutputStream(file, false);
            dataOutputStream.writeLong(l2);
            l = l2;
            if (!BugtrackingManager.LOG.isLoggable(Level.FINE)) break block47;
            object = l2 > -1L ? new SimpleDateFormat().format(new Date(l2)) : "null";
            BugtrackingManager.LOG.log(Level.FINE, "finished writing greference time {0} - {1}", new Object[]{string, object});
        }
        try {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.referenceTimeLocks;
        // MONITORENTER : object
        this.referenceTimeLocks.remove(file.getAbsolutePath());
        // MONITOREXIT : object
        return l;
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                if (BugtrackingManager.LOG.isLoggable(Level.FINE)) {
                    String string3 = l2 > -1L ? new SimpleDateFormat().format(new Date(l2)) : "null";
                    BugtrackingManager.LOG.log(Level.FINE, "finished writing greference time {0} - {1}", new Object[]{string, string3});
                }
                try {
                    if (dataOutputStream == null) throw throwable;
                    dataOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void storeIssue(String string, IssueCache.IssueEntry issueEntry) throws IOException {
        block27: {
            DataOutputStream dataOutputStream;
            InputStream inputStream;
            block26: {
                block25: {
                    assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
                    BugtrackingManager.LOG.log(Level.FINE, "start storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                    inputStream = null;
                    dataOutputStream = null;
                    dataOutputStream = this.getIssueOutputStream(this.getNameSpaceFolder(string), issueEntry.getId());
                    if (dataOutputStream != null) break block25;
                    BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                dataOutputStream.writeBoolean(issueEntry.wasSeen());
                dataOutputStream.writeLong(issueEntry.getLastSeenModified());
                dataOutputStream.writeInt(issueEntry.getLastUnseenStatus());
                if (issueEntry.getSeenAttributes() == null) break block26;
                for (Map.Entry<String, String> entry : issueEntry.getSeenAttributes().entrySet()) {
                    this.writeString(dataOutputStream, entry.getKey());
                    this.writeString(dataOutputStream, entry.getValue());
                }
            }
            BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block27;
            }
            catch (IOException iOException) {}
            break block27;
            catch (InterruptedException interruptedException) {
                try {
                    BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                    IOException iOException = new IOException(interruptedException.getMessage());
                    iOException.initCause(interruptedException);
                    throw iOException;
                }
                catch (Throwable throwable) {
                    BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public void readIssue(String string, IssueCache.IssueEntry issueEntry) throws IOException {
        DataInputStream dataInputStream;
        block19: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
            dataInputStream = null;
            dataInputStream = this.getIssueInputStream(this.getNameSpaceFolder(string), issueEntry.getId());
            if (dataInputStream != null) break block19;
            BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            boolean bl = dataInputStream.readBoolean();
            long l = -1L;
            int n = 0;
            if (!"1.1".equals(STORAGE_VERSION_1_0)) {
                l = dataInputStream.readLong();
                n = dataInputStream.readInt();
            }
            try {
                while (true) {
                    String string2 = IssueStorage.readString(dataInputStream);
                    String string3 = IssueStorage.readString(dataInputStream);
                    hashMap.put(string2, string3);
                }
            }
            catch (EOFException eOFException) {
                issueEntry.setSeenAttributes(hashMap);
                issueEntry.setSeen(bl);
                issueEntry.setLastSeenModified(l);
                issueEntry.setLastUnseenStatus(n);
                BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public List<String> readQuery(String string, String string2) throws IOException {
        List<String> list;
        File file;
        block6: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start reading query {0} - {1}", new Object[]{string, string2});
            file = this.getNameSpaceFolder(string);
            if (file.exists()) break block6;
            List<String> list2 = Collections.emptyList();
            BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{string, string2});
            return list2;
        }
        try {
            DataInputStream dataInputStream = this.getQueryInputStream(file, string2, false);
            list = this.readQuery(dataInputStream);
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{string, string2});
        return list;
    }

    private List<String> readQuery(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            String string = null;
            try {
                string = IssueStorage.readString(dataInputStream);
            }
            catch (EOFException eOFException) {
                break;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    long getQueryTimestamp(String string, String string2) {
        File file = this.getNameSpaceFolder(string);
        File file2 = new File(file, TextUtils.encodeURL(string2) + this.QUERY_SUFIX);
        return file2.lastModified();
    }

    public Map<String, Long> readArchivedQueryIssues(String string, String string2) throws IOException {
        Object object;
        Object object2;
        long l;
        long l2;
        block9: {
            File file;
            block8: {
                assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
                BugtrackingManager.LOG.log(Level.FINE, "start reading archived query issues {0} - {1}", new Object[]{string, string2});
                l2 = System.currentTimeMillis();
                l = BugtrackingConfig.getInstance().getArchivedIssuesTTL() * 1000L * 60L * 60L * 24L;
                file = this.getNameSpaceFolder(string);
                if (file.exists()) break block8;
                Map<String, Long> map = Collections.emptyMap();
                BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
                return map;
            }
            object2 = this.getQueryInputStream(file, string2, true);
            if (object2 != null) break block9;
            Map<String, Long> map = Collections.emptyMap();
            BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
            return map;
        }
        try {
            Map<String, Long> map = this.readArchivedQueryIssues((DataInputStream)object2);
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                long l3 = map.get(object);
                if (l3 >= l2 - l) continue;
                iterator.remove();
            }
            object = map;
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                object2 = new IOException(interruptedException.getMessage());
                ((Throwable)object2).initCause(interruptedException);
                throw object2;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
        return object;
    }

    private Map<String, Long> readArchivedQueryIssues(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        while (true) {
            String string = null;
            long l = -1L;
            try {
                string = IssueStorage.readString(dataInputStream);
                l = dataInputStream.readLong();
                hashMap.put(string, l);
            }
            catch (EOFException eOFException) {
                return hashMap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String string, String string2) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start removing query {0} - {1}", new Object[]{string, string2});
        try {
            File file;
            File file2 = this.getNameSpaceFolder(string);
            File file3 = new File(file2, TextUtils.encodeURL(string2) + this.QUERY_SUFIX);
            if (file3.exists()) {
                BugtrackingUtil.deleteRecursively(file3);
            }
            if ((file = new File(file2, TextUtils.encodeURL(string2) + this.QUERY_ARCHIVED_SUFIX)).exists()) {
                BugtrackingUtil.deleteRecursively(file);
            }
        }
        catch (Throwable throwable) {
            BugtrackingManager.LOG.log(Level.FINE, "finished removing query {0} - {1}", new Object[]{string, string2});
            throw throwable;
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished removing query {0} - {1}", new Object[]{string, string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeQuery(String string, String string2, String[] stringArray) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start storing query issues {0} - {1}", new Object[]{string, string2});
        try {
            File file = this.getNameSpaceFolder(string);
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = this.getQueryOutputStream(file, string2, false);
                for (String string3 : stringArray) {
                    this.writeString(dataOutputStream, string3);
                }
                dataOutputStream.flush();
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished storing query issues {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing query issues {0} - {1}", new Object[]{string, string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeArchivedQueryIssues(String string, String string2, String[] stringArray) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start storing archived query issues {0} - {1}", new Object[]{string, string2});
        long l = System.currentTimeMillis();
        Map<String, Long> map = this.readArchivedQueryIssues(string, string2);
        try {
            File file = this.getNameSpaceFolder(string);
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = this.getQueryOutputStream(file, string2, true);
                for (String string3 : stringArray) {
                    this.writeString(dataOutputStream, string3);
                    Long l2 = map.get(string3);
                    if (l2 != null && l2 != -1L) {
                        dataOutputStream.writeLong(l2);
                        continue;
                    }
                    dataOutputStream.writeLong(l);
                }
                dataOutputStream.flush();
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished storing archived query issues {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing archived query issues {0} - {1}", new Object[]{string, string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        try {
            BugtrackingManager.LOG.log(Level.FINE, "starting bugtrackig storage cleanup");
            File file = this.getStorageRootFile();
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                this.cleanup(file2);
            }
        }
        finally {
            BugtrackingManager.LOG.log(Level.FINE, "finnished bugtrackig storage cleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(String string) {
        try {
            BugtrackingManager.LOG.log(Level.FINE, "starting bugtrackig storage cleanup for {0}", new Object[]{string});
            this.cleanup(this.getNameSpaceFolder(string));
        }
        catch (Throwable throwable) {
            BugtrackingManager.LOG.log(Level.FINE, "finnished bugtrackig storage cleanup for {0}", new Object[]{string});
            throw throwable;
        }
        BugtrackingManager.LOG.log(Level.FINE, "finnished bugtrackig storage cleanup for {0}", new Object[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void cleanup(File file) {
        block11: {
            try {
                Object object2;
                BugtrackingManager.LOG.log(Level.FINE, "starting bugtrackig storage cleanup for {0}", new Object[]{file.getAbsoluteFile()});
                HashSet hashSet = new HashSet();
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(IssueStorage.this.QUERY_SUFIX);
                    }
                });
                if (fileArray != null && fileArray.length > 0) {
                    for (File file2 : fileArray) {
                        object2 = this.readQuery(this.getDataInputStream(file2));
                        if (object2 == null || object2.size() == 0) continue;
                        hashSet.addAll(object2);
                    }
                }
                if ((fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(IssueStorage.this.QUERY_ARCHIVED_SUFIX);
                    }
                })) != null) {
                    for (File file2 : fileArray) {
                        object2 = this.readArchivedQueryIssues(this.getDataInputStream(file2));
                        if (object2 == null || object2.size() == 0) continue;
                        hashSet.addAll(object2.keySet());
                    }
                }
                BugtrackingManager.LOG.log(Level.FINER, "living query issues {0}", new Object[]{hashSet});
                File[] fileArray2 = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(IssueStorage.this.ISSUE_SUFIX);
                    }
                });
                if (fileArray2 == null) break block11;
                for (Object object2 : fileArray2) {
                    String string = ((File)object2).getName();
                    if (hashSet.contains(string = string.substring(0, string.length() - this.ISSUE_SUFIX.length()))) continue;
                    BugtrackingManager.LOG.log(Level.FINE, "removing issue {0}", new Object[]{string});
                    ((File)object2).delete();
                }
            }
            catch (IOException iOException) {
                BugtrackingManager.LOG.log(Level.WARNING, null, iOException);
                BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{file.getAbsoluteFile()});
            }
            catch (InterruptedException interruptedException) {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                {
                    catch (Throwable throwable) {
                        BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{file.getAbsoluteFile()});
                        throw throwable;
                    }
                }
                BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{file.getAbsoluteFile()});
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{file.getAbsoluteFile()});
    }

    private File getStorageRootFile() {
        String string = System.getProperty("netbeans.user");
        return new File(new File(string, "var"), "bugtracking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStorage() {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = this.getDataOutputStream(new File(this.storage, STORAGE_FILE), false);
            this.writeString((DataOutputStream)filterOutputStream, "1.1");
            ((DataOutputStream)filterOutputStream).flush();
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.INFO, null, iOException);
        }
        catch (InterruptedException interruptedException) {
            BugtrackingManager.LOG.log(Level.INFO, null, interruptedException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string != null) {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            char c = dataInputStream.readChar();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private DataOutputStream getIssueOutputStream(File file, String string) throws IOException, InterruptedException {
        File file2 = new File(file, string + this.ISSUE_SUFIX);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(this.getFileOutputStream(file2, false)));
        ZipEntry zipEntry = new ZipEntry(file2.getName());
        zipOutputStream.putNextEntry(zipEntry);
        return new DataOutputStream(zipOutputStream);
    }

    private DataInputStream getIssueInputStream(File file, String string) throws IOException, InterruptedException {
        File file2 = new File(file, string + this.ISSUE_SUFIX);
        if (!file2.exists()) {
            return null;
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(this.getFileInputStream(file2)));
        zipInputStream.getNextEntry();
        return new DataInputStream(zipInputStream);
    }

    private DataOutputStream getDataOutputStream(File file, boolean bl) throws IOException, InterruptedException {
        return new DataOutputStream(this.getFileOutputStream(file, bl));
    }

    private DataInputStream getDataInputStream(File file) throws IOException, InterruptedException {
        return new DataInputStream(this.getFileInputStream(file));
    }

    private FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return new FileOutputStream(file, bl);
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }

    private FileInputStream getFileInputStream(File file) throws IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }

    private static void copyStreams(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private File getNameSpaceFolder(String string) {
        File file = new File(this.storage, TextUtils.encodeURL(string));
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private DataOutputStream getQueryOutputStream(File file, String string, boolean bl) throws IOException, InterruptedException {
        File file2 = new File(file, TextUtils.encodeURL(string) + (bl ? this.QUERY_ARCHIVED_SUFIX : this.QUERY_SUFIX));
        return this.getDataOutputStream(file2, false);
    }

    private DataInputStream getQueryInputStream(File file, String string, boolean bl) throws IOException, InterruptedException {
        File file2 = new File(file, TextUtils.encodeURL(string) + (bl ? this.QUERY_ARCHIVED_SUFIX : this.QUERY_SUFIX));
        if (!file2.exists()) {
            return null;
        }
        return this.getDataInputStream(file2);
    }
}

