/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class IssueAction
extends SystemAction {
    public IssueAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(IssueAction.class, (String)"CTL_IssueAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IssueAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IssueAction.openIssue();
    }

    public static void openIssue() {
        IssueAction.openIssue(null, WindowManager.getDefault().getRegistry().getActivatedNodes());
    }

    public static void openIssue(Repository repository) {
        IssueAction.openIssue(repository, WindowManager.getDefault().getRegistry().getActivatedNodes());
    }

    private static void openIssue(final Repository repository, final Node[] nodeArray) {
        final boolean bl = repository != null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = new IssueTopComponent();
                issueTopComponent.initNewIssue(repository, !bl, nodeArray);
                issueTopComponent.open();
                issueTopComponent.requestActive();
            }
        });
    }

    public static void closeIssue(final Issue issue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = IssueTopComponent.find(issue);
                if (issueTopComponent != null) {
                    issueTopComponent.close();
                }
            }
        });
    }
}

