/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.net.URL;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.tasklist.TaskListProvider;

public abstract class IssueProvider {
    protected void add(boolean bl, LazyIssue ... lazyIssueArray) {
        TaskListProvider.getInstance().add(this, bl, lazyIssueArray);
    }

    protected void add(LazyIssue ... lazyIssueArray) {
        this.add(false, lazyIssueArray);
    }

    protected void remove(LazyIssue ... lazyIssueArray) {
        TaskListProvider.getInstance().remove(this, lazyIssueArray);
    }

    protected void removeAll() {
        TaskListProvider.getInstance().removeAll(this);
    }

    public abstract void removed(LazyIssue var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LazyIssue {
        private final URL url;
        private String name;
        private boolean valid;

        public LazyIssue(URL uRL, String string) {
            if (uRL == null) {
                throw new NullPointerException();
            }
            if (string == null) {
                throw new NullPointerException();
            }
            this.url = uRL;
            this.name = string;
        }

        public final String getName() {
            return this.name;
        }

        protected final void setName(String string) {
            if (string != null) {
                this.name = string;
                this.setValid(false);
            }
        }

        public final URL getUrl() {
            return this.url;
        }

        public final boolean equals(Object object) {
            if (object != null && object instanceof LazyIssue) {
                return this.url.toString().equals(((LazyIssue)object).url.toString());
            }
            return false;
        }

        public final int hashCode() {
            return this.url.toString().hashCode();
        }

        public abstract Issue getIssue();

        public final boolean isValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
            if (!bl) {
                TaskListProvider.getInstance().refresh();
            }
        }

        public abstract String getRepositoryUrl();

        public abstract List<? extends Action> getActions();

        public String toString() {
            return super.toString() + ": " + this.getName();
        }
    }
}

