/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.MultipleCallStackRootNode;
import org.netbeans.modules.dlight.core.stack.ui.StackRootNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleCallStackPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final MultipleCallStackRootNode rootNode;
    private final BeanTreeView treeView;
    private Lookup lookup;
    private final SourceFileInfoDataProvider sourceFileInfoDataProvider;

    private MultipleCallStackPanel(SourceFileInfoDataProvider sourceFileInfoDataProvider) {
        this.setLayout(new BoxLayout(this, 1));
        this.sourceFileInfoDataProvider = sourceFileInfoDataProvider;
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)new ActionMap());
        this.treeView = new MyOwnBeanTreeView();
        this.treeView.setRootVisible(false);
        this.add((Component)this.treeView);
        AbstractAction abstractAction = new AbstractAction(NbBundle.getMessage(MultipleCallStackPanel.class, (String)"ExpandAll")){

            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCallStackPanel.this.treeView.expandAll();
            }
        };
        this.rootNode = new MultipleCallStackRootNode(abstractAction);
        this.manager.setRootContext((Node)this.rootNode);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(abstractAction);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    jPopupMenu.show(MultipleCallStackPanel.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        ActionMap actionMap = new ActionMap();
        actionMap.put("org.openide.actions.PopupAction", abstractAction);
        this.setActionMap(actionMap);
        this.treeView.setPopupAllowed(true);
        this.treeView.setActionMap(actionMap);
    }

    public static final MultipleCallStackPanel createInstance() {
        return new MultipleCallStackPanel(null);
    }

    public static final MultipleCallStackPanel createInstance(SourceFileInfoDataProvider sourceFileInfoDataProvider) {
        return new MultipleCallStackPanel(sourceFileInfoDataProvider);
    }

    @Override
    public boolean requestFocus(boolean bl) {
        if (this.treeView != null) {
            return this.treeView.requestFocus(bl);
        }
        return super.requestFocus(bl);
    }

    public void clean() {
        this.rootNode.removeAll();
        this.treeView.setRootVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.treeView.expandAll();
    }

    @Override
    public void requestFocus() {
        this.treeView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public void expandAll() {
        if (this.manager.getRootContext() == null) {
            return;
        }
        this.treeView.expandAll();
    }

    public void scrollToRoot() {
        this.treeView.getViewport().setViewPosition(new Point(0, 0));
    }

    public void expandNode(Node node) {
        this.treeView.expandNode(node);
    }

    public void setRootVisible(String string) {
        this.treeView.setRootVisible(true);
        this.rootNode.setDisplayName(string);
    }

    public final void add(String string, Icon icon, List<FunctionCall> list, Action[] actionArray) {
        this.rootNode.add(new StackRootNode(this.sourceFileInfoDataProvider, icon, string, list, actionArray));
    }

    public final void add(String string, Icon icon, List<FunctionCall> list) {
        this.rootNode.add(new StackRootNode(this.sourceFileInfoDataProvider, icon, string, list));
    }

    public final void add(String string, boolean bl, List<FunctionCall> list) {
        this.treeView.setRootVisible(false);
        this.rootNode.add(new StackRootNode(this.sourceFileInfoDataProvider, string, list));
    }

    public void update() {
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private static final class MyOwnBeanTreeView
    extends BeanTreeView {
        MyOwnBeanTreeView() {
        }

        public void expandAll() {
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MyOwnBeanTreeView.super.expandAll();
                    }
                });
            } else {
                super.expandAll();
            }
        }
    }
}

