/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadSnapshotQuery {
    private final boolean fullMsa;
    private final List<Filter> filters;

    public ThreadSnapshotQuery(boolean bl, Filter ... filterArray) {
        this.fullMsa = bl;
        this.filters = filterArray.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList((Object[])filterArray.clone()));
    }

    public boolean isFullMSA() {
        return this.fullMsa;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public static final class TimeFilter
    implements Filter {
        private final long startTime;
        private final long endTime;
        private final Mode mode;

        public TimeFilter(long l, long l2, Mode mode) {
            this.startTime = l;
            this.endTime = l2;
            this.mode = mode;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String toString() {
            return this.mode.toString() + " with " + this.startTime + " <= timestamp <= " + this.endTime;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Mode {
            ALL,
            FIRST,
            LAST;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ThreadFilter
    implements Filter {
        private final Set<Integer> threadIds;

        public ThreadFilter(Collection<Integer> collection) {
            this.threadIds = Collections.unmodifiableSet(new HashSet<Integer>(collection));
        }

        public Set<Integer> getThreadIds() {
            return this.threadIds;
        }

        public String toString() {
            return "thread_id in " + this.threadIds.toString();
        }
    }

    public static interface Filter {
    }
}

