/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api;

import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.impl.FunctionMetricAccessor;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.openide.util.NbBundle;

public final class FunctionMetric {
    private final String metricID;
    private final String metricDisplayedName;
    private final Class metricValueClass;
    public static final FunctionMetric CpuTimeInclusiveMetric;
    public static final FunctionMetric CpuTimeExclusiveMetric;

    FunctionMetric(FunctionMetricConfiguration functionMetricConfiguration) {
        this.metricID = functionMetricConfiguration.getMetricID();
        this.metricDisplayedName = functionMetricConfiguration.getMetricDisplayedName();
        this.metricValueClass = functionMetricConfiguration.getMetricValueClass();
    }

    public final String getMetricID() {
        return this.metricID;
    }

    public final String getMetricDisplayedName() {
        return this.metricDisplayedName;
    }

    public final Class getMetricValueClass() {
        return this.metricValueClass;
    }

    public String toString() {
        return this.metricDisplayedName;
    }

    private static final String getMessage(String string) {
        return NbBundle.getMessage(FunctionMetric.class, (String)string);
    }

    static {
        FunctionMetricAccessor.setDefault(new FunctionMetricAccessorImpl());
        CpuTimeInclusiveMetric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetricConfiguration("time_incl", FunctionMetric.getMessage("Metric.CpuTimeInclusive"), Time.class));
        CpuTimeExclusiveMetric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetricConfiguration("time_excl", FunctionMetric.getMessage("Metric.CpuTimeExclusive"), Time.class));
    }

    private static final class FunctionMetricAccessorImpl
    extends FunctionMetricAccessor {
        private FunctionMetricAccessorImpl() {
        }

        public FunctionMetric createNew(FunctionMetricConfiguration functionMetricConfiguration) {
            return new FunctionMetric(functionMetricConfiguration);
        }
    }

    public static final class FunctionMetricConfiguration {
        private final String metricID;
        private final String metricDisplayedName;
        private final Class metricValueClass;

        public FunctionMetricConfiguration(String string, String string2, Class clazz) {
            this.metricID = string;
            this.metricDisplayedName = string2;
            this.metricValueClass = clazz;
        }

        final String getMetricID() {
            return this.metricID;
        }

        final String getMetricDisplayedName() {
            return this.metricDisplayedName;
        }

        final Class getMetricValueClass() {
            return this.metricValueClass;
        }

        public int hashCode() {
            int n = 7;
            n = 41 * n + (this.metricID != null ? this.metricID.hashCode() : 0);
            n = 41 * n + (this.metricDisplayedName != null ? this.metricDisplayedName.hashCode() : 0);
            n = 41 * n + (this.metricValueClass != null ? this.metricValueClass.hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FunctionMetricConfiguration functionMetricConfiguration = (FunctionMetricConfiguration)object;
            if (this.metricID == null ? functionMetricConfiguration.metricID != null : !this.metricID.equals(functionMetricConfiguration.metricID)) {
                return false;
            }
            if (this.metricDisplayedName == null ? functionMetricConfiguration.metricDisplayedName != null : !this.metricDisplayedName.equals(functionMetricConfiguration.metricDisplayedName)) {
                return false;
            }
            return this.metricValueClass == functionMetricConfiguration.metricValueClass || this.metricValueClass != null && this.metricValueClass.equals(functionMetricConfiguration.metricValueClass);
        }
    }
}

