/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.DataObjectInterface;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DocumentInterface;
import org.netbeans.modules.vmd.io.CodeResolver;
import org.netbeans.modules.vmd.io.DataObjectContextImpl;
import org.netbeans.modules.vmd.io.DocumentLoad;
import org.netbeans.modules.vmd.io.editor.CodeEditorViewDescription;
import org.netbeans.modules.vmd.io.editor.EditorViewDescription;
import org.netbeans.modules.vmd.io.editor.EditorViewElement;
import org.netbeans.modules.vmd.io.editor.EditorViewFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

public final class IOSupport {
    private static final WeakHashMap<DataObject, DataObjectContext> contexts = new WeakHashMap();
    private static final WeakHashMap<DataObject, DocumentSerializer> serializers = new WeakHashMap();
    private static final WeakHashMap<DataObject, CodeResolver> resolvers = new WeakHashMap();
    private static final WeakHashMap<DataObject, Boolean> documentUpdating = new WeakHashMap();

    private IOSupport() {
    }

    public static synchronized DataObjectContext getDataObjectContext(DataObject dataObject) {
        DataObjectContext dataObjectContext = contexts.get(dataObject);
        if (dataObjectContext == null) {
            IOSupport.getDataObjectInteface(dataObject);
            dataObjectContext = new DataObjectContextImpl(dataObject);
            contexts.put(dataObject, dataObjectContext);
        }
        return dataObjectContext;
    }

    public static synchronized DocumentSerializer getDocumentSerializer(DataObject dataObject) {
        DocumentSerializer documentSerializer = serializers.get(dataObject);
        if (documentSerializer == null) {
            DataObjectContext dataObjectContext = IOSupport.getDataObjectContext(dataObject);
            documentSerializer = new DocumentSerializer(dataObjectContext);
            serializers.put(dataObject, documentSerializer);
            resolvers.put(dataObject, new CodeResolver(dataObjectContext, documentSerializer));
        }
        return documentSerializer;
    }

    public static void forceUpdateCode(DataObject dataObject) {
        CodeResolver codeResolver = resolvers.get(dataObject);
        if (codeResolver != null) {
            codeResolver.forceUpdateCode();
        }
    }

    public static synchronized void notifyDataObjectClosed(DataObject dataObject) {
        DocumentSerializer documentSerializer;
        documentUpdating.remove(dataObject);
        CodeResolver codeResolver = resolvers.remove(dataObject);
        if (codeResolver != null) {
            codeResolver.notifyDataObjectClosed();
        }
        if ((documentSerializer = serializers.remove(dataObject)) != null) {
            documentSerializer.notifyDataObjectClosed();
        }
        contexts.remove(dataObject);
    }

    public static DataObjectInterface getDataObjectInteface(DataObject dataObject) {
        if (!(dataObject instanceof DataObjectInterface)) {
            throw Debug.illegalArgument((Object[])new Object[]{"DataObject does not implement DataObjectInterface", dataObject});
        }
        return (DataObjectInterface)dataObject;
    }

    public static CloneableEditorSupport getCloneableEditorSupport(DataObject dataObject) {
        CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)dataObject.getLookup().lookup(CloneableEditorSupport.class);
        if (cloneableEditorSupport == null) {
            throw Debug.illegalArgument((Object[])new Object[]{"Missing CloneableEditorSupport in DataObject lookup", dataObject});
        }
        return cloneableEditorSupport;
    }

    public static FileObject getDesignFile(DataObjectContext dataObjectContext) {
        return IOSupport.getDataObjectInteface(dataObjectContext.getDataObject()).getDesignFile();
    }

    public static MultiViewDescription[] createEditorSupportPane(DataObjectContext dataObjectContext) {
        Collection<DataEditorView> collection = EditorViewFactorySupport.createEditorViews(dataObjectContext);
        ArrayList<CodeEditorViewDescription> arrayList = new ArrayList<CodeEditorViewDescription>();
        for (DataEditorView dataEditorView : collection) {
            arrayList.add((CodeEditorViewDescription)(dataEditorView.getKind() == DataEditorView.Kind.CODE ? new CodeEditorViewDescription(dataObjectContext, dataEditorView) : new EditorViewDescription(dataObjectContext, dataEditorView)));
        }
        return arrayList.toArray(new MultiViewDescription[arrayList.size()]);
    }

    public static DataEditorView getDataEditorView(MultiViewDescription multiViewDescription) {
        return multiViewDescription instanceof EditorViewDescription ? ((EditorViewDescription)multiViewDescription).getView() : null;
    }

    public static synchronized DataObjectContext getDataObjectContextForDocumentInterface(DesignDocument designDocument) {
        assert (Debug.isFriend(ProjectUtils.class, (String)"getDataObjectContextForDocument"));
        DocumentInterface documentInterface = designDocument.getDocumentInterface();
        for (DataObject dataObject : serializers.keySet()) {
            DocumentSerializer documentSerializer;
            if (dataObject == null || !(documentSerializer = IOSupport.getDocumentSerializer(dataObject)).hasDocumentInterface(documentInterface)) continue;
            return IOSupport.getDataObjectContext(dataObject);
        }
        return null;
    }

    public static void notifyDataEditorViewActivated(DataEditorView dataEditorView) {
        assert (Debug.isFriend(EditorViewElement.class, (String)"componentActivated"));
        if (dataEditorView == null) {
            return;
        }
        CodeResolver codeResolver = resolvers.get(dataEditorView.getContext().getDataObject());
        if (codeResolver != null) {
            codeResolver.viewActivated(dataEditorView);
        }
    }

    public static String resolveProjectType(DataObjectContext dataObjectContext) {
        return DocumentLoad.loadProjectType(dataObjectContext);
    }

    static void resetCodeResolver(DataObject dataObject, DesignDocument designDocument) {
        if (dataObject == null) {
            return;
        }
        CodeResolver codeResolver = resolvers.get(dataObject);
        if (codeResolver == null) {
            Debug.warning((Object[])new Object[]{"No CodeResolver for DataObject: " + dataObject});
            return;
        }
        codeResolver.resetModelModifiedStatus(designDocument);
    }

    public static boolean isDocumentUpdatingEnabled(DataObject dataObject) {
        Boolean bl = documentUpdating.get(dataObject);
        return bl != null && bl != false;
    }

    public static void setDocumentUpdatingEnabled(DataObject dataObject, boolean bl) {
        documentUpdating.put(dataObject, bl);
    }
}

