/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ActiveViewSupport {
    private static final String MODE_EDITOR = "editor";
    private static final ActiveViewSupport support = new ActiveViewSupport();
    private final WeakSet<Listener> listeners = new WeakSet();
    private ActiveViewObserver topComponentListener = null;
    private DataObjectContext context = null;
    private final ActiveDocumentObserver awereness = new ActiveDocumentObserver();

    private ActiveViewSupport() {
        if (this.topComponentListener == null) {
            this.topComponentListener = new ActiveViewObserver();
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.topComponentListener);
        }
    }

    public static ActiveViewSupport getDefault() {
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveViewListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveViewListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataEditorView getActiveView() {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            return this.topComponentListener != null ? this.topComponentListener.activeView : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActiveViewChanged(DataEditorView dataEditorView, DataEditorView dataEditorView2) {
        Object object = this.listeners;
        synchronized (this.listeners) {
            Listener[] listenerArray = (Listener[])this.listeners.toArray((Object[])new Listener[this.listeners.size()]);
            // ** MonitorExit[var4_3 /* !! */ ] (shouldn't be in output)
            object = listenerArray;
            int n = ((Listener[])object).length;
            for (int i = 0; i < n; ++i) {
                Listener listener = object[i];
                if (listener == null) continue;
                listener.activeViewChanged(dataEditorView, dataEditorView2);
            }
            Object object2 = object = dataEditorView2 != null ? dataEditorView2.getContext() : null;
            if (this.context != object) {
                if (this.context != null) {
                    this.context.removeDesignDocumentAwareness(this.awereness);
                }
                this.context = object;
                if (this.context != null) {
                    this.context.addDesignDocumentAwareness(this.awereness);
                } else {
                    this.awereness.setDesignDocument(null);
                }
            }
            return;
        }
    }

    private static Mode findEditorMode() {
        Set set = WindowManager.getDefault().getModes();
        for (Object e : set) {
            Mode mode = (Mode)e;
            if (mode == null || !MODE_EDITOR.equals(mode.getName())) continue;
            return mode;
        }
        return null;
    }

    public static interface Listener
    extends EventListener {
        public void activeViewChanged(DataEditorView var1, DataEditorView var2);
    }

    private class ActiveDocumentObserver
    implements DesignDocumentAwareness {
        private ActiveDocumentObserver() {
        }

        public void setDesignDocument(DesignDocument designDocument) {
            ActiveDocumentSupport.getDefault().setActiveDocument(designDocument);
        }
    }

    private class ActiveViewObserver
    implements PropertyChangeListener,
    LookupListener {
        private Lookup.Result<DataEditorView> result;
        private DataEditorView activeView;

        private ActiveViewObserver() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopComponent topComponent;
            if (!"activated".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            Mode mode = ActiveViewSupport.findEditorMode();
            TopComponent topComponent2 = topComponent = mode != null ? mode.getSelectedTopComponent() : null;
            if (this.result != null) {
                this.result.removeLookupListener((LookupListener)this);
            }
            Lookup.Result<DataEditorView> result = this.result = topComponent != null ? topComponent.getLookup().lookupResult(DataEditorView.class) : null;
            if (this.result != null) {
                this.result.addLookupListener((LookupListener)this);
            }
            this.update();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.update();
        }

        private void update() {
            Collection collection;
            DataEditorView dataEditorView = this.activeView;
            this.activeView = this.result != null ? ((collection = this.result.allInstances()).isEmpty() ? null : (DataEditorView)collection.iterator().next()) : null;
            if (dataEditorView != this.activeView) {
                ActiveViewSupport.this.fireActiveViewChanged(dataEditorView, this.activeView);
            }
        }
    }
}

