/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.openide.util.NbBundle;

public class TimestampType {
    public static final Locale LOCALE = Locale.UK;
    public static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat[] TIMESTAMP_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), DateFormat.getDateTimeInstance(), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(1, LOCALE), DateFormat.getTimeInstance(3, LOCALE), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("MM-dd-yyyy"), new SimpleDateFormat("HH:mm:ss")};

    public TimestampType() {
        for (int i = 0; i < TIMESTAMP_PARSING_FORMATS.length; ++i) {
            TIMESTAMP_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static Timestamp convert(Object object) throws DBException {
        if (null == object) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.sql.Date) {
            return new Timestamp(((java.sql.Date)object).getTime());
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof String) {
            Date date = TimestampType.doParse((String)object);
            if (date == null) {
                throw new DBException(NbBundle.getMessage(TimestampType.class, (String)"LBL_invalid_timestamp"));
            }
            return new Timestamp(date.getTime());
        }
        throw new DBException(NbBundle.getMessage(TimestampType.class, (String)"LBL_invalid_timestamp"));
    }

    private static synchronized Date doParse(String string) {
        Date date = null;
        for (DateFormat dateFormat : TIMESTAMP_PARSING_FORMATS) {
            try {
                date = dateFormat.parse(string);
                break;
            }
            catch (ParseException parseException) {
                Logger.getLogger(TimestampType.class.getName()).log(Level.FINEST, parseException.getLocalizedMessage(), parseException);
            }
        }
        return date;
    }
}

