/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.netbeans.modules.db.dataview.table.BooleanCellRenderer;
import org.netbeans.modules.db.dataview.table.CellFocusCustomRenderer;
import org.netbeans.modules.db.dataview.table.NullObjectCellRenderer;
import org.netbeans.modules.db.dataview.table.NumberObjectCellRenderer;
import org.netbeans.modules.db.dataview.table.SQLConstantsCellRenderer;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public class ResultSetCellRenderer
extends DefaultTableRenderer {
    protected static final FormatStringValue DATETIME_TO_STRING = new FormatStringValue(){

        public String getString(Object object) {
            if (this.format == null) {
                this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            }
            return super.getString(object);
        }
    };
    protected static final FormatStringValue TIME_TO_STRING = new FormatStringValue(){

        public String getString(Object object) {
            if (this.format == null) {
                this.format = new SimpleDateFormat("HH:mm:ss");
            }
            return super.getString(object);
        }
    };
    private final TableCellRenderer NULL_RENDERER = new NullObjectCellRenderer();
    private final TableCellRenderer DEFAULT_RENDERER = new SQLConstantsCellRenderer();
    private final TableCellRenderer NUMNBER_RENDERER = new NumberObjectCellRenderer();
    private final TableCellRenderer BOOLEAN_RENDERER = new BooleanCellRenderer();
    private final TableCellRenderer CELL_FOCUS_RENDERER = new CellFocusCustomRenderer();

    public ResultSetCellRenderer() {
        super(FormatStringValue.TO_STRING);
    }

    public ResultSetCellRenderer(ComponentProvider componentProvider) {
        super(componentProvider);
    }

    public ResultSetCellRenderer(StringValue stringValue, int n) {
        super(stringValue, n);
    }

    public ResultSetCellRenderer(StringValue stringValue) {
        super(stringValue, 10);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (null == object) {
            return this.NULL_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if (object instanceof Number) {
            return this.NUMNBER_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if (DataViewUtils.isSQLConstantString(object)) {
            return this.DEFAULT_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if (object instanceof Boolean) {
            return this.BOOLEAN_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Component component = this.CELL_FOCUS_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setTableCellToolTip(component, object);
        return component;
    }

    protected void setTableCellToolTip(Component component, Object object) {
        if (component instanceof JComponent) {
            if (object instanceof String) {
                String string = "<html><table border=0 cellspacing=0 cellpadding=0 width=40><tr><td>";
                string = string + DataViewUtils.escapeHTML(object.toString()).replaceAll("\\n", "<br>").replaceAll(" ", "&nbsp;");
                string = string + "</td></tr></table></html>";
                ((JComponent)component).setToolTipText(string);
            } else {
                ((JComponent)component).setToolTipText(object.toString());
            }
        }
    }
}

