/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.sql.SQLException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

abstract class SQLStatementExecutor
implements Runnable,
Cancellable {
    protected final DataView dataView;
    protected Connection conn = null;
    protected boolean error = false;
    protected volatile Throwable ex;
    protected String errorMsg = "";
    protected boolean lastCommitState;
    private String title;
    private String titleMsg;
    private volatile RequestProcessor.Task task;
    private long startTime;

    public SQLStatementExecutor(DataView dataView, String string, String string2) {
        this.title = string;
        this.titleMsg = string2;
        this.dataView = dataView;
    }

    public void setTask(RequestProcessor.Task task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        assert (this.task != null);
        try {
            this.startTime = System.currentTimeMillis();
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.title, (Cancellable)this);
            progressHandle.setDisplayName(this.titleMsg);
            progressHandle.start();
            try {
                progressHandle.switchToIndeterminate();
                this.dataView.setInfoStatusText("");
                this.errorMsg = "";
                this.dataView.disableButtons();
                this.conn = DBConnectionFactory.getInstance().getConnection(this.dataView.getDatabaseConnection());
                String string = "";
                if (this.conn == null) {
                    Throwable throwable = DBConnectionFactory.getInstance().getLastException();
                    string = throwable != null ? throwable.getMessage() : NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_connection_failure", (Object)this.dataView.getDatabaseConnection());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                this.lastCommitState = this.setAutocommit(this.conn, false);
                this.execute();
            }
            finally {
                progressHandle.finish();
            }
        }
        catch (Exception exception) {
            this.ex = exception;
        }
        finally {
            if (this.ex != null) {
                this.errorMsg = this.errorMsg + this.ex.getMessage();
                this.error = true;
            }
            this.finished();
            this.resetAutocommitState(this.conn, this.lastCommitState);
        }
    }

    public boolean cancel() {
        return this.task.cancel();
    }

    public abstract void finished();

    public abstract void execute() throws SQLException, DBException;

    protected void executeOnSucess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinstateToolbar() {
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.resetToolbar(false);
        }
    }

    protected void commitOrRollback(String string) {
        if (!this.error && this.commit(this.conn)) {
            long l = System.currentTimeMillis() - this.startTime;
            String string2 = SQLExecutionHelper.millisecondsToSeconds(l);
            String string3 = string + " " + NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_execution_success", (Object)string2);
            this.dataView.setInfoStatusText(string3);
            this.executeOnSucess();
        } else {
            this.rollback(this.conn);
            this.reinstateToolbar();
            String string4 = string + " " + NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_failed");
            this.errorMsg = this.ex == null ? string4 + " " + this.errorMsg : string4;
            this.ex = new DBException(this.errorMsg, this.ex);
            this.dataView.setErrorStatusText(this.ex);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.ex.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private boolean setAutocommit(Connection connection, boolean bl) {
        try {
            if (connection != null) {
                boolean bl2 = connection.getAutoCommit();
                connection.setAutoCommit(bl);
                return bl2;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private void resetAutocommitState(Connection connection, boolean bl) {
        if (connection != null) {
            try {
                connection.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean commit(Connection connection) {
        try {
            if (connection != null && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            String string = NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_failure_to_commit");
            this.dataView.setErrorStatusText(string, sQLException);
            this.ex = sQLException;
            return false;
        }
        return true;
    }

    private void rollback(Connection connection) {
        try {
            if (connection != null && !connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            String string = NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_failure_rollback");
            this.dataView.setErrorStatusText(string, sQLException);
        }
    }
}

