/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayDataFlavorSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenMoveArrayAcceptSuggestion;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.WrappedLabel;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenBooleanPropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceElementDisplayPresenter
extends ScreenDisplayPresenter {
    public static final String ICON_EMPTY_CHECKBOX_PATH = "org/netbeans/modules/vmd/midp/resources/screen/unchecked.png";
    public static final String ICON_CHECKBOX_PATH = "org/netbeans/modules/vmd/midp/resources/screen/checked.png";
    public static final String ICON_EMPTY_RADIOBUTTON_PATH = "org/netbeans/modules/vmd/midp/resources/screen/radio-unchecked.png";
    public static final String ICON_RADIOBUTTON_PATH = "org/netbeans/modules/vmd/midp/resources/screen/radio-checked.png";
    public static final String ICON_POPUP_PATH = "org/netbeans/modules/vmd/midp/resources/screen/drop-down.png";
    public static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midp/resources/screen/broken-image.png";
    public static final Icon ICON_EMPTY_CHECKBOX = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/unchecked.png", (boolean)false);
    public static final Icon ICON_CHECKBOX = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/checked.png", (boolean)false);
    public static final Icon ICON_EMPTY_RADIOBUTTON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/radio-unchecked.png", (boolean)false);
    public static final Icon ICON_RADIOBUTTON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/radio-checked.png", (boolean)false);
    public static final Icon ICON_POPUP = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/drop-down.png", (boolean)false);
    public static final Icon ICON_BROKEN = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/broken-image.png", (boolean)false);
    private JPanel view = new JPanel();
    private JLabel state;
    private JLabel image;
    private WrappedLabel label;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;

    public ChoiceElementDisplayPresenter() {
        this.view.setLayout(new BoxLayout(this.view, 0));
        this.view.setOpaque(false);
        this.state = new JLabel();
        this.view.add(this.state);
        this.image = new JLabel();
        this.view.add(this.image);
        this.label = new WrappedLabel(){

            protected int getLabelWidth() {
                return (int)(ChoiceElementDisplayPresenter.this.view.getSize().getWidth() - ChoiceElementDisplayPresenter.this.image.getSize().getWidth() - ChoiceElementDisplayPresenter.this.state.getSize().getWidth());
            }
        };
        this.view.add(this.label);
        this.view.add(Box.createHorizontalGlue());
        ScreenSupport.addKeyboardSupport(this);
    }

    public boolean isTopLevelDisplay() {
        return false;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        return this.view;
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        Object object;
        PropertyValue propertyValue = this.getComponent().getParentComponent().readProperty("choiceType");
        int n = !PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? MidpTypes.getInteger(propertyValue) : 1;
        PropertyValue propertyValue2 = this.getComponent().readProperty("selected");
        boolean bl = propertyValue2.getKind() == PropertyValue.Kind.VALUE && MidpTypes.getBoolean(propertyValue2);
        switch (n) {
            case 1: {
                this.state.setIcon(bl ? ICON_RADIOBUTTON : ICON_EMPTY_RADIOBUTTON);
                break;
            }
            case 2: {
                this.state.setIcon(bl ? ICON_CHECKBOX : ICON_EMPTY_CHECKBOX);
                break;
            }
            case 4: {
                this.state.setIcon(ICON_POPUP);
                break;
            }
            default: {
                this.state.setIcon(null);
            }
        }
        Icon icon = null;
        String string = null;
        propertyValue = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            object = propertyValue.getComponent();
            if (object != null) {
                string = (String)object.readProperty("resourcePath").getPrimitiveValue();
            }
            icon = ScreenSupport.getIconFromImageComponent(object);
            this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent(object);
            if (this.imageFileObject != null) {
                this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), (DesignComponent)object, "resourcePath");
                this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
            }
        }
        if (icon != null) {
            this.image.setIcon(icon);
        } else if (string != null) {
            this.image.setIcon(ICON_BROKEN);
        } else {
            this.image.setIcon(null);
        }
        object = MidpValueSupport.getHumanReadableString(this.getComponent().readProperty("string"));
        this.label.setText((String)object);
        this.label.setMode(WrappedLabel.Mode.forInt(this.getFitPolicy()));
        propertyValue = this.getComponent().readProperty("font");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            DesignComponent designComponent = propertyValue.getComponent();
            this.label.setFont(ScreenSupport.getFont(screenDeviceInfo, designComponent));
        }
        this.label.repaint();
        this.label.invalidate();
    }

    public Shape getSelectionShape() {
        return new Rectangle(this.view.getSize());
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        return Arrays.asList(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.state, (ScreenPropertyEditor)new ScreenBooleanPropertyEditor("selected")), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.label, (ScreenPropertyEditor)new ScreenStringPropertyEditor("string")));
    }

    public boolean isDraggable() {
        return true;
    }

    public AcceptSuggestion createSuggestion(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR)) {
            return null;
        }
        if (!transferable.isDataFlavorSupported(ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR)) {
            return null;
        }
        ScreenDeviceInfo.Edge edge = null;
        ScreenDeviceInfo.Edge edge2 = null;
        try {
            edge = (ScreenDeviceInfo.Edge)transferable.getTransferData(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR);
            edge2 = (ScreenDeviceInfo.Edge)transferable.getTransferData(ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new ScreenMoveArrayAcceptSuggestion(edge, edge2);
    }

    protected void notifyDetached(DesignComponent designComponent) {
        if (this.imageFileObject != null && this.imageFileListener != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.imageFileObject = null;
        this.imageFileListener = null;
    }

    private int getFitPolicy() {
        DesignComponent designComponent = this.getRelatedComponent().getParentComponent();
        if (designComponent != null) {
            return Integer.parseInt(designComponent.readProperty("fitPolicy").getPrimitiveValue().toString());
        }
        return 0;
    }
}

