/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorDefaultCommand
extends PropertyEditorUserCode
implements PropertyEditorElement,
CleanUp {
    private static final String NONE_ITEM = NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"LBL_SELECTCOMMAND_NONE");
    private List<String> tags = new ArrayList<String>();
    private Map<String, DesignComponent> values = new TreeMap<String, DesignComponent>();
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private TypeID parentTypeID;

    private PropertyEditorDefaultCommand(TypeID typeID) {
        super(NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"LBL_DEF_COMMAND_UCLABEL"));
        this.parentTypeID = typeID;
    }

    public static PropertyEditorDefaultCommand createInstance() {
        return new PropertyEditorDefaultCommand(null);
    }

    public static PropertyEditorDefaultCommand createInstance(TypeID typeID) {
        return new PropertyEditorDefaultCommand(typeID);
    }

    public void clean(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        this.tags = null;
        this.values = null;
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.parentTypeID = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"LBL_DEF_COMMAND_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(this.customEditor);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public void setAsText(String string) {
        this.saveValue(string);
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return NONE_ITEM;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return this.getDecodeValue(propertyValue);
    }

    public Boolean canEditAsText() {
        return null;
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        this.customEditor.updateModel();
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setValue(null);
        } else {
            this.customEditor.setValue(propertyValue);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            if (NONE_ITEM.equals(string)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                final DesignComponent designComponent = this.values.get(string);
                if (designComponent != null) {
                    final DesignComponent[] designComponentArray = new DesignComponent[]{this.getItemCommandEvenSource(string)};
                    if (designComponentArray[0] == null && this.component != null && this.component.get() != null) {
                        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                            public void run() {
                                designComponentArray[0] = MidpDocumentSupport.attachCommandToItem((DesignComponent)PropertyEditorDefaultCommand.this.component.get(), designComponent);
                            }
                        });
                    }
                    super.setValue((Object)PropertyValue.createComponentReference((DesignComponent)designComponentArray[0]));
                }
            }
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public String[] getTags() {
        this.tags.clear();
        if (this.isCurrentValueAUserCodeType()) {
            this.tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            this.tags.add(NONE_ITEM);
            this.values.clear();
            this.values.put(NONE_ITEM, null);
            if (this.component != null && this.component.get() != null) {
                final DesignComponent designComponent = (DesignComponent)this.component.get();
                designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        DesignComponent designComponent2 = designComponent.getParentComponent();
                        if (designComponent2 != null) {
                            Object object;
                            PropertyValue propertyValue;
                            Object object2;
                            Object object32;
                            List list = designComponent2.readProperty("commands").getArray();
                            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                            for (Object object32 : list) {
                                object2 = object32.getComponent().readProperty("command").getComponent();
                                if (object2 == null || !MidpTypes.getBoolean(propertyValue = object2.readProperty("ordinary"))) continue;
                                arrayList.add(object2);
                            }
                            Collection collection = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), CommandsCategoryCD.TYPEID).getComponents();
                            object32 = new ArrayList(collection.size());
                            object2 = collection.iterator();
                            while (object2.hasNext()) {
                                propertyValue = (DesignComponent)object2.next();
                                object = propertyValue.readProperty("ordinary");
                                if (!MidpTypes.getBoolean(object)) continue;
                                object32.add(propertyValue);
                            }
                            object32.removeAll(arrayList);
                            object2 = object32.iterator();
                            while (object2.hasNext()) {
                                propertyValue = (DesignComponent)object2.next();
                                object = PropertyEditorDefaultCommand.this.getComponentDisplayName((DesignComponent)propertyValue);
                                PropertyEditorDefaultCommand.this.tags.add(object);
                                PropertyEditorDefaultCommand.this.values.put(object, propertyValue);
                            }
                        }
                    }
                });
            }
        }
        return this.tags.toArray(new String[this.tags.size()]);
    }

    private String getComponentDisplayName(DesignComponent designComponent) {
        return MidpValueSupport.getHumanReadableString(designComponent);
    }

    private String getDecodeValue(final PropertyValue propertyValue) {
        final String[] stringArray = new String[1];
        if (this.component != null && this.component.get() != null) {
            DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    stringArray[0] = PropertyEditorDefaultCommand.this.getComponentDisplayName(propertyValue.getComponent());
                }
            });
        }
        return stringArray[0];
    }

    private DesignComponent getItemCommandEvenSource(final String string) {
        final DesignComponent[] designComponentArray = new DesignComponent[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent3 = (DesignComponent)PropertyEditorDefaultCommand.this.values.get(string);
                    List list = designComponent.readProperty("commands").getArray();
                    for (PropertyValue propertyValue : list) {
                        DesignComponent designComponent2 = propertyValue.getComponent();
                        if (!designComponent2.readProperty("command").getComponent().equals(designComponent3)) continue;
                        designComponentArray[0] = designComponent2;
                        break;
                    }
                }
            });
        }
        return designComponentArray[0];
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        void cleanUp() {
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
            this.removeAll();
        }

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"ACSN_DefaultCommandChooser"));
            this.combobox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"ACSD_DefaultCommandChooser"));
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.add((Component)this.combobox, "Center");
        }

        public void setValue(final PropertyValue propertyValue) {
            DesignComponent designComponent;
            if (propertyValue == null) {
                this.combobox.setSelectedItem(NONE_ITEM);
                return;
            }
            final PropertyValue[] propertyValueArray = new PropertyValue[1];
            if (PropertyEditorDefaultCommand.this.component != null && PropertyEditorDefaultCommand.this.component.get() != null) {
                designComponent = ((DesignComponent)PropertyEditorDefaultCommand.this.component.get()).getDocument();
                designComponent.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        propertyValueArray[0] = propertyValue.getComponent().readProperty("command");
                    }
                });
            }
            if (propertyValueArray[0] == null) {
                return;
            }
            designComponent = propertyValueArray[0].getComponent();
            for (String string : PropertyEditorDefaultCommand.this.values.keySet()) {
                DesignComponent designComponent2 = (DesignComponent)PropertyEditorDefaultCommand.this.values.get(string);
                if (designComponent2 == null || !designComponent2.equals(designComponent)) continue;
                this.combobox.setSelectedItem(string);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.combobox.getModel();
            defaultComboBoxModel.removeAllElements();
            for (String string : PropertyEditorDefaultCommand.this.tags) {
                defaultComboBoxModel.addElement(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorDefaultCommand.this.radioButton.setSelected(true);
        }
    }
}

