/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.general;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bitmask {
    private int bitmask;

    public Bitmask(int n) {
        this.bitmask = n;
    }

    public abstract List<BitmaskItem> getBitmaskItems();

    public int getBitmask() {
        return this.bitmask;
    }

    public boolean isSet(BitmaskItem bitmaskItem) {
        int n = bitmaskItem.getAffectedBits();
        return (n & this.bitmask) == n;
    }

    public int addToBitmask(BitmaskItem bitmaskItem, boolean bl) {
        this.bitmask = bl ? (this.bitmask |= bitmaskItem.getAffectedBits()) : (this.bitmask &= ~bitmaskItem.getAffectedBits());
        return this.bitmask;
    }

    public int setBitmask(int n) {
        this.bitmask = n;
        return this.bitmask;
    }

    public boolean equals(Bitmask bitmask) {
        if (this == bitmask) {
            return true;
        }
        return this.bitmask == bitmask.bitmask;
    }

    public boolean equals(Object object) {
        if (object instanceof Bitmask) {
            return this.equals((Bitmask)object);
        }
        return false;
    }

    public BitmaskItem getBitmaskItem(int n) {
        for (BitmaskItem bitmaskItem : this.getBitmaskItems()) {
            if (bitmaskItem.getAffectedBits() != n) continue;
            return bitmaskItem;
        }
        return null;
    }

    public BitmaskItem getBitmaskItem(String string) {
        for (BitmaskItem bitmaskItem : this.getBitmaskItems()) {
            if (!bitmaskItem.getDisplayName().equals(string)) continue;
            return bitmaskItem;
        }
        return null;
    }

    public static final class BitmaskItem {
        private String name;
        private String displayName;
        private int affectedBits;

        public BitmaskItem(String string, int n) {
            this(n, null, string);
        }

        public BitmaskItem(int n, String string, String string2) {
            if (string2 == null) {
                throw new NullPointerException("Name parameter cannot be null");
            }
            this.name = string2;
            this.displayName = string != null ? string : this.name;
            this.affectedBits = n;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public int getAffectedBits() {
            return this.affectedBits;
        }
    }
}

