/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.displayables;

import java.util.Arrays;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeMultiGuardedLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeNamePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.codegen.MidpCodeSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.commands.ListSelectCommandCD;
import org.netbeans.modules.vmd.midp.components.displayables.DisplayableCode;
import org.netbeans.modules.vmd.midp.components.displayables.ListCD;

public class ListCode {
    private static final String LIST_ACTION_METHOD_SUFFIX = "Action";
    public static final String PARAM_STRING = "elementString";
    public static final String PARAM_IMAGE = "elementImage";
    static final String PARAM_FONT = "elementFont";
    static final String PARAM_SELECTED_ARRAY = "elementSelectedArray";
    static final String PARAM_STRING_ARRAY = "elementStringArray";
    static final String PARAM_IMAGE_ARRAY = "elementImageArray";
    static final String PARAM_SELECT_COMMAND = "selectCommand";
    static final String PARAM_LIST_TYPE = "listType";
    static final String PARAM_FIT_POLICY = "fitPolicy";

    public static Parameter createStringParameter() {
        return new StringParameter();
    }

    public static Parameter createImageParameter() {
        return new ImageParameter();
    }

    public static Parameter createFontParameter() {
        return new FontParameter();
    }

    public static Parameter createSelectArrayParameter() {
        return new SelectedArrayParameter();
    }

    public static Parameter createStringArrayParameter() {
        return new StringArrayParameter();
    }

    public static Parameter createImageArrayParameter() {
        return new ImageArrayParameter();
    }

    public static String getListActionMethodAccessCode(DesignComponent designComponent) {
        if (designComponent == null || !designComponent.getDocument().getDescriptorRegistry().isInHierarchy(ListCD.TYPEID, designComponent.getType())) {
            return null;
        }
        return MidpTypes.getString(designComponent.readProperty("instanceName")) + LIST_ACTION_METHOD_SUFFIX;
    }

    public static Presenter createListActionCodeNamePresenter() {
        return new ListActionCodeNamePresenter();
    }

    public static Presenter createListActionCodeClassLevelPresenter() {
        return new ListActionCodeClassLevelPresenter();
    }

    public static Parameter createSelectCommandParameter() {
        return new SelectCommandParameter();
    }

    public static Parameter createListCommandParameter() {
        return new ListCommandParameter();
    }

    public static Parameter createListTypeParameter() {
        return new ListTypeParameter();
    }

    public static Parameter createFitPolicyParameter() {
        return new FitPolicyParameter();
    }

    private static class FitPolicyParameter
    extends MidpParameter {
        protected FitPolicyParameter() {
            super(ListCode.PARAM_FIT_POLICY);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty(ListCode.PARAM_FIT_POLICY);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int n2 = MidpTypes.getInteger(propertyValue);
                switch (n2) {
                    case 0: {
                        multiGuardedSection.getWriter().write("Choice.TEXT_WRAP_DEFAULT");
                        break;
                    }
                    case 1: {
                        multiGuardedSection.getWriter().write("Choice.TEXT_WRAP_ON");
                        break;
                    }
                    case 2: {
                        multiGuardedSection.getWriter().write("Choice.TEXT_WRAP_OFF");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(designComponent, multiGuardedSection, n);
        }
    }

    private static class ListTypeParameter
    extends MidpParameter {
        protected ListTypeParameter() {
            super(ListCode.PARAM_LIST_TYPE);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty(ListCode.PARAM_LIST_TYPE);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int n2 = MidpTypes.getInteger(propertyValue);
                switch (n2) {
                    case 3: {
                        multiGuardedSection.getWriter().write("Choice.IMPLICIT");
                        break;
                    }
                    case 1: {
                        multiGuardedSection.getWriter().write("Choice.EXCLUSIVE");
                        break;
                    }
                    case 2: {
                        multiGuardedSection.getWriter().write("Choice.MULTIPLE");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(designComponent, multiGuardedSection, n);
        }
    }

    private static final class ListActionCodeClassLevelPresenter
    extends CodeClassLevelPresenter.Adapter {
        private ListActionCodeClassLevelPresenter() {
        }

        protected void generateClassBodyCode(StyledDocument styledDocument) {
            DesignComponent designComponent = this.getComponent();
            List list = designComponent.readProperty("elements").getArray();
            MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(designComponent.getComponentID() + "-action"));
            String string = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)designComponent);
            String string2 = string + ListCode.LIST_ACTION_METHOD_SUFFIX;
            multiGuardedSection.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: " + string2 + " \">\n");
            multiGuardedSection.getWriter().write("/**\n * Performs an action assigned to the selected list element in the " + string + " component.\n */\n");
            multiGuardedSection.getWriter().write("public void " + string2 + " () {\n").commit();
            multiGuardedSection.switchToEditable(designComponent.getComponentID() + "-preAction");
            multiGuardedSection.getWriter().write(" // enter pre-action user code here\n").commit();
            multiGuardedSection.switchToGuarded();
            String string3 = CodeReferencePresenter.generateAccessCode((DesignComponent)designComponent);
            boolean bl = MidpTypes.getBoolean(designComponent.readProperty("indexBasedSwitch"));
            if (!bl) {
                multiGuardedSection.getWriter().write("String __selectedString = " + string3 + ".getString (" + string3 + ".getSelectedIndex ());\n");
            }
            if (list.size() > 0) {
                if (bl) {
                    multiGuardedSection.getWriter().write("switch (" + string3 + ".getSelectedIndex ()) {\n");
                } else {
                    multiGuardedSection.getWriter().write("if (__selectedString != null) {\n");
                }
                for (int i = 0; i < list.size(); ++i) {
                    PropertyValue propertyValue = (PropertyValue)list.get(i);
                    DesignComponent designComponent2 = propertyValue.getComponent();
                    if (bl) {
                        multiGuardedSection.getWriter().write("case " + i + ":\n");
                    } else {
                        if (i > 0) {
                            multiGuardedSection.getWriter().write("} else ");
                        }
                        multiGuardedSection.getWriter().write("if (__selectedString.equals (");
                        MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), designComponent2.readProperty("string"));
                        multiGuardedSection.getWriter().write(")) {\n");
                    }
                    CodeMultiGuardedLevelPresenter.generateMultiGuardedSectionCode((MultiGuardedSection)multiGuardedSection, (DesignComponent)designComponent2);
                    if (!bl) continue;
                    multiGuardedSection.getWriter().write("break;\n");
                }
                if (!bl) {
                    multiGuardedSection.getWriter().write("}\n");
                }
                multiGuardedSection.getWriter().write("}\n");
            }
            multiGuardedSection.getWriter().commit();
            multiGuardedSection.switchToEditable(designComponent.getComponentID() + "-postAction");
            multiGuardedSection.getWriter().write(" // enter post-action user code here\n").commit();
            multiGuardedSection.switchToGuarded();
            multiGuardedSection.getWriter().write("}\n");
            multiGuardedSection.getWriter().write("//</editor-fold>\n").commit();
            multiGuardedSection.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListActionCodeNamePresenter
    extends CodeNamePresenter {
        private ListActionCodeNamePresenter() {
        }

        public List<String> getReservedNames() {
            return this.getReservedNamesFor(MidpTypes.getString(this.getComponent().readProperty("instanceName")));
        }

        public List<String> getReservedNamesFor(String string) {
            return Arrays.asList(string + ListCode.LIST_ACTION_METHOD_SUFFIX);
        }
    }

    private static final class ListCommandParameter
    extends DisplayableCode.CommandParameter {
        private ListCommandParameter() {
        }

        public int getParameterPriority() {
            return super.getParameterPriority() + 1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
            List list = designComponent.readProperty("commands").getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            DesignComponent designComponent3 = designComponent2.readProperty("command").getComponent();
            if (designComponent3 != null && descriptorRegistry.isInHierarchy(ListSelectCommandCD.TYPEID, designComponent3.getType())) {
                return false;
            }
            return super.isRequiredToBeSet(designComponent3, n);
        }
    }

    private static class SelectCommandParameter
    implements Parameter {
        private SelectCommandParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_SELECT_COMMAND;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), this.getSelectCommand(designComponent));
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            DesignComponent designComponent2 = this.getSelectCommand(designComponent).getComponent();
            DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
            return designComponent2 == null || !descriptorRegistry.isInHierarchy(ListSelectCommandCD.TYPEID, designComponent2.getType());
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private PropertyValue getSelectCommand(DesignComponent designComponent) {
            DesignComponent designComponent2 = designComponent.readProperty(ListCode.PARAM_SELECT_COMMAND).getComponent();
            return designComponent2 != null ? designComponent2.readProperty("command") : PropertyValue.createNull();
        }
    }

    private static class ImageArrayParameter
    implements Parameter {
        private ImageArrayParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_IMAGE_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            CodeWriter codeWriter = multiGuardedSection.getWriter();
            codeWriter.write("new Image[] { ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    codeWriter.write(", ");
                }
                PropertyValue propertyValue2 = (PropertyValue)list.get(i);
                DesignComponent designComponent2 = propertyValue2.getComponent();
                PropertyValue propertyValue3 = designComponent2.readProperty("image");
                MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue3);
            }
            codeWriter.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class StringArrayParameter
    implements Parameter {
        private StringArrayParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_STRING_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            CodeWriter codeWriter = multiGuardedSection.getWriter();
            codeWriter.write("new String[] { ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    codeWriter.write(", ");
                }
                PropertyValue propertyValue2 = (PropertyValue)list.get(i);
                DesignComponent designComponent2 = propertyValue2.getComponent();
                PropertyValue propertyValue3 = designComponent2.readProperty("string");
                MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue3);
            }
            codeWriter.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class SelectedArrayParameter
    implements Parameter {
        private SelectedArrayParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_SELECTED_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            CodeWriter codeWriter = multiGuardedSection.getWriter();
            codeWriter.write("new boolean[] { ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    codeWriter.write(", ");
                }
                PropertyValue propertyValue2 = (PropertyValue)list.get(i);
                DesignComponent designComponent2 = propertyValue2.getComponent();
                PropertyValue propertyValue3 = designComponent2.readProperty("selected");
                MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue3);
            }
            codeWriter.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class FontParameter
    implements Parameter {
        private FontParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_FONT;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("font");
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), propertyValue2);
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("font");
            return propertyValue2.getKind() != PropertyValue.Kind.NULL;
        }
    }

    private static class ImageParameter
    implements Parameter {
        private ImageParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_IMAGE;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("image");
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), propertyValue2);
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            return true;
        }
    }

    private static class StringParameter
    implements Parameter {
        private StringParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_STRING;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("string");
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), propertyValue2);
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            return true;
        }
    }
}

