/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class WatchesTreeModel
implements TreeModel {
    private Listener listener;
    private Vector listeners = new Vector();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            n2 = Math.min(watchArray.length, n2);
            n = Math.min(watchArray.length, n);
            Object[] objectArray = new Watch[n2 - n];
            System.arraycopy(watchArray, n, objectArray, 0, n2 - n);
            return objectArray;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Watch) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
        }
    }

    void fireWatchPropertyChanged(Watch watch, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)watch));
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(WatchesTreeModel watchesTreeModel) {
            this.model = new WeakReference<WatchesTreeModel>(watchesTreeModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel watchesTreeModel = (WatchesTreeModel)this.model.get();
            if (watchesTreeModel == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
                Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
                int n = watchArray.length;
                for (int i = 0; i < n; ++i) {
                    watchArray[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return watchesTreeModel;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireTreeChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireTreeChanged();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof Watch)) {
                return;
            }
            Watch watch = (Watch)propertyChangeEvent.getSource();
            watchesTreeModel.fireWatchPropertyChanged(watch, propertyChangeEvent.getPropertyName());
        }
    }
}

