/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.ui.actions.AddBreakpointAction;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class BreakpointsActionsProvider
implements NodeActionsProvider {
    private static final Action NEW_BREEAKPOINT_ACTION = new AbstractAction(NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_New_Label")){

        public void actionPerformed(ActionEvent actionEvent) {
            new AddBreakpointAction().actionPerformed(null);
        }
    };
    private static final Action ENABLE_ALL_ACTION = new AbstractAction(NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_EnableAll_Label")){

        public boolean isEnabled() {
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                if (breakpointArray[i].isEnabled()) continue;
                return true;
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                breakpointArray[i].enable();
            }
        }
    };
    private static final Action DISABLE_ALL_ACTION = new AbstractAction(NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DisableAll_Label")){

        public boolean isEnabled() {
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                if (!breakpointArray[i].isEnabled()) continue;
                return true;
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                breakpointArray[i].disable();
            }
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DeleteAll_Label")){

        public boolean isEnabled() {
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            return breakpointArray.length > 0;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                debuggerManager.removeBreakpoint(breakpointArray[i]);
            }
        }
    };
    private static final Action ENABLE_ACTION = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_Enable_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ((Breakpoint)objectArray[i]).enable();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action DISABLE_ACTION = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_Disable_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ((Breakpoint)objectArray[i]).disable();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_Delete_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(final Object[] objectArray) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        debuggerManager.removeBreakpoint((Breakpoint)objectArray[i]);
                    }
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action SET_GROUP_NAME_ACTION;
    private static final Action DELETE_ALL_ACTION_S;
    private static final Action ENABLE_ALL_ACTION_S;
    private static final Action DISABLE_ALL_ACTION_S;
    private Action moveIntoGroupAction = new MoveIntoGroupAction();

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[]{NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, DELETE_ALL_ACTION, null};
        }
        if (object instanceof String) {
            return new Action[]{SET_GROUP_NAME_ACTION, null, ENABLE_ALL_ACTION_S, DISABLE_ALL_ACTION_S, DELETE_ALL_ACTION_S, null};
        }
        if (object instanceof Breakpoint) {
            if (((Breakpoint)object).isEnabled()) {
                return new Action[]{DISABLE_ACTION, this.moveIntoGroupAction, null, NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null};
            }
            return new Action[]{ENABLE_ACTION, this.moveIntoGroupAction, null, NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof String) {
            return;
        }
        if (object instanceof Breakpoint) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static void setGroupName(Object[] objectArray) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_GroupDialog_NameLabel"), NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_GroupDialog_Title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            int n = objectArray.length;
            String string = inputLine.getInputText();
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] instanceof String) {
                    String string2 = (String)objectArray[i];
                    Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                    int n2 = breakpointArray.length;
                    for (int j = 0; j < n2; ++j) {
                        if (!breakpointArray[j].getGroupName().equals(string2)) continue;
                        breakpointArray[j].setGroupName(string);
                    }
                    continue;
                }
                if (!(objectArray[i] instanceof Breakpoint)) continue;
                ((Breakpoint)objectArray[i]).setGroupName(string);
            }
        }
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        SET_GROUP_NAME_ACTION = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_SetGroupName_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                BreakpointsActionsProvider.setGroupName(objectArray);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        DELETE_ALL_ACTION_S = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DeleteAll_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                String string = (String)objectArray[0];
                DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string)) continue;
                    debuggerManager.removeBreakpoint(breakpointArray[i]);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        ENABLE_ALL_ACTION_S = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_EnableAll_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                String string = (String)object;
                DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string) || breakpointArray[i].isEnabled()) continue;
                    return true;
                }
                return false;
            }

            public void perform(Object[] objectArray) {
                String string = (String)objectArray[0];
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string)) continue;
                    breakpointArray[i].enable();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        DISABLE_ALL_ACTION_S = Models.createAction((String)NbBundle.getBundle(BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DisableAll_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                String string = (String)object;
                DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string) || !breakpointArray[i].isEnabled()) continue;
                    return true;
                }
                return false;
            }

            public void perform(Object[] objectArray) {
                String string = (String)objectArray[0];
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string)) continue;
                    breakpointArray[i].disable();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private static class MoveIntoGroupAction
    extends AbstractAction
    implements Presenter.Popup {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        private Breakpoint[] getCurrentBreakpoints() {
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            int n = nodeArray.length;
            ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
            for (int i = 0; i < n; ++i) {
                Object object = nodeArray[i].getLookup().lookup(Object.class);
                if (!(object instanceof Breakpoint)) continue;
                arrayList.add((Breakpoint)object);
            }
            return arrayList.toArray(new Breakpoint[0]);
        }

        private String findCommonBpGroup(Breakpoint[] breakpointArray) {
            String string = null;
            for (Breakpoint breakpoint : breakpointArray) {
                String string2 = breakpoint.getGroupName();
                if (string == null) {
                    string = string2;
                    continue;
                }
                if (string.equals(string2)) continue;
                return null;
            }
            return string;
        }

        public JMenuItem getPopupPresenter() {
            final Breakpoint[] breakpointArray = this.getCurrentBreakpoints();
            String string = this.findCommonBpGroup(breakpointArray);
            JMenu jMenu = new JMenu(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_MoveIntoGroup"));
            TreeSet<String> treeSet = new TreeSet<String>();
            Breakpoint[] breakpointArray2 = DebuggerManager.getDebuggerManager().getBreakpoints();
            for (int i = 0; i < breakpointArray2.length; ++i) {
                final String string2 = breakpointArray2[i].getGroupName();
                treeSet.add(string2);
            }
            treeSet.add("");
            if (string != null) {
                treeSet.remove(string);
            }
            for (final String string2 : treeSet) {
                JMenuItem jMenuItem = string2.length() > 0 ? new JMenuItem(string2) : new JMenuItem(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_MoveIntoDefaultGroup_Label"));
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        for (Breakpoint breakpoint : breakpointArray) {
                            breakpoint.setGroupName(string2);
                        }
                    }
                });
            }
            JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_MoveIntoNewGroup_Label"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BreakpointsActionsProvider.setGroupName(breakpointArray);
                }
            });
            jMenu.add(jMenuItem);
            return jMenu;
        }
    }
}

