/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.java.platform.PlatformSettings;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationChooser
extends JFileChooser
implements PropertyChangeListener {
    private static final Dimension PREFERRED_SIZE = new Dimension(600, 340);
    private WizardDescriptor.InstantiatingIterator<WizardDescriptor> iterator;
    private Panel firer;
    private PlatformFileView platformFileView;

    public LocationChooser(Panel panel) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setName(NbBundle.getMessage(LocationChooser.class, (String)"TXT_PlatformFolderTitle"));
        this.setFileSelectionMode(1);
        this.setMultiSelectionEnabled(false);
        this.setControlButtonsAreShown(false);
        this.setFileFilter(new PlatformFileFilter());
        this.firer = panel;
        this.platformFileView = new PlatformFileView(this.getFileSystemView());
        this.setFileView(this.platformFileView);
        this.addPropertyChangeListener(this);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LocationChooser.class, (String)"AD_LocationChooser"));
        this.getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = LocationChooser.this.getParent();
                while ((container = container.getParent()) != null && !(container instanceof Window)) {
                }
                if (container != null) {
                    ((Window)container).setVisible(false);
                }
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.setBorder(null);
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            PlatformInstall platformInstall;
            FileObject fileObject;
            this.iterator = null;
            File file = this.getSelectedFile();
            if (file != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)(file = FileUtil.normalizeFile((File)file))))) != null && (platformInstall = this.platformFileView.getPlatformInstall()) != null && platformInstall.accept(fileObject)) {
                this.iterator = platformInstall.createIterator(fileObject);
            }
            this.firer.cs.fireChange();
        }
    }

    private boolean valid() {
        return this.getInstaller() != null;
    }

    private void read(WizardDescriptor wizardDescriptor) {
        PlatformSettings platformSettings = PlatformSettings.getDefault();
        if (platformSettings != null) {
            this.setCurrentDirectory(platformSettings.getPlatformsFolder());
        }
    }

    private void store(WizardDescriptor wizardDescriptor) {
        PlatformSettings platformSettings;
        File file = this.getCurrentDirectory();
        if (file != null && (platformSettings = PlatformSettings.getDefault()) != null) {
            platformSettings.setPlatformsFolder(file);
        }
    }

    private WizardDescriptor.InstantiatingIterator<WizardDescriptor> getInstaller() {
        return this.iterator;
    }

    private void setPlatformInstall(PlatformInstall platformInstall) {
        this.platformFileView.setPlatformInstall(platformInstall);
    }

    private PlatformInstall getPlatformInstall() {
        return this.platformFileView.getPlatformInstall();
    }

    private static class PlatformFileView
    extends FileView {
        private static final Icon BADGE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/platform/resources/platformBadge.gif", (boolean)false);
        private static final Icon EMPTY = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/platform/resources/empty.gif", (boolean)false);
        private FileSystemView fsv;
        private Icon lastOriginal;
        private Icon lastMerged;
        private PlatformInstall platformInstall;

        public PlatformFileView(FileSystemView fileSystemView) {
            this.fsv = fileSystemView;
        }

        public Icon getIcon(File file) {
            File file2 = FileUtil.normalizeFile((File)file);
            Icon icon = this.fsv.getSystemIcon(file2);
            if (icon == null) {
                icon = EMPTY;
            }
            if (this.isPlatformDir(file2)) {
                if (icon.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = icon;
                this.lastMerged = new MergedIcon(icon, BADGE, -1, -1);
                return this.lastMerged;
            }
            return icon;
        }

        public void setPlatformInstall(PlatformInstall platformInstall) {
            this.platformInstall = platformInstall;
        }

        public PlatformInstall getPlatformInstall() {
            return this.platformInstall;
        }

        private boolean isPlatformDir(File file) {
            FileObject fileObject;
            int n = Utilities.getOperatingSystem();
            if (n == 8 || n == 256) {
                return false;
            }
            FileObject fileObject2 = fileObject = file != null ? PlatformFileView.convertToValidDir(file) : null;
            if (fileObject != null) {
                try {
                    if (Utilities.isUnix() && (fileObject.getParent() == null || fileObject.getFileSystem().getRoot().equals(fileObject.getParent()))) {
                        return false;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return false;
                }
                if (this.platformInstall.accept(fileObject)) {
                    return true;
                }
            }
            return false;
        }

        private static FileObject convertToValidDir(File file) {
            File file2 = new File(file.getPath());
            if (file2 == null || file2.getParent() == null) {
                return null;
            }
            if (!file2.isDirectory()) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            return fileObject;
        }
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            this.icon1 = icon;
            this.icon2 = icon2;
            if (n == -1) {
                n = icon.getIconWidth() - icon2.getIconWidth();
            }
            if (n2 == -1) {
                n2 = icon.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = n;
            this.yMerge = n2;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2);
            this.icon2.paintIcon(component, graphics, n + this.xMerge, n2 + this.yMerge);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor> {
        LocationChooser component;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public LocationChooser getComponent() {
            if (this.component == null) {
                this.component = new LocationChooser(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(LocationChooser.class);
        }

        public boolean isValid() {
            return this.getComponent().valid();
        }

        public void readSettings(WizardDescriptor wizardDescriptor) {
            this.getComponent().read(wizardDescriptor);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public void storeSettings(WizardDescriptor wizardDescriptor) {
            this.getComponent().store(wizardDescriptor);
        }

        WizardDescriptor.InstantiatingIterator<WizardDescriptor> getInstallerIterator() {
            return this.getComponent().getInstaller();
        }

        void setPlatformInstall(PlatformInstall platformInstall) {
            this.getComponent().setPlatformInstall(platformInstall);
        }

        PlatformInstall getPlatformInstall() {
            return this.getComponent().getPlatformInstall();
        }
    }

    private static class PlatformAccessory
    extends JPanel {
        private JTextField tf;

        public PlatformAccessory() {
            this.initComponents();
        }

        private void setType(String string) {
            this.tf.setText(string);
        }

        private void initComponents() {
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LocationChooser.class, (String)"AN_LocationChooserAccessiory"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LocationChooser.class, (String)"AD_LocationChooserAccessiory"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel(NbBundle.getMessage(LocationChooser.class, (String)"TXT_PlatformType"));
            jLabel.setDisplayedMnemonic(NbBundle.getMessage(LocationChooser.class, (String)"MNE_PlatformType").charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 12, 3, 12);
            gridBagConstraints.anchor = 18;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.tf = new JTextField();
            this.tf.setColumns(15);
            this.tf.setEditable(false);
            this.tf.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LocationChooser.class, (String)"AD_PlatformType"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(3, 12, 12, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.tf, gridBagConstraints);
            this.add(this.tf);
            jLabel.setLabelFor(this.tf);
            JPanel jPanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 12, 12, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }
    }

    private static class PlatformFileFilter
    extends FileFilter {
        private PlatformFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(LocationChooser.class, (String)"TXT_PlatformFolder");
        }
    }
}

