/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.ForNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubySemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;
    private static final Set<String> JAVA_PREFIXES = new HashSet<String>();
    private static final Set<String> SKIP_HIGHLIGHTNING = new HashSet<String>();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(result);
        if (rubyParseResult == null) {
            return;
        }
        Node node = rubyParseResult.getRootNode();
        if (node == null) {
            return;
        }
        HashMap<OffsetRange, Set<Object>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        AstPath astPath = new AstPath();
        astPath.descend(node);
        this.annotate(node, hashMap, astPath, null, false);
        astPath.ascend();
        if (this.isCancelled()) {
            return;
        }
        if (hashMap.size() > 0) {
            HashMap hashMap2 = new HashMap(2 * hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                OffsetRange offsetRange = LexUtilities.getLexerOffsets(result, (OffsetRange)entry.getKey());
                if (offsetRange == OffsetRange.NONE) continue;
                hashMap2.put(offsetRange, entry.getValue());
            }
            hashMap = hashMap2;
            this.semanticHighlights = hashMap;
        } else {
            this.semanticHighlights = null;
        }
    }

    private void annotate(Node node, Map<OffsetRange, Set<ColoringAttributes>> map, AstPath astPath, List<String> list, boolean bl) {
        Object object;
        Object object2;
        switch (node.getNodeType()) {
            case ARGSNODE: {
                bl = true;
                break;
            }
            case LOCALASGNNODE: {
                String string;
                object2 = (LocalAsgnNode)node;
                object = AstUtilities.findLocalScope(node, astPath);
                boolean bl2 = this.isUsedInMethod((Node)object, object2.getName(), bl);
                if (!bl2) {
                    OffsetRange object32 = AstUtilities.getLValueRange((AssignableNode)object2);
                    map.put(object32, ColoringAttributes.UNUSED_SET);
                    break;
                }
                if (list == null || !list.contains(string = ((LocalAsgnNode)node).getName())) break;
                OffsetRange offsetRange = AstUtilities.getNameRange(node);
                map.put(offsetRange, ColoringAttributes.PARAMETER_SET);
                break;
            }
            case DASGNNODE: {
                object2 = (DAsgnNode)node;
                object = AstUtilities.findLocalScope(node, astPath);
                boolean bl3 = this.isUsedInMethod((Node)object, object2.getName(), false);
                if (bl3) break;
                OffsetRange offsetRange = AstUtilities.getLValueRange((AssignableNode)object2);
                map.put(offsetRange, ColoringAttributes.UNUSED_SET);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                object2 = (MethodDefNode)node;
                list = AstUtilities.getDefArgs((MethodDefNode)object2, true);
                if (list != null && list.size() > 0) {
                    object = new ArrayList();
                    for (String string : list) {
                        boolean bl2 = this.isUsedInMethod(node, string, true);
                        if (bl2) continue;
                        object.add(string);
                    }
                    if (object.size() > 0) {
                        this.annotateUnusedParameters((MethodDefNode)object2, map, (List<String>)object);
                        list.removeAll((Collection<?>)object);
                    }
                    if (list != null) {
                        if (list.size() == 0) {
                            list = null;
                        } else {
                            this.annotateParameters((MethodDefNode)object2, map, list);
                        }
                    }
                }
                if (SKIP_HIGHLIGHTNING.contains(AstUtilities.getName(node))) break;
                this.highlightMethodName(node, map);
                break;
            }
            case LOCALVARNODE: {
                if (list == null || !list.contains(((LocalVarNode)node).getName())) break;
                object2 = AstUtilities.getRange(node);
                map.put((OffsetRange)object2, ColoringAttributes.PARAMETER_SET);
                break;
            }
            case VCALLNODE: {
                if (JAVA_PREFIXES.contains(((INameNode)node).getName())) break;
            }
            case FCALLNODE: {
                object2 = AstUtilities.getCallRange(node);
                if (SKIP_HIGHLIGHTNING.contains(AstUtilities.getName(node))) break;
                map.put((OffsetRange)object2, ColoringAttributes.METHOD_SET);
                break;
            }
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (node2.isInvisible()) continue;
            astPath.descend(node2);
            this.annotate(node2, map, astPath, list, bl);
            astPath.ascend();
        }
    }

    private void annotateParameters(MethodDefNode methodDefNode, Map<OffsetRange, Set<ColoringAttributes>> map, List<String> list) {
        List list2 = methodDefNode.childNodes();
        for (Node node : list2) {
            OffsetRange offsetRange;
            List list3;
            if (node.getNodeType() != NodeType.ARGSNODE) continue;
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode.getRequiredCount() > 0) {
                list3 = argsNode.childNodes();
                for (Node node2 : list3) {
                    if (!(node2 instanceof ListNode)) continue;
                    List list4 = node2.childNodes();
                    for (Node node3 : list4) {
                        OffsetRange offsetRange2;
                        if (node3.getNodeType() == NodeType.ARGUMENTNODE) {
                            if (!list.contains(((ArgumentNode)node3).getName())) continue;
                            offsetRange2 = AstUtilities.getRange(node3);
                            map.put(offsetRange2, ColoringAttributes.PARAMETER_SET);
                            continue;
                        }
                        if (node3.getNodeType() != NodeType.LOCALASGNNODE || !list.contains(((LocalAsgnNode)node3).getName())) continue;
                        offsetRange2 = AstUtilities.getNameRange(node3);
                        map.put(offsetRange2, ColoringAttributes.PARAMETER_SET);
                    }
                }
            }
            if (argsNode.getRest() != null && list.contains((list3 = argsNode.getRest()).getName())) {
                offsetRange = AstUtilities.getRange((Node)list3);
                map.put(offsetRange, ColoringAttributes.PARAMETER_SET);
            }
            if (argsNode.getRest() != null && list.contains((list3 = argsNode.getRest()).getName())) {
                offsetRange = AstUtilities.getRange((Node)list3);
                map.put(offsetRange, ColoringAttributes.PARAMETER_SET);
            }
            if (argsNode.getBlock() == null || !list.contains((list3 = argsNode.getBlock()).getName())) continue;
            offsetRange = AstUtilities.getRange((Node)list3);
            map.put(offsetRange, ColoringAttributes.PARAMETER_SET);
        }
    }

    private void annotateUnusedParameters(MethodDefNode methodDefNode, Map<OffsetRange, Set<ColoringAttributes>> map, List<String> list) {
        List list2 = methodDefNode.childNodes();
        for (Node node : list2) {
            OffsetRange offsetRange;
            List list3;
            if (node.getNodeType() != NodeType.ARGSNODE) continue;
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode.getRequiredCount() > 0) {
                list3 = argsNode.childNodes();
                for (Node node2 : list3) {
                    if (!(node2 instanceof ListNode)) continue;
                    List list4 = node2.childNodes();
                    for (Node node3 : list4) {
                        OffsetRange offsetRange2;
                        if (node3.getNodeType() == NodeType.ARGUMENTNODE) {
                            if (!list.contains(((ArgumentNode)node3).getName())) continue;
                            offsetRange2 = AstUtilities.getRange(node3);
                            map.put(offsetRange2, ColoringAttributes.UNUSED_SET);
                            continue;
                        }
                        if (node3.getNodeType() != NodeType.LOCALASGNNODE || !list.contains(((LocalAsgnNode)node3).getName())) continue;
                        offsetRange2 = AstUtilities.getNameRange(node3);
                        map.put(offsetRange2, ColoringAttributes.UNUSED_SET);
                    }
                }
            }
            if (argsNode.getRest() != null && list.contains((list3 = argsNode.getRest()).getName())) {
                offsetRange = AstUtilities.getRange((Node)list3);
                map.put(offsetRange, ColoringAttributes.UNUSED_SET);
            }
            if (argsNode.getBlock() == null || !list.contains((list3 = argsNode.getBlock()).getName())) continue;
            offsetRange = AstUtilities.getRange((Node)list3);
            map.put(offsetRange, ColoringAttributes.UNUSED_SET);
        }
    }

    private boolean isUsedInMethod(Node node, String string, boolean bl) {
        Object object;
        switch (node.getNodeType()) {
            case LOCALVARNODE: {
                if (node.getNodeType() != NodeType.LOCALVARNODE || !string.equals(object = ((LocalVarNode)node).getName())) break;
                return true;
            }
            case FORNODE: {
                object = ((ForNode)node).getIterNode();
                if (!(object instanceof INameNode) || !string.equals(((INameNode)object).getName())) break;
                return true;
            }
            case DVARNODE: {
                if (!string.equals(((DVarNode)node).getName())) break;
                return true;
            }
            case ALIASNODE: {
                object = (AliasNode)node;
                if (!object.getOldName().equals(string)) break;
                return true;
            }
            case ZSUPERNODE: {
                if (!bl) break;
                return true;
            }
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible() || node2.getNodeType() == NodeType.DEFSNODE || node2.getNodeType() == NodeType.DEFNNODE || !(bl2 = this.isUsedInMethod(node2, string, bl))) continue;
            return true;
        }
        return false;
    }

    private void highlightMethodName(Node node, Map<OffsetRange, Set<ColoringAttributes>> map) {
        OffsetRange offsetRange = AstUtilities.getFunctionNameRange(node);
        if (offsetRange != OffsetRange.NONE && !map.containsKey(offsetRange)) {
            map.put(offsetRange, ColoringAttributes.METHOD_SET);
        }
    }

    static {
        JAVA_PREFIXES.add("java");
        JAVA_PREFIXES.add("javax");
        JAVA_PREFIXES.add("org");
        JAVA_PREFIXES.add("com");
        SKIP_HIGHLIGHTNING.add("[]");
    }
}

