/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.elements.IndexedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RubyDynamicFindersCompleter {
    private final CompletionRequest request;
    private final int anchor;
    private final List<? super CompletionProposal> proposals;

    private RubyDynamicFindersCompleter(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n) {
        this.request = completionRequest;
        this.anchor = n;
        this.proposals = list;
    }

    static Set<IndexedMethod> proposeDynamicMethods(Set<IndexedMethod> set, List<? super CompletionProposal> list, CompletionRequest completionRequest, int n) {
        RubyDynamicFindersCompleter rubyDynamicFindersCompleter = new RubyDynamicFindersCompleter(list, completionRequest, n);
        return rubyDynamicFindersCompleter.filterAndHandleDynamicMethods(set);
    }

    private Set<IndexedMethod> filterAndHandleDynamicMethods(Set<IndexedMethod> set) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>(set);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (IndexedMethod indexedMethod : set) {
            if (IndexedMethod.MethodType.DYNAMIC_FINDER != indexedMethod.getMethodType()) continue;
            hashSet2.add(indexedMethod);
            hashSet.remove(indexedMethod);
        }
        this.proposeDynamicMethods(hashSet2);
        return hashSet;
    }

    private void proposeDynamicMethods(Set<IndexedMethod> set) {
        HashMap<String, IndexedMethod> hashMap = new HashMap<String, IndexedMethod>();
        Iterator<IndexedMethod> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            IndexedMethod indexedMethod = iterator.next();
            String string = indexedMethod.getName();
            int n = FindersHelper.nextAttributeLocation(string, this.request.prefix.length());
            if (n != -1) {
                object = FindersHelper.subToNextAttribute(string, n);
                if (hashMap.get(object) == null) {
                    hashMap.put((String)object, indexedMethod);
                    RubyCompletionItem.VirtualFinderMethodItem virtualFinderMethodItem = new RubyCompletionItem.VirtualFinderMethodItem(indexedMethod, this.anchor, this.request, (String)object);
                    virtualFinderMethodItem.setSmart(indexedMethod.isSmart());
                    this.proposals.add((CompletionProposal)virtualFinderMethodItem);
                }
                iterator.remove();
                continue;
            }
            object = new RubyCompletionItem.FinderMethodItem(indexedMethod, this.anchor, this.request);
            object.setSmart(indexedMethod.isSmart());
            this.proposals.add((CompletionProposal)object);
        }
    }
}

