/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

abstract class RubyDeclarationFinderHelper {
    protected static final boolean CHOOSE_ONE_DECLARATION = Boolean.getBoolean("ruby.choose_one_decl");

    RubyDeclarationFinderHelper() {
    }

    protected static DeclarationFinder.DeclarationLocation fix(DeclarationFinder.DeclarationLocation declarationLocation, ParserResult parserResult) {
        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE && declarationLocation.getFileObject() == null && declarationLocation.getUrl() == null) {
            return new DeclarationFinder.DeclarationLocation(RubyUtils.getFileObject((Parser.Result)parserResult), declarationLocation.getOffset(), declarationLocation.getElement());
        }
        return declarationLocation;
    }

    protected static DeclarationFinder.DeclarationLocation getLocation(ParserResult parserResult, Node node) {
        AstElement astElement = AstElement.create(parserResult, node);
        int n = LexUtilities.getLexerOffset((Parser.Result)parserResult, node.getPosition().getStartOffset());
        return new DeclarationFinder.DeclarationLocation(null, n, (ElementHandle)astElement);
    }

    protected static class RubyAltLocation
    implements DeclarationFinder.AlternativeLocation {
        private IndexedElement element;
        private boolean isPreferred;
        private String cachedDisplayItem;

        RubyAltLocation(IndexedElement indexedElement, boolean bl) {
            this.element = indexedElement;
            this.isPreferred = bl;
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.setMaxLength(120);
            if (this.cachedDisplayItem == null) {
                Object object;
                Object object2;
                Object object3;
                htmlFormatter.reset();
                boolean bl = this.element.isNoDoc();
                boolean bl2 = this.element.isDocumented();
                if (this.isPreferred) {
                    htmlFormatter.emphasis(true);
                } else if (bl) {
                    htmlFormatter.deprecated(true);
                }
                if (this.element instanceof IndexedMethod) {
                    if (this.element.getFqn() != null) {
                        htmlFormatter.appendText(this.element.getFqn());
                        htmlFormatter.appendText(".");
                    }
                    htmlFormatter.appendText(this.element.getName());
                    object3 = (IndexedMethod)this.element;
                    object2 = ((IndexedMethod)object3).getParameters();
                    if (object2 != null && object2.size() > 0) {
                        htmlFormatter.appendText("(");
                        object = object2.iterator();
                        while (object.hasNext()) {
                            htmlFormatter.parameters(true);
                            htmlFormatter.appendText((String)object.next());
                            htmlFormatter.parameters(false);
                            if (!object.hasNext()) continue;
                            htmlFormatter.appendText(", ");
                        }
                        htmlFormatter.appendText(")");
                    }
                } else {
                    htmlFormatter.appendText(this.element.getFqn());
                }
                object3 = null;
                object2 = this.element.getFileUrl();
                if (object2 != null) {
                    if (RubyUtils.isRubyStubsURL((String)object2)) {
                        int n;
                        object3 = NbBundle.getMessage(RubyDeclarationFinder.class, (String)"RubyLib");
                        if (((String)object2).indexOf("/stub_") == -1 && (n = ((String)object2).indexOf((String)(object = "rubystubs/1.8.7-p72"))) != -1) {
                            object3 = (String)object3 + ": " + ((String)object2).substring(n);
                        }
                    } else {
                        int n;
                        int n2;
                        Object object4;
                        object = this.element.getFileObject();
                        if (object != null) {
                            object3 = object.getNameExt();
                        } else {
                            int n3 = ((String)object2).lastIndexOf(47);
                            if (n3 != -1) {
                                object4 = ((String)object2).substring(0, n3);
                                n2 = ((String)object4).lastIndexOf(47);
                                if (n2 != -1 && ((String)object2).length() - n2 < 40) {
                                    object3 = ((String)object2).substring(n2 + 1);
                                    if (((String)object3).indexOf(58) != -1) {
                                        object3 = ((String)object2).substring(n3 + 1);
                                    }
                                } else {
                                    object3 = ((String)object2).substring(n3 + 1);
                                }
                            }
                        }
                        Pattern pattern = Pattern.compile("lib/ruby/gems/\\d+\\.\\d+/gems/");
                        object4 = pattern.matcher((CharSequence)object2);
                        if (((Matcher)object4).find() && (n = ((String)object2).indexOf(47, n2 = ((Matcher)object4).end())) != -1) {
                            object3 = ((String)object2).substring(n2, n) + ": " + (String)object3;
                        }
                    }
                }
                if (object3 != null) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(RubyDeclarationFinder.class, (String)"In"));
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText((String)object3);
                }
                if (bl2) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(RubyDeclarationFinder.class, (String)"Documented"));
                } else if (bl) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(RubyDeclarationFinder.class, (String)"NoDoced"));
                }
                if (this.isPreferred) {
                    htmlFormatter.emphasis(false);
                } else if (bl) {
                    htmlFormatter.deprecated(false);
                }
                this.cachedDisplayItem = htmlFormatter.getText();
            }
            return this.cachedDisplayItem;
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            Node node = AstUtilities.getForeignNode(this.element);
            int n = node != null ? node.getPosition().getStartOffset() : -1;
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(this.element.getFileObject(), n, (ElementHandle)this.element);
            return declarationLocation;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            String string;
            RubyAltLocation rubyAltLocation = (RubyAltLocation)alternativeLocation;
            if (this.isPreferred) {
                return -1;
            }
            if (rubyAltLocation.isPreferred) {
                return 1;
            }
            if (this.element.isNoDoc() != rubyAltLocation.element.isNoDoc()) {
                return this.element.isNoDoc() ? 1 : -1;
            }
            if (this.element.isDocumented() != rubyAltLocation.element.isDocumented()) {
                return this.element.isDocumented() ? -1 : 1;
            }
            String string2 = this.element.getIn() != null ? this.element.getIn() : "";
            int n = string2.compareTo(string = rubyAltLocation.element.getIn() != null ? rubyAltLocation.element.getIn() : "");
            if (n != 0) {
                return n;
            }
            String string3 = this.element.getFileObject() != null ? this.element.getFileObject().getNameExt() : "";
            String string4 = rubyAltLocation.element.getFileObject() != null ? rubyAltLocation.element.getFileObject().getNameExt() : "";
            n = string3.compareTo(string4);
            return n;
        }
    }
}

