/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.ImageIcon;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.IndexedVariable;
import org.netbeans.modules.ruby.elements.KeywordElement;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RubyCompletionItem
extends DefaultCompletionProposal {
    private static final boolean FORCE_COMPLETION_SPACES = Boolean.getBoolean("ruby.complete.spaces");
    protected final CompletionRequest request;
    protected final Element element;
    protected boolean symbol;

    RubyCompletionItem(Element element, int n, CompletionRequest completionRequest) {
        this.element = element;
        this.anchorOffset = n;
        this.request = completionRequest;
    }

    public String getName() {
        return this.element.getName();
    }

    public void setSymbol(boolean bl) {
        this.symbol = bl;
    }

    public String getInsertPrefix() {
        if (this.symbol) {
            return ":" + this.getName();
        }
        return this.getName();
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        IndexedVariable indexedVariable;
        String string;
        if (this.element.getKind() == ElementKind.GLOBAL && this.element instanceof IndexedVariable && (string = (indexedVariable = (IndexedVariable)this.element).getIn()) != null) {
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public String toString() {
        String string = ((Object)((Object)this)).getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(" + this.getKind() + "): " + this.getName();
    }

    public String[] getParamListDelimiters() {
        return new String[]{"(", ")"};
    }

    private static boolean forceCompletionSpaces() {
        return FORCE_COMPLETION_SPACES;
    }

    static class VirtualFinderMethodItem
    extends MethodItem {
        private final String prefix;

        public VirtualFinderMethodItem(IndexedMethod indexedMethod, int n, CompletionRequest completionRequest, String string) {
            super(indexedMethod, n, completionRequest);
            this.prefix = string;
        }

        protected boolean skipHashes() {
            return true;
        }

        protected String getInsertSuffix() {
            return "";
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            boolean bl;
            ElementKind elementKind = this.getKind();
            boolean bl2 = bl = !this.method.isInherited();
            if (bl) {
                htmlFormatter.emphasis(true);
            }
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.prefix + "...");
            htmlFormatter.name(elementKind, false);
            if (bl) {
                htmlFormatter.emphasis(false);
            }
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.method.isTopLevel() && this.method.getRequire() != null) {
                htmlFormatter.appendText(this.method.getRequire());
                return htmlFormatter.getText();
            }
            String string = this.method.getIn();
            if (string != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }

        public String getInsertPrefix() {
            return this.prefix;
        }
    }

    static class FinderMethodItem
    extends MethodItem {
        public FinderMethodItem(IndexedMethod indexedMethod, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
        }

        protected boolean skipHashes() {
            return true;
        }
    }

    static class MethodItem
    extends RubyCompletionItem {
        protected final IndexedMethod method;

        MethodItem(IndexedMethod indexedMethod, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
            this.method = indexedMethod;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            List<String> list;
            boolean bl;
            ElementKind elementKind = this.getKind();
            boolean bl2 = bl = !this.method.isInherited();
            if (bl) {
                htmlFormatter.emphasis(true);
            }
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(elementKind, false);
            if (bl) {
                htmlFormatter.emphasis(false);
            }
            if ((list = this.method.getParameters()) != null && !list.isEmpty()) {
                htmlFormatter.appendHtml("(");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    htmlFormatter.parameters(true);
                    htmlFormatter.appendText((String)iterator.next());
                    htmlFormatter.parameters(false);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendText(", ");
                }
                htmlFormatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                htmlFormatter.appendText(" { }");
            }
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.method.isTopLevel() && this.method.getRequire() != null) {
                htmlFormatter.appendText(this.method.getRequire());
                return htmlFormatter.getText();
            }
            String string = this.method.getIn();
            if (string != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }

        public String getCustomInsertTemplate() {
            String string;
            Object object;
            String string2;
            String string3;
            boolean bl;
            int n;
            String string4 = this.getInsertPrefix();
            List<String> list = this.method.getParameters();
            boolean bl2 = false;
            int n2 = n = list.size();
            boolean bl3 = bl = this.method.getEncodedAttributes() != null && this.method.getEncodedAttributes().indexOf("=>") != -1;
            if (n > 0 && list.get(n - 1).startsWith("&")) {
                bl2 = true;
                --n2;
                string3 = "(";
                string2 = ")";
            } else if (this.method.hasBlock()) {
                bl2 = true;
                if (n > 0) {
                    string3 = "(";
                    string2 = ")";
                } else {
                    string3 = "";
                    string2 = "";
                }
            } else {
                object = this.getParamListDelimiters();
                assert (((String[])object).length == 2);
                string3 = object[0];
                string2 = object[1];
                if (n2 == 0) {
                    string3 = "";
                    string2 = "";
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string4);
            if (bl && this.skipHashes()) {
                ((StringBuilder)object).append(this.getInsertSuffix());
                return ((StringBuilder)object).toString();
            }
            ((StringBuilder)object).append(string3);
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                string = list.get(i);
                ((StringBuilder)object).append("${");
                ((StringBuilder)object).append("ruby-cc-");
                ((StringBuilder)object).append(Integer.toString(n3++));
                ((StringBuilder)object).append(" default=\"");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("\"");
                ((StringBuilder)object).append("}");
                if (i >= n2 - 1) continue;
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append(string2);
            if (bl2) {
                int n4;
                int n5;
                String[] stringArray = null;
                string = this.method.getEncodedAttributes();
                if (string != null && (n5 = string.indexOf(59)) != -1 && (n4 = string.indexOf(59, n5 + 1)) != -1) {
                    stringArray = string.substring(n5 + 1, n4).split(",");
                }
                ((StringBuilder)object).append(" { |");
                if (stringArray != null && stringArray.length > 0) {
                    for (n5 = 0; n5 < stringArray.length; ++n5) {
                        if (n5 > 0) {
                            ((StringBuilder)object).append(",");
                        }
                        void var14_16 = stringArray[n5];
                        ((StringBuilder)object).append("${unusedlocal defaults=\"");
                        ((StringBuilder)object).append((String)var14_16);
                        ((StringBuilder)object).append("\"}");
                    }
                } else {
                    ((StringBuilder)object).append("${unusedlocal defaults=\"i,e\"}");
                }
                ((StringBuilder)object).append("| ${");
                ((StringBuilder)object).append("ruby-cc-");
                ((StringBuilder)object).append(Integer.toString(n3++));
                ((StringBuilder)object).append(" default=\"\"} }${cursor}");
            } else {
                ((StringBuilder)object).append("${cursor}");
            }
            return ((StringBuilder)object).toString();
        }

        protected boolean skipHashes() {
            return true;
        }

        protected String getInsertSuffix() {
            return " ";
        }

        public String[] getParamListDelimiters() {
            List<String> list;
            String string = this.getName();
            String string2 = this.element.getIn();
            if ("Module".equals(string2)) {
                if (string.startsWith("attr_")) {
                    return new String[]{" :", " "};
                }
                if (string.equals("include") || string.equals("import")) {
                    return new String[]{" ", " "};
                }
                if (string.equals("include_package")) {
                    return new String[]{" '", "'"};
                }
            } else if ("Kernel".equals(string2)) {
                if (string.equals("require")) {
                    return new String[]{" '", "'"};
                }
                if (string.equals("p")) {
                    return new String[]{" ", " "};
                }
            } else if ("Object".equals(string2) && string.equals("include_class")) {
                return new String[]{" '", "'"};
            }
            if (RubyCompletionItem.forceCompletionSpaces()) {
                boolean bl = false;
                AstPath astPath = this.request.path;
                if (astPath != null) {
                    ListIterator<Node> listIterator = astPath.leafToRoot();
                    while (listIterator.hasNext()) {
                        Node node = (Node)listIterator.next();
                        if (!AstUtilities.isCall(node) || node == this.request.target) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    return new String[]{"(", ")"};
                }
                return new String[]{" ", " "};
            }
            if (this.element instanceof IndexedElement && (list = RubyCodeCompleter.getComments(null, this.element)) != null && !list.isEmpty()) {
                String string3 = this.getName();
                boolean bl = false;
                boolean bl2 = false;
                for (String string4 : list) {
                    int n;
                    if (!string4.startsWith("#  ")) continue;
                    int n2 = 0;
                    int n3 = string4.length();
                    while ((n = string4.indexOf(string3, n2)) != -1) {
                        n2 = n += string3.length();
                        if (n >= n3) continue;
                        char c = string4.charAt(n);
                        if (c == ' ') {
                            bl = true;
                            continue;
                        }
                        if (c != '(') continue;
                        bl2 = true;
                    }
                }
                if (!bl2 && bl) {
                    return new String[]{" ", " "};
                }
            }
            return super.getParamListDelimiters();
        }

        public ElementKind getKind() {
            if (this.method.getMethodType() == IndexedMethod.MethodType.ATTRIBUTE) {
                return ElementKind.ATTRIBUTE;
            }
            return this.element.getKind();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbItem
    extends RubyCompletionItem {
        private final String name;
        private final String type;

        DbItem(Element element, String string, String string2, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
            this.name = string;
            this.type = string2;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.emphasis(true);
            htmlFormatter.name(ElementKind.DB, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(ElementKind.DB, false);
            htmlFormatter.emphasis(false);
            return htmlFormatter.getText();
        }

        @Override
        public String getInsertPrefix() {
            return this.name;
        }

        @Override
        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.type);
            return htmlFormatter.getText();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.DB;
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CallItem
    extends MethodItem {
        private final IndexedMethod method;
        private final int index;

        CallItem(IndexedMethod indexedMethod, int n, int n2, CompletionRequest completionRequest) {
            super(indexedMethod, n2, completionRequest);
            this.method = indexedMethod;
            this.index = n;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CALL;
        }

        @Override
        public String getInsertPrefix() {
            return "";
        }

        @Override
        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            List<String> list = this.method.getParameters();
            if (list != null && !list.isEmpty()) {
                htmlFormatter.appendHtml("(");
                if (this.index > 0 && this.index < list.size()) {
                    htmlFormatter.appendText("... , ");
                }
                htmlFormatter.active(true);
                htmlFormatter.appendText(list.get(Math.min(list.size() - 1, this.index)));
                htmlFormatter.active(false);
                if (this.index < list.size() - 1) {
                    htmlFormatter.appendText(", ...");
                }
                htmlFormatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                htmlFormatter.appendText(" { }");
            }
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        public boolean isSmart() {
            return true;
        }

        public List<String> getInsertParams() {
            return null;
        }

        @Override
        public String getCustomInsertTemplate() {
            return null;
        }
    }

    static class ParameterItem
    extends RubyCompletionItem {
        private static ImageIcon symbolIcon;
        private static final String CONSTANT_ICON = "org/netbeans/modules/ruby/symbol.png";
        private final String name;
        private final String desc;
        private final String insert;

        ParameterItem(IndexedMethod indexedMethod, String string, String string2, String string3, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
            this.name = string;
            this.desc = string2;
            this.insert = string3;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.desc != null) {
                htmlFormatter.appendText(this.desc);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        public ImageIcon getIcon() {
            if (symbolIcon == null) {
                symbolIcon = ImageUtilities.loadImageIcon((String)CONSTANT_ICON, (boolean)false);
            }
            return symbolIcon;
        }

        public String getName() {
            return this.name;
        }

        public String getInsertPrefix() {
            return this.insert;
        }
    }

    static class FieldItem
    extends RubyCompletionItem {
        private final String forcedPrefix;

        FieldItem(Element element, int n, CompletionRequest completionRequest) {
            this(element, n, completionRequest, null);
        }

        FieldItem(Element element, int n, CompletionRequest completionRequest, String string) {
            super(element, n, completionRequest);
            this.forcedPrefix = string;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            if (this.element instanceof IndexedField) {
                boolean bl;
                IndexedField indexedField = (IndexedField)this.element;
                boolean bl2 = bl = !indexedField.isInherited();
                if (bl) {
                    htmlFormatter.emphasis(true);
                }
                htmlFormatter.name(ElementKind.FIELD, true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.name(ElementKind.FIELD, false);
                if (bl) {
                    htmlFormatter.emphasis(false);
                }
                return htmlFormatter.getText();
            }
            return super.getLhsHtml(htmlFormatter);
        }

        public String getInsertPrefix() {
            if (this.forcedPrefix != null) {
                return this.forcedPrefix + this.getName();
            }
            String string = this.element.getModifiers().contains(Modifier.STATIC) ? "@@" + this.getName() : "@" + this.getName();
            if (this.symbol) {
                string = ":" + string;
            }
            return string;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            IndexedField indexedField;
            String string;
            if (this.element instanceof IndexedField && (string = (indexedField = (IndexedField)this.element).getIn()) != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }
    }

    static class ClassItem
    extends RubyCompletionItem {
        ClassItem(Element element, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = ((ClassElement)this.element).getIn();
            if (string == null) {
                return null;
            }
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeywordItem
    extends RubyCompletionItem {
        private static ImageIcon keywordIcon;
        private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
        private final String keyword;
        private final String description;

        KeywordItem(String string, String string2, int n, CompletionRequest completionRequest) {
            super(null, n, completionRequest);
            this.keyword = string;
            this.description = string2;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.keyword);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(elementKind, false);
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
            }
            return htmlFormatter.getText();
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)RUBY_KEYWORD, (boolean)false);
            }
            return keywordIcon;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return new KeywordElement(this.keyword);
        }
    }
}

