/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.lexer.Call;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RubyClassCompleter
extends RubyBaseCompleter {
    private final boolean showSymbols;
    private final Call call;

    static boolean complete(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl, Call call, boolean bl2) {
        RubyClassCompleter rubyClassCompleter = new RubyClassCompleter(list, completionRequest, n, bl, call, bl2);
        return rubyClassCompleter.complete();
    }

    private RubyClassCompleter(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl, Call call, boolean bl2) {
        super(list, completionRequest, n, bl);
        this.call = call;
        this.showSymbols = bl2;
    }

    private boolean complete() {
        String string = this.request.prefix;
        QuerySupport.Kind kind = this.request.kind;
        int n = this.anchor;
        int n2 = string.lastIndexOf("::");
        if (n2 != -1) {
            n += n2 + 2;
        }
        String string2 = string;
        if (this.call.isMethodExpected()) {
            return false;
        }
        RubyType rubyType = this.call.getType();
        String string3 = this.call.getLhs();
        if (string3 != null && rubyType.isSingleton() && string3.equals(rubyType.first())) {
            string2 = rubyType.first() + "::" + string;
        }
        AstPath astPath = this.request.path;
        String string4 = AstUtilities.getFqnName(astPath);
        HashSet<String> hashSet = new HashSet<String>();
        Set<IndexedClass> set = this.getIndex().getClasses(string2, kind, false, false, false, hashSet);
        if (string4 != null && string4.length() > 0) {
            Set<IndexedClass> set2 = this.getIndex().getClasses(string4 + "::" + string2, kind, false, false, false, hashSet);
            set.addAll((Collection<IndexedClass>)set2);
        }
        for (IndexedClass indexedClass : set) {
            if (indexedClass.isNoDoc()) continue;
            RubyCompletionItem.ClassItem classItem = new RubyCompletionItem.ClassItem(indexedClass, n, this.request);
            classItem.setSmart(true);
            if (this.showSymbols) {
                classItem.setSymbol(true);
            }
            this.propose((CompletionProposal)classItem);
        }
        return false;
    }
}

