/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.NbBundle;

public final class SVGStatusBar
extends JPanel {
    public static final int CELL_POSITION = 0;
    public static final int CELL_MODE = 1;
    public static final int CELL_MAIN = 2;
    public static final String LOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"LBL_STATUS_BAR_LOCKED");
    public static final String UNLOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"LBL_STATUS_BAR_UNLOCKED");
    public static final String TOOLTIP_LOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"HINT_STATUS_BAR_LOCKED");
    public static final String TOOLTIP_UNLOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"HINT_STATUS_BAR_UNLOCKED");
    private static final String[] POS_MAX_STRINGS = new String[]{"-99999.9:-99999.9"};
    private final Cell[] cells = new Cell[3];

    public SVGStatusBar() {
        super(new GridBagLayout());
        Cell cell = this.cells[0] = new Cell(POS_MAX_STRINGS);
        cell.setHorizontalAlignment(0);
        cell.setToolTipText("SVG coordinates");
        this.setText(0, "[-,-]");
        cell = this.cells[1] = new Cell(new String[]{LOCKED, UNLOCKED});
        cell.setHorizontalAlignment(0);
        this.cells[2] = new Cell(null);
        this.refreshPanel();
    }

    public void setText(int n, String string) {
        Cell cell = this.cells[n];
        if (cell != null) {
            cell.setText(string);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    cell.setToolTipText(string.equals(UNLOCKED) ? TOOLTIP_UNLOCKED : TOOLTIP_LOCKED);
                    break;
                }
                default: {
                    cell.setToolTipText("".equals(string) ? null : string);
                }
            }
        }
    }

    private void refreshPanel() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = this.cells.length;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        for (Cell cell : this.cells) {
            boolean bl = this.cells[2] == cell;
            gridBagConstraints.fill = bl ? 2 : 0;
            gridBagConstraints.weightx = bl ? 1.0 : 0.0;
            this.add((Component)cell, gridBagConstraints);
        }
        this.updateCellBorders();
    }

    private void updateCellBorders() {
        int n = this.cells.length;
        Border border = (Border)UIManager.get("Nb.Editor.Status.innerBorder");
        Border border2 = (Border)UIManager.get("Nb.Editor.Status.leftBorder");
        Border border3 = (Border)UIManager.get("Nb.Editor.Status.rightBorder");
        Border border4 = (Border)UIManager.get("Nb.Editor.Status.onlyOneBorder");
        if (n == 0 || border == null || border2 == null || border3 == null || border4 == null) {
            return;
        }
        if (n == 1) {
            this.cells[0].setBorder(border4);
            return;
        }
        this.cells[0].setBorder(border2);
        for (int i = 1; i < n - 1; ++i) {
            this.cells[i].setBorder(border);
        }
        this.cells[n - 1].setBorder(border3);
    }

    private static class Cell
    extends JLabel {
        private final Dimension maxDimension = new Dimension();
        private final String[] widestStrings;
        private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
        static final Border CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))), BorderFactory.createEmptyBorder(0, 2, 0, 2));

        Cell(String[] stringArray) {
            this.setBorder(CELL_BORDER);
            this.setOpaque(true);
            this.widestStrings = stringArray;
            this.setForeground((Color)UIManager.get("Label.foreground"));
            this.setBackground((Color)UIManager.get("Label.background"));
            this.updateSize();
        }

        private void updateSize() {
            Font font = this.getFont();
            if (font != null) {
                Border border = this.getBorder();
                Insets insets = border != null ? border.getBorderInsets(this) : NULL_INSETS;
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.stringWidth(this.getText());
                this.maxDimension.height = fontMetrics.getHeight() + insets.top + insets.bottom;
                if (this.widestStrings != null) {
                    for (int i = 0; i < this.widestStrings.length; ++i) {
                        String string = this.widestStrings[i];
                        if (string == null) continue;
                        n = Math.max(n, fontMetrics.stringWidth(string));
                    }
                }
                this.maxDimension.width = n + insets.left + insets.right;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.maxDimension);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.maxDimension);
        }
    }
}

