/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.ImportPaletteFolderPanel;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteFactory;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemData;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class ImportPaletteFolderAction
extends SystemAction {
    private static final String ACTION_ID = "svg_palette_import";
    private final String m_name = AbstractSVGAction.getMessage("LBL_svg_palette_import");

    public ImportPaletteFolderAction() {
        String string = AbstractSVGAction.getMessage("HINT_svg_palette_import");
        this.putValue("ShortDescription", string);
    }

    public String getName() {
        return this.m_name;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ImportPaletteFolderPanel importPaletteFolderPanel = new ImportPaletteFolderPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)importPaletteFolderPanel, NbBundle.getMessage(SVGPaletteFactory.class, (String)"TITLE_ImportPaletteFolder"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            final File file = importPaletteFolderPanel.getFolder();
            if (file.exists() && file.isDirectory()) {
                SceneManager.log(Level.INFO, "Importing palette folder " + file.getPath());
                String string = importPaletteFolderPanel.getDisplayName();
                try {
                    DataFolder dataFolder = (DataFolder)SVGPaletteFactory.getPalette().getRoot().lookup(DataFolder.class);
                    FileObject fileObject = dataFolder.getPrimaryFile();
                    final String string2 = ImportPaletteFolderAction.convertCategoryToFolderName(fileObject, string);
                    final FileObject fileObject2 = fileObject.createFolder(string2);
                    if (!string2.equals(string)) {
                        fileObject2.setAttribute("categoryName", (Object)string);
                    }
                    fileObject2.setAttribute("isExpanded", (Object)"true");
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            for (File file2 : file.listFiles()) {
                                if (!file2.isFile() || !SVGDataObject.isSVGFile(file2)) continue;
                                SceneManager.log(Level.FINE, "Creating palette item for " + file2.getPath());
                                OutputStream outputStream = null;
                                FileLock fileLock = null;
                                try {
                                    String string = file2.getName();
                                    String string22 = string.replace('.', '_') + ".svgPaletteItem";
                                    SVGPaletteItemData sVGPaletteItemData = new SVGPaletteItemData(string, string2, file2.getCanonicalPath());
                                    SVGPaletteItemData.set(fileObject2.getPath() + "/" + string22, sVGPaletteItemData);
                                    FileObject fileObject = fileObject2.createData(string22);
                                    fileLock = fileObject.lock();
                                    outputStream = fileObject.getOutputStream(fileLock);
                                    sVGPaletteItemData.serialize(outputStream);
                                    SceneManager.log(Level.FINE, "Palette item created.");
                                }
                                catch (Exception exception) {
                                    SceneManager.error("Palette item creation failed.", exception);
                                }
                                finally {
                                    if (outputStream != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            SceneManager.error("Couldn not close stream.", iOException);
                                        }
                                    }
                                    if (fileLock != null) {
                                        fileLock.releaseLock();
                                    }
                                }
                            }
                            SceneManager.log(Level.INFO, "Palette folder imported.");
                        }
                    };
                    thread.setPriority(1);
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (IOException iOException) {
                    SceneManager.error("Palette folder creation failed.", iOException);
                }
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportPaletteFolderAction.class, (String)"ERROR_NotDirectory", (Object)file), 2));
            }
        }
    }

    protected static String convertCategoryToFolderName(FileObject fileObject, String string) {
        int n;
        if (string == null || "".equals(string)) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            stringBuffer.append(c);
            n = 1;
        } else {
            stringBuffer.append('_');
            n = 0;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        if ("_".equals(string2)) {
            string2 = "Category";
        }
        String string3 = null;
        boolean bl = false;
        n = 0;
        while (!bl) {
            String string4 = string3 = n > 0 ? string2 + "_" + n : string2;
            if (Utilities.isWindows()) {
                bl = true;
                Enumeration enumeration = fileObject.getChildren(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    String string5 = fileObject2.getName();
                    String string6 = fileObject2.getExt();
                    if (string6 != null && !"".equals(string6) || !string5.equalsIgnoreCase(string3)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = fileObject.getFileObject(string3) == null;
            }
            ++n;
        }
        return string3;
    }
}

