/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.WritableRaster;

public final class Quantizer {
    private static final int MAXCOLORS = 255;
    private static final int TRANSPARENT_COLOR = 255;
    private static final int HSIZE = 32768;
    private final int[] m_pixels32;
    private final int m_width;
    private final int m_height;
    private final int[] m_hist;
    private int[] m_histPtr;
    private ColorCube[] m_list;
    private IndexColorModel m_cm;

    public Quantizer(int[] nArray, int n, int n2) {
        this.m_pixels32 = nArray;
        this.m_width = n;
        this.m_height = n2;
        this.m_hist = new int[32768];
        for (int i = 0; i < n * n2; ++i) {
            int n3 = this.rgb(this.m_pixels32[i]);
            this.m_hist[n3] = this.m_hist[n3] + 1;
        }
    }

    public int getColorCount() {
        int n = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.m_hist[i] <= 0) continue;
            ++n;
        }
        return n;
    }

    public Color getModalColor() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.m_hist[i] <= n) continue;
            n = this.m_hist[i];
            n2 = i;
        }
        return new Color(this.red(n2), this.green(n2), this.blue(n2));
    }

    public BufferedImage toImage() {
        int n;
        int n2 = 0;
        this.m_list = new ColorCube[255];
        this.m_histPtr = new int[32768];
        int n3 = 0;
        ColorCube colorCube = new ColorCube();
        int n4 = 0;
        for (n = 0; n <= Short.MAX_VALUE; ++n) {
            if (this.m_hist[n] == 0) continue;
            this.m_histPtr[n4++] = n;
            colorCube.count = colorCube.count + this.m_hist[n];
        }
        colorCube.lower = 0;
        colorCube.upper = n4 - 1;
        colorCube.level = 0;
        this.reduce(colorCube);
        this.m_list[n3++] = colorCube;
        while (n3 < 255) {
            int n5 = 255;
            int n6 = -1;
            for (int i = 0; i <= n3 - 1; ++i) {
                if (this.m_list[i].lower == this.m_list[i].upper || this.m_list[i].level >= n5) continue;
                n5 = this.m_list[i].level;
                n6 = i;
            }
            if (n6 == -1) break;
            colorCube = this.m_list[n6];
            int n7 = colorCube.rmax - colorCube.rmin;
            int n8 = colorCube.gmax - colorCube.gmin;
            int n9 = colorCube.bmax - colorCube.bmin;
            if (n7 >= n8 && n7 >= n9) {
                n2 = 0;
            }
            if (n8 >= n7 && n8 >= n9) {
                n2 = 1;
            }
            if (n9 >= n7 && n9 >= n8) {
                n2 = 2;
            }
            this.changeColorOrder(this.m_histPtr, colorCube.lower, colorCube.upper, n2);
            this.quickSort(this.m_histPtr, colorCube.lower, colorCube.upper);
            this.resetColorOrder(this.m_histPtr, colorCube.lower, colorCube.upper, n2);
            int n10 = 0;
            for (n = colorCube.lower; n <= colorCube.upper - 1 && n10 < colorCube.count / 2; n10 += this.m_hist[n4], ++n) {
                n4 = this.m_histPtr[n];
            }
            int n11 = n;
            ColorCube colorCube2 = new ColorCube();
            colorCube2.lower = colorCube.lower;
            colorCube2.upper = n11 - 1;
            colorCube2.count = n10;
            colorCube2.level = colorCube.level + 1;
            this.reduce(colorCube2);
            this.m_list[n6] = colorCube2;
            ColorCube colorCube3 = new ColorCube();
            colorCube3.lower = n11;
            colorCube3.upper = colorCube.upper;
            colorCube3.count = colorCube.count - n10;
            colorCube3.level = colorCube.level + 1;
            this.reduce(colorCube3);
            this.m_list[n3++] = colorCube3;
        }
        this.invertMap(this.m_hist, n3);
        return this.makeBufferedImage();
    }

    private void reduce(ColorCube colorCube) {
        int n = 255;
        int n2 = 0;
        int n3 = 255;
        int n4 = 0;
        int n5 = 255;
        int n6 = 0;
        for (int i = colorCube.lower; i <= colorCube.upper; ++i) {
            int n7 = this.m_histPtr[i];
            int n8 = this.red(n7);
            int n9 = this.green(n7);
            int n10 = this.blue(n7);
            if (n8 > n2) {
                n2 = n8;
            }
            if (n8 < n) {
                n = n8;
            }
            if (n9 > n4) {
                n4 = n9;
            }
            if (n9 < n3) {
                n3 = n9;
            }
            if (n10 > n6) {
                n6 = n10;
            }
            if (n10 >= n5) continue;
            n5 = n10;
        }
        colorCube.rmin = n;
        colorCube.rmax = n2;
        colorCube.gmin = n3;
        colorCube.gmax = n4;
        colorCube.gmin = n3;
        colorCube.gmax = n4;
    }

    private void invertMap(int[] nArray, int n) {
        int n2;
        int n3;
        ColorCube colorCube;
        int n4;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (n4 = 0; n4 <= n - 1; ++n4) {
            int n5;
            int n6;
            int n7;
            colorCube = this.m_list[n4];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (n3 = colorCube.lower; n3 <= colorCube.upper; ++n3) {
                n2 = this.m_histPtr[n3];
                n7 = this.red(n2);
                f3 += (float)n7 * (float)nArray[n2];
                n6 = this.green(n2);
                f2 += (float)n6 * (float)nArray[n2];
                n5 = this.blue(n2);
                f += (float)n5 * (float)nArray[n2];
            }
            n7 = (int)(f3 / (float)colorCube.count);
            n6 = (int)(f2 / (float)colorCube.count);
            n5 = (int)(f / (float)colorCube.count);
            if (n7 == 248 && n6 == 248 && n5 == 248) {
                n5 = 255;
                n6 = 255;
                n7 = 255;
            }
            byArray[n4] = (byte)n7;
            byArray2[n4] = (byte)n6;
            byArray3[n4] = (byte)n5;
        }
        this.m_cm = new IndexColorModel(8, 256, byArray, byArray2, byArray3, 255);
        for (n4 = 0; n4 <= n - 1; ++n4) {
            colorCube = this.m_list[n4];
            for (n3 = colorCube.lower; n3 <= colorCube.upper; ++n3) {
                n2 = this.m_histPtr[n3];
                nArray[n2] = n4;
            }
        }
    }

    private void changeColorOrder(int[] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                for (int i = n; i <= n2; ++i) {
                    int n4 = nArray[i];
                    int n5 = n4 & 0x1F;
                    nArray[i] = n5 << 10 | n4 >> 5;
                }
                break;
            }
            case 1: {
                for (int i = n; i <= n2; ++i) {
                    int n6 = nArray[i];
                    int n7 = n6 & 0x1F;
                    int n8 = n6 >> 5 & 0x1F;
                    int n9 = n6 >> 10;
                    nArray[i] = n8 << 10 | n9 << 5 | n7;
                }
                break;
            }
        }
    }

    void resetColorOrder(int[] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                for (int i = n; i <= n2; ++i) {
                    int n4 = nArray[i];
                    int n5 = n4 >> 10;
                    nArray[i] = (n4 & 0x3FF) << 5 | n5;
                }
                break;
            }
            case 1: {
                for (int i = n; i <= n2; ++i) {
                    int n6 = nArray[i];
                    int n7 = n6 & 0x1F;
                    int n8 = n6 >> 10;
                    int n9 = n6 >> 5 & 0x1F;
                    nArray[i] = n9 << 10 | n8 << 5 | n7;
                }
                break;
            }
        }
    }

    void quickSort(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = nArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && nArray[n3] < n5) {
                    ++n3;
                }
                while (n4 > n && nArray[n4] > n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(nArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(nArray, n3, n2);
            }
        }
    }

    byte[] toByteArray() {
        byte[] byArray = new byte[this.m_width * this.m_height];
        for (int i = 0; i < this.m_width * this.m_height; ++i) {
            int n = this.rgb(this.m_pixels32[i]);
            byArray[i] = (byte)this.m_hist[n];
        }
        return byArray;
    }

    BufferedImage makeBufferedImage() {
        byte[] byArray = this.toByteArray();
        BufferedImage bufferedImage = new BufferedImage(this.m_cm, this.m_cm.createCompatibleWritableRaster(this.m_width, this.m_height), false, null);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[1];
        int n = 0;
        for (int i = 0; i < this.m_width; ++i) {
            for (int j = 0; j < this.m_height; ++j) {
                int n2 = this.m_pixels32[n];
                if (n2 >>> 24 > 127) {
                    nArray[0] = byArray[n++];
                } else {
                    nArray[0] = 255;
                    ++n;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    Image makeImage() {
        byte[] byArray = this.toByteArray();
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.m_width, this.m_height, (ColorModel)this.m_cm, byArray, 0, this.m_width));
        return image;
    }

    private final int rgb(int n) {
        int n2 = (n & 0xF80000) >> 19;
        int n3 = (n & 0xF800) >> 6;
        int n4 = (n & 0xF8) << 7;
        return n4 | n3 | n2;
    }

    private final int red(int n) {
        return (n & 0x1F) << 3;
    }

    private final int green(int n) {
        return n >> 2 & 0xF8;
    }

    private final int blue(int n) {
        return n >> 7 & 0xF8;
    }

    private static final class ColorCube {
        private int lower;
        private int upper;
        private int count = 0;
        private int level;
        private int rmin;
        private int rmax;
        private int gmin;
        private int gmax;
        private int bmin;
        private int bmax;

        ColorCube() {
        }
    }
}

