/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.awt.SVGAnimatorImpl;
import com.sun.perseus.builder.ModelBuilder;
import com.sun.perseus.j2d.Point;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractAnimate;
import com.sun.perseus.model.CompositeGraphicsNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SVG;
import com.sun.perseus.model.SVGImageImpl;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.UpdateAdapter;
import com.sun.perseus.model.UpdateListener;
import java.awt.AWTEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.microedition.m2g.ExternalResourceHandler;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedAnimationElement;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedElement;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedGroup;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedTransformableElement;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.SVGComposerPrototypeFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerseusController {
    public static final int ANIMATION_NOT_AVAILABLE = 0;
    public static final int ANIMATION_NOT_RUNNING = 1;
    public static final int ANIMATION_RUNNING = 2;
    public static final int ANIMATION_PAUSED = 3;
    public static final float ANIMATION_DEFAULT_DURATION = 30.0f;
    public static final float ANIMATION_DEFAULT_STEP = 0.1f;
    public static final String ID_VIEWBOX_MARKER = "$VIEWBOX$";
    public static final String ID_BBOX_MARKER = "$BBOX$";
    private static final String[] ANIM_PATTERNS = new String[]{".DOMFocusIn", ".DOMFocusOut.DOMActivate"};
    private static final SVGMatrix IDENTITY_TRANSFORM = new Transform(null);
    private static int s_instanceCounter = 0;
    protected final SceneManager m_sceneMgr;
    protected final String m_id;
    protected SVGAnimatorImpl m_animator;
    protected SVGImage m_svgImage;
    protected DocumentNode m_svgDoc;
    protected SVGLocatableElement m_viewBoxMarker;
    protected int m_animationState = 0;
    protected float m_currentTime = 0.0f;

    PerseusController(SceneManager sceneManager) {
        this.m_sceneMgr = sceneManager;
        this.m_id = "PC-" + s_instanceCounter++ + "-" + sceneManager;
    }

    void initialize() {
        this.m_svgImage = this.m_sceneMgr.getSVGImage();
        this.m_svgDoc = (DocumentNode)this.m_svgImage.getDocument();
        this.m_animator = (SVGAnimatorImpl)SVGAnimator.createAnimator((SVGImage)this.m_svgImage, (String)"javax.swing.JComponent");
        this.m_animationState = this.containsAnimation((ModelNode)this.m_svgDoc) ? 1 : 0;
        SVGSVGElement sVGSVGElement = this.getSVGRootElement();
        SVGRect sVGRect = sVGSVGElement.getRectTrait("viewBox");
        if (sVGRect != null) {
            this.m_viewBoxMarker = (SVGLocatableElement)this.m_svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
            this.m_viewBoxMarker.setId(ID_VIEWBOX_MARKER);
            this.m_viewBoxMarker.setTrait("fill", "none");
            this.m_viewBoxMarker.setTrait("stroke", "none");
            this.m_viewBoxMarker.setFloatTrait("x", sVGRect.getX());
            this.m_viewBoxMarker.setFloatTrait("y", sVGRect.getY());
            this.m_viewBoxMarker.setFloatTrait("width", sVGRect.getWidth());
            this.m_viewBoxMarker.setFloatTrait("height", sVGRect.getHeight());
            sVGSVGElement.appendChild((Node)this.m_viewBoxMarker);
        } else {
            this.m_viewBoxMarker = null;
        }
        this.m_animator.play();
        this.m_animator.pause();
        SceneManager.log(Level.INFO, this.toString() + " initialized.");
    }

    public SVGPoint convertCoords(float f, float f2) {
        SVGMatrix sVGMatrix = this.getSVGRootElement().getScreenCTM().inverse();
        return new Point(sVGMatrix.getComponent(0) * f + sVGMatrix.getComponent(2) * f2 + sVGMatrix.getComponent(4), sVGMatrix.getComponent(1) * f + sVGMatrix.getComponent(3) * f2 + sVGMatrix.getComponent(5));
    }

    public SVGLocatableElement getViewBoxMarker() {
        return this.m_viewBoxMarker;
    }

    public boolean isImgHorizontallyOriented() {
        SVGSVGElement sVGSVGElement = this.getSVGRootElement();
        SVGRect sVGRect = sVGSVGElement.getRectTrait("viewBox");
        if (sVGRect != null) {
            return sVGRect.getWidth() > sVGRect.getHeight();
        }
        return false;
    }

    public JComponent getAnimatorGUI() {
        return (JComponent)this.m_animator.getTargetComponent();
    }

    public void execute(Runnable runnable) {
        try {
            this.m_animator.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            SceneManager.error("Command execution failed.", exception);
        }
    }

    public DocumentNode getSVGDocument() {
        return this.m_svgDoc;
    }

    public SVGSVGElement getSVGRootElement() {
        return (SVGSVGElement)this.m_svgDoc.getDocumentElement();
    }

    public SVGObject getObjectById(String string) {
        SVGElement sVGElement = this.getElementById(string);
        SVGObject sVGObject = this.getObjectForSVGElement(sVGElement);
        if (sVGObject != null) {
            return sVGObject;
        }
        SceneManager.log(Level.INFO, "No object found for id " + string + "(" + this.toString() + ")");
        return null;
    }

    public SVGObject getObjectForSVGElement(SVGElement sVGElement) {
        SVGLocatableElement sVGLocatableElement;
        if (sVGElement != null && sVGElement instanceof SVGLocatableElement && PerseusController.getSafeScreenBBox(sVGLocatableElement = (SVGLocatableElement)sVGElement) != null) {
            return this.getSVGObject(sVGLocatableElement);
        }
        return null;
    }

    public SVGElement getElementById(String string) {
        SVGElement sVGElement = PerseusController.getElementById((ModelNode)this.getSVGRootElement(), string);
        return sVGElement;
    }

    public SVGObject[] getObjectsAt(int n, int n2) {
        SVGLocatableElement sVGLocatableElement = this.findElementAt(n, n2);
        if (sVGLocatableElement != null) {
            SVGObject sVGObject;
            for (Object object = sVGLocatableElement; object != null; object = object.getParentNode()) {
                if (!PatchedGroup.isWrapper((Node)object)) continue;
                sVGLocatableElement = object;
                break;
            }
            if ((sVGObject = this.getSVGObject(sVGLocatableElement)) != null) {
                return new SVGObject[]{sVGObject};
            }
        }
        return null;
    }

    public void delete(final SVGElement sVGElement) {
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Node node = sVGElement.getParentNode();
                PerseusController.setNullIds(sVGElement, true);
                try {
                    node.removeChild((Node)sVGElement);
                }
                finally {
                    PerseusController.setNullIds(sVGElement, false);
                }
            }
        });
    }

    public void moveToBottom(final SVGLocatableElement sVGLocatableElement) {
        final Node node = sVGLocatableElement.getParentNode();
        final ModelNode modelNode = ((ModelNode)node).getFirstChildNode();
        if (modelNode != sVGLocatableElement) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PerseusController.setNullIds((SVGElement)sVGLocatableElement, true);
                    try {
                        node.removeChild((Node)sVGLocatableElement);
                        node.insertBefore((Node)sVGLocatableElement, (Node)modelNode);
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)sVGLocatableElement, false);
                    }
                }
            });
        }
    }

    public void moveToTop(final SVGLocatableElement sVGLocatableElement) {
        final Node node = sVGLocatableElement.getParentNode();
        ModelNode modelNode = ((ModelNode)node).getLastChildNode();
        if (modelNode != sVGLocatableElement) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PerseusController.setNullIds((SVGElement)sVGLocatableElement, true);
                    try {
                        node.removeChild((Node)sVGLocatableElement);
                        node.appendChild((Node)sVGLocatableElement);
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)sVGLocatableElement, false);
                    }
                }
            });
        }
    }

    public void moveBackward(final SVGLocatableElement sVGLocatableElement) {
        final Node node = sVGLocatableElement.getParentNode();
        ModelNode modelNode = ((ModelNode)node).getFirstChildNode();
        if (modelNode != sVGLocatableElement) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PerseusController.setNullIds((SVGElement)sVGLocatableElement, true);
                    try {
                        ModelNode modelNode = ((ModelNode)sVGLocatableElement).getPreviousSiblingNode();
                        assert (modelNode != null);
                        node.removeChild((Node)sVGLocatableElement);
                        node.insertBefore((Node)sVGLocatableElement, (Node)modelNode);
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)sVGLocatableElement, false);
                    }
                }
            });
        }
    }

    public void moveForward(final SVGLocatableElement sVGLocatableElement) {
        final Node node = sVGLocatableElement.getParentNode();
        final ModelNode modelNode = ((ModelNode)node).getLastChildNode();
        if (modelNode != sVGLocatableElement) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PerseusController.setNullIds((SVGElement)sVGLocatableElement, true);
                    try {
                        ModelNode modelNode2 = ((ModelNode)sVGLocatableElement).getNextSiblingNode();
                        assert (modelNode2 != null);
                        node.removeChild((Node)sVGLocatableElement);
                        if (modelNode2 == modelNode) {
                            node.appendChild((Node)sVGLocatableElement);
                        } else {
                            node.insertBefore((Node)sVGLocatableElement, (Node)modelNode2.getNextSiblingNode());
                        }
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)sVGLocatableElement, false);
                    }
                }
            });
        }
    }

    public SVGLocatableElement findElementAt(int n, int n2) {
        float[] fArray = new float[]{n, n2};
        ModelNode modelNode = this.m_svgDoc.nodeHitAt(fArray);
        SVGLocatableElement sVGLocatableElement = null;
        if (modelNode != null) {
            while (sVGLocatableElement == null && modelNode != null) {
                if (modelNode instanceof SVGLocatableElement) {
                    sVGLocatableElement = (SVGLocatableElement)modelNode;
                    continue;
                }
                modelNode = modelNode.getParent();
            }
        }
        return sVGLocatableElement;
    }

    public static SVGElement hideAllButSubtree(ModelNode modelNode, String string) {
        SVGElement sVGElement;
        SVGElement sVGElement2;
        if (modelNode instanceof SVGElement && string.equals((sVGElement2 = (SVGElement)modelNode).getId())) {
            return sVGElement2;
        }
        SVGElement sVGElement3 = null;
        for (sVGElement2 = modelNode.getFirstChildNode(); sVGElement2 != null; sVGElement2 = sVGElement2.getNextSiblingNode()) {
            sVGElement = PerseusController.hideAllButSubtree((ModelNode)sVGElement2, string);
            if (sVGElement == null) continue;
            sVGElement3 = sVGElement;
        }
        if (modelNode instanceof CompositeGraphicsNode) {
            sVGElement = (CompositeGraphicsNode)modelNode;
            if (sVGElement3 == null) {
                sVGElement.setVisibility(false);
                sVGElement.setTrait("visibility", "hidden");
            }
        }
        return sVGElement3;
    }

    public static SVGElement findElementById(SVGSVGElement sVGSVGElement, String string) {
        SVGElement sVGElement = PerseusController.getElementById((ModelNode)sVGSVGElement, string);
        return sVGElement;
    }

    protected static SVGElement getElementById(ModelNode modelNode, String string) {
        SVGElement sVGElement;
        if (modelNode instanceof SVGElement && string.equals((sVGElement = (SVGElement)modelNode).getId())) {
            return sVGElement;
        }
        for (sVGElement = modelNode.getFirstChildNode(); sVGElement != null; sVGElement = sVGElement.getNextSiblingNode()) {
            SVGElement sVGElement2 = PerseusController.getElementById((ModelNode)sVGElement, string);
            if (sVGElement2 == null) continue;
            return sVGElement2;
        }
        return null;
    }

    public int getAnimatorState() {
        return this.m_animationState;
    }

    public boolean isAnimatorStarted() {
        return this.m_animationState == 2 || this.m_animationState == 3;
    }

    public void startAnimator() {
        if (this.m_animationState == 1 || this.m_animationState == 3) {
            if (this.m_animator.getState() != 2) {
                this.m_animator.play();
                this.m_sceneMgr.processEvent(new AWTEvent(this, 2533){});
            }
            this.m_animationState = 2;
            this.m_sceneMgr.getScreenManager().repaint();
        }
    }

    public void getFocusableTargets(List<String> list) {
        SVGSVGElement sVGSVGElement = this.getSVGRootElement();
        HashSet<String> hashSet = new HashSet<String>();
        this.collectFocusableElements((SVGElement)sVGSVGElement, hashSet);
        this.orderFocusableElements((SVGElement)sVGSVGElement, hashSet, list);
        list.add(0, null);
    }

    public void pauseAnimator() {
        if (this.m_animationState == 2) {
            if (this.m_animator.getState() == 2) {
                this.m_animator.pause();
            }
            this.m_animationState = 3;
        }
    }

    public void stopAnimator() {
        if (this.m_animationState == 2 || this.m_animationState == 3) {
            this.m_animator.stop();
            this.m_animator.play();
            this.m_animator.pause();
            this.setAnimatorTime(0.0f);
            this.m_animationState = 1;
            this.m_sceneMgr.processEvent(new AWTEvent(this, 2534){});
            this.m_sceneMgr.getScreenManager().repaint();
        }
    }

    public float getAnimatorTime() {
        try {
            if (this.m_animator.getState() != 1) {
                this.m_animator.invokeAndWait(new Runnable(){

                    public void run() {
                        PerseusController.this.m_currentTime = PerseusController.this.getSVGRootElement().getCurrentTime();
                        PerseusController.this.m_sceneMgr.updateAnimationDuration(PerseusController.this.m_currentTime);
                    }
                });
            } else {
                this.m_currentTime = 0.0f;
            }
        }
        catch (InterruptedException interruptedException) {
            SceneManager.error(this.toString() + " - Wait interrupted.", interruptedException);
        }
        return this.m_currentTime;
    }

    public void setAnimatorTime(float f) {
        if (this.m_animator != null) {
            this.m_currentTime = f;
            this.m_sceneMgr.updateAnimationDuration(this.m_currentTime);
            if (this.m_animator.getState() != 1) {
                this.m_animator.invokeLater(new Runnable(){

                    public void run() {
                        PerseusController.this.getSVGRootElement().setCurrentTime(PerseusController.this.m_currentTime);
                    }
                });
            } else {
                SceneManager.log(Level.SEVERE, this.toString() + " - Animator is stopped.");
            }
        }
    }

    public void startAnimation(String string) {
        SVGElement sVGElement = this.getElementById(string);
        if (sVGElement != null && sVGElement instanceof SVGAnimationElement) {
            ((SVGAnimationElement)sVGElement).beginElementAt(0.0f);
        } else {
            SceneManager.log(Level.SEVERE, this.toString() + " - Animation element not found: " + string);
        }
    }

    public void stopAnimation(String string) {
        SVGElement sVGElement = this.getElementById(string);
        if (sVGElement != null && sVGElement instanceof SVGAnimationElement) {
            ((SVGAnimationElement)sVGElement).endElementAt(0.0f);
        } else {
            SceneManager.log(Level.SEVERE, this.toString() + " - Animation element not found: " + string);
        }
    }

    public String toString() {
        return this.m_id;
    }

    private synchronized SVGObject getSVGObject(SVGLocatableElement sVGLocatableElement) {
        assert (sVGLocatableElement != null) : "Element must not be null";
        if (sVGLocatableElement instanceof PatchedElement) {
            PatchedElement patchedElement = (PatchedElement)sVGLocatableElement;
            SVGObject sVGObject = patchedElement.getSVGObject();
            if (sVGObject == null) {
                sVGObject = new SVGObject(this.m_sceneMgr, sVGLocatableElement);
                patchedElement.attachSVGObject(sVGObject);
            }
            return sVGObject;
        }
        SceneManager.log(Level.SEVERE, this.toString() + " - PatchedElement must be used instead of " + sVGLocatableElement.getClass().getName());
        return null;
    }

    public static ModelNode getRootElement(ModelNode modelNode) {
        ModelNode modelNode2;
        while ((modelNode2 = modelNode.getParent()) != null) {
            modelNode = modelNode2;
        }
        return modelNode;
    }

    public static SVGImage createImage(InputStream inputStream) throws IOException, InterruptedException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        SVGImage sVGImage = PerseusController.loadDocument(inputStream, null);
        DocumentNode documentNode = (DocumentNode)sVGImage.getDocument();
        Element element = documentNode.getDocumentElement();
        if (!(element instanceof SVG)) {
            SceneManager.log(Level.SEVERE, "Missing SVG root element");
            throw new IOException("Missing SVG root element");
        }
        SVG sVG = (SVG)element;
        int n = (int)sVG.getWidth();
        int n2 = (int)sVG.getHeight();
        documentNode.setSize(n, n2);
        return sVGImage;
    }

    protected static SVGImage loadDocument(InputStream inputStream, ExternalResourceHandler externalResourceHandler) throws IOException, InterruptedException {
        DocumentNode documentNode = new DocumentNode();
        UpdateAdapter updateAdapter = new UpdateAdapter();
        documentNode.setUpdateListener((UpdateListener)updateAdapter);
        ModelBuilder.loadDocument((InputStream)inputStream, (DocumentNode)documentNode, (Vector)SVGComposerPrototypeFactory.getPrototypes(documentNode));
        if (updateAdapter.hasLoadingFailed()) {
            if (updateAdapter.getLoadingFailedException() != null) {
                String string = updateAdapter.getLoadingFailedException().getMessage();
                if (string != null && string.startsWith("Load Interrupted : ")) {
                    throw new InterruptedException(string);
                }
                throw new IOException(string);
            }
            throw new IOException("Loading of SVG document failed.");
        }
        SVGImageImpl sVGImageImpl = new SVGImageImpl(documentNode, null);
        documentNode.initializeTimingEngine();
        documentNode.sample(new Time(0L));
        return sVGImageImpl;
    }

    protected static int getChildrenCount(ModelNode modelNode) {
        int n = 0;
        for (ModelNode modelNode2 = modelNode.getFirstChildNode(); modelNode2 != null; modelNode2 = modelNode2.getNextSiblingNode()) {
            ++n;
        }
        return n;
    }

    protected static void transferChildren(SVGElement sVGElement, SVGElement sVGElement2) {
        ModelNode modelNode = ((ModelNode)sVGElement2).getFirstChildNode();
        while (modelNode != null) {
            if (modelNode instanceof PatchedElement) {
                PatchedElement patchedElement = (PatchedElement)modelNode;
                modelNode = modelNode.getNextSiblingNode();
                PerseusController.setNullIds((SVGElement)patchedElement, true);
                sVGElement2.removeChild((Node)((Object)patchedElement));
                sVGElement.appendChild((Node)((Object)patchedElement));
                PerseusController.setNullIds((SVGElement)patchedElement, false);
                continue;
            }
            SceneManager.log(Level.SEVERE, "PatchedElement must be used instead of " + modelNode.getClass().getName());
        }
    }

    public static void printTree(ModelNode modelNode, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("    ");
        }
        System.out.println(modelNode.getClass());
        for (ModelNode modelNode2 = modelNode.getFirstChildNode(); modelNode2 != null; modelNode2 = modelNode2.getNextSiblingNode()) {
            PerseusController.printTree(modelNode2, n + 1);
        }
    }

    private void collectFocusableElements(SVGElement sVGElement, Set<String> set) {
        String string;
        if (sVGElement instanceof PatchedAnimationElement) {
            string = sVGElement.getTrait("begin");
            for (String string2 : ANIM_PATTERNS) {
                int n = 0;
                while ((n = string.indexOf(string2, n)) != -1) {
                    int n2;
                    for (n2 = n - 1; n2 >= 0 && PerseusController.isElementIdChar(string.charAt(n2)); --n2) {
                    }
                    String string3 = string.substring(n2 + 1, n);
                    if (this.getElementById(string3) != null) {
                        set.add(string3);
                    }
                    n += string2.length();
                }
            }
        }
        for (string = (SVGElement)sVGElement.getFirstElementChild(); string != null; string = (SVGElement)string.getNextElementSibling()) {
            this.collectFocusableElements((SVGElement)string, set);
        }
    }

    private boolean orderFocusableElements(SVGElement sVGElement, Set<String> set, List<String> list) {
        String string = sVGElement.getId();
        if (string != null && set.remove(string)) {
            list.add(string);
            if (set.isEmpty()) {
                return true;
            }
        }
        for (SVGElement sVGElement2 = (SVGElement)sVGElement.getFirstElementChild(); sVGElement2 != null; sVGElement2 = (SVGElement)sVGElement2.getNextElementSibling()) {
            if (!this.orderFocusableElements(sVGElement2, set, list)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnimation(ModelNode modelNode) {
        if (modelNode instanceof AbstractAnimate) {
            return true;
        }
        for (ModelNode modelNode2 = modelNode.getFirstChildNode(); modelNode2 != null; modelNode2 = modelNode2.getNextSiblingNode()) {
            if (!this.containsAnimation(modelNode2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isElementIdChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '.' || c == '_' || c == '-' || c == ':';
    }

    public static void setNullIds(SVGElement sVGElement, boolean bl) {
        if (sVGElement instanceof PatchedElement) {
            ((PatchedElement)sVGElement).setNullId(bl);
        } else if (sVGElement.getId() != null) {
            SceneManager.log(Level.SEVERE, "PatchedElement must be used instead of " + sVGElement.getClass().getName());
        }
        for (SVGElement sVGElement2 = (SVGElement)sVGElement.getFirstElementChild(); sVGElement2 != null; sVGElement2 = (SVGElement)sVGElement2.getNextElementSibling()) {
            PerseusController.setNullIds(sVGElement2, bl);
        }
    }

    public static boolean isViewBoxMarker(ModelNode modelNode) {
        return modelNode instanceof SVGElement && ID_VIEWBOX_MARKER.equals(((SVGElement)modelNode).getId());
    }

    public static SVGRect getSafeScreenBBox(SVGLocatableElement sVGLocatableElement) {
        SVGRect sVGRect = sVGLocatableElement.getScreenBBox();
        if (sVGRect == null) {
            SceneManager.log(Level.SEVERE, "Null screen BBox for element:" + sVGLocatableElement);
            ModelNode modelNode = ((ModelNode)sVGLocatableElement).getFirstChildNode();
            if (modelNode != null && modelNode instanceof SVGLocatableElement) {
                sVGRect = ((SVGLocatableElement)modelNode).getScreenBBox();
            }
        }
        return sVGRect;
    }

    public static SVGRect getSafeBBox(SVGLocatableElement sVGLocatableElement) {
        SVGRect sVGRect = sVGLocatableElement.getBBox();
        if (sVGRect == null) {
            SceneManager.log(Level.SEVERE, "Null BBox for element:" + sVGLocatableElement);
            ModelNode modelNode = ((ModelNode)sVGLocatableElement).getFirstChildNode();
            while (modelNode != null && sVGRect == null) {
                if (!(modelNode instanceof SVGLocatableElement)) continue;
                sVGRect = PerseusController.calculateMaxBBox(sVGRect, PerseusController.getSafeBBox((SVGLocatableElement)modelNode));
                modelNode = modelNode.getNextSiblingNode();
            }
        }
        return sVGRect;
    }

    public static SVGRect getFullBBox(SVGLocatableElement sVGLocatableElement) {
        SVGRect sVGRect = sVGLocatableElement.getBBox();
        if (sVGRect == null) {
            SceneManager.log(Level.SEVERE, "Null BBox for element:" + sVGLocatableElement);
            ModelNode modelNode = ((ModelNode)sVGLocatableElement).getFirstChildNode();
            while (modelNode != null) {
                if (!(modelNode instanceof SVGLocatableElement)) continue;
                sVGRect = PerseusController.calculateMaxBBox(sVGRect, PerseusController.getFullBBox((SVGLocatableElement)modelNode));
                modelNode = modelNode.getNextSiblingNode();
            }
        }
        return sVGRect;
    }

    private static SVGRect calculateMaxBBox(SVGRect sVGRect, SVGRect sVGRect2) {
        if (sVGRect == null) {
            sVGRect = sVGRect2;
        } else if (sVGRect2 != null) {
            float f = Math.min(sVGRect.getX(), sVGRect2.getX());
            float f2 = Math.min(sVGRect.getY(), sVGRect2.getY());
            float f3 = Math.max(sVGRect.getWidth() + sVGRect.getX(), sVGRect2.getWidth() + sVGRect2.getX());
            float f4 = Math.max(sVGRect.getHeight() + sVGRect.getY(), sVGRect2.getHeight() + sVGRect2.getY());
            sVGRect.setX(f);
            sVGRect.setY(f2);
            sVGRect.setWidth(f3 - f);
            sVGRect.setHeight(f4 - f2);
        }
        return sVGRect;
    }

    protected static Document getOwnerDocument(Node node) {
        Node node2;
        while ((node2 = node.getParentNode()) != null) {
            node = node2;
        }
        return (Document)node;
    }

    public static SVGMatrix getParentTransformation(Node node) {
        Transform transform;
        ArrayList<Transform> arrayList = null;
        while (node != null) {
            if (node instanceof PatchedTransformableElement && (transform = ((PatchedTransformableElement)((Object)node)).getTransform()) != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Transform>();
                }
                arrayList.add(new Transform((SVGMatrix)transform));
            }
            node = node.getParentNode();
        }
        transform = null;
        if (arrayList != null) {
            transform = (SVGMatrix)arrayList.get(0);
            for (int i = 1; i < arrayList.size(); ++i) {
                transform = transform.mMultiply((SVGMatrix)arrayList.get(i));
            }
        }
        return transform;
    }

    public static final boolean isIdentityTransform(SVGMatrix sVGMatrix, boolean bl) {
        int n = bl ? 4 : 6;
        for (int i = 0; i < n; ++i) {
            if (!((double)Math.abs(IDENTITY_TRANSFORM.getComponent(i) - sVGMatrix.getComponent(i)) > 0.001)) continue;
            return false;
        }
        return true;
    }
}

