/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HtmlPaletteUtilities;
import org.netbeans.modules.html.palette.items.TABLECustomizer;
import org.openide.text.ActiveEditorDrop;

public class TABLE
implements ActiveEditorDrop {
    private static final int ROWS_DEFAULT = 2;
    private static final int COLS_DEFAULT = 2;
    private static final int BORDER_DEFAULT = 1;
    private static final int WIDTH_DEFAULT = 0;
    private static final int CSPAC_DEFAULT = 0;
    private static final int CPADD_DEFAULT = 0;
    private int rows = 2;
    private int cols = 2;
    private int border = 1;
    private int width = 0;
    private int cspac = 0;
    private int cpadd = 0;

    public boolean handleTransfer(JTextComponent jTextComponent) {
        TABLECustomizer tABLECustomizer = new TABLECustomizer(this);
        boolean bl = tABLECustomizer.showDialog();
        if (bl) {
            String string = this.createBody();
            try {
                HtmlPaletteUtilities.insert(string, jTextComponent);
            }
            catch (BadLocationException badLocationException) {
                bl = false;
            }
        }
        return bl;
    }

    private String createBody() {
        String string = this.generateTHead();
        String string2 = this.generateTBody();
        String string3 = " border=\"" + this.border + "\"";
        String string4 = "";
        if (this.width != 0) {
            string4 = " width=\"" + this.width + "\"";
        }
        String string5 = "";
        if (this.cspac != 0) {
            string5 = " cellspacing=\"" + this.cspac + "\"";
        }
        String string6 = "";
        if (this.cpadd != 0) {
            string6 = " cellpadding=\"" + this.cpadd + "\"";
        }
        String string7 = "<table" + string3 + string4 + string5 + string6 + ">\n" + "<thead>\n" + string + "</thead>\n" + "<tbody>\n" + string2 + "</tbody>\n" + "</table>\n";
        return string7;
    }

    private String generateTHead() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cols; ++i) {
            stringBuffer.append("<th></th>\n");
        }
        String string = "<tr>\n" + stringBuffer.toString() + "</tr>\n";
        return string;
    }

    private String generateTBody() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows; ++i) {
            stringBuffer.append("<tr>\n");
            for (int j = 0; j < this.cols; ++j) {
                stringBuffer.append("<td></td>\n");
            }
            stringBuffer.append("</tr>\n");
        }
        String string = stringBuffer.toString();
        return string;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setCspac(int n) {
        this.cspac = n;
    }

    public void setCpadd(int n) {
        this.cpadd = n;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getBorder() {
        return this.border;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCspac() {
        return this.cspac;
    }

    public int getCpadd() {
        return this.cpadd;
    }
}

