/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogEntryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogModel;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogModelFactory;
import org.netbeans.modules.xml.retriever.catalog.model.NextCatalog;
import org.netbeans.modules.xml.retriever.catalog.model.System;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAMCatalogWriteModelImpl
extends CatalogModelImpl
implements CatalogWriteModel {
    boolean unitTestSaveStrategy = false;
    private CatalogModel catalogModel;
    private ModelSource modelSource;

    protected XAMCatalogWriteModelImpl(Project project) throws CatalogModelException, IOException {
        super(project);
        this.modelSource = this.createModelSource(this.catalogFileObject);
    }

    protected XAMCatalogWriteModelImpl(FileObject fileObject) throws CatalogModelException, IOException {
        super(fileObject);
        this.modelSource = this.createModelSource(this.catalogFileObject);
    }

    public XAMCatalogWriteModelImpl(File file) throws IOException, CatalogModelException {
        super(file);
        this.unitTestSaveStrategy = true;
        this.modelSource = this.createModelSource(this.catalogFileObject);
    }

    protected ModelSource createModelSource(FileObject fileObject) throws CatalogModelException {
        return Utilities.createModelSource(this.catalogFileObject, true);
    }

    @Override
    public URI searchURI(URI uRI) {
        File file;
        if (uRI == null) {
            return null;
        }
        URI uRI2 = null;
        if (this.catalogFileObject != null && (file = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            try {
                uRI2 = this.resolveUsingApacheCatalog(file, uRI.toString());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (CatalogModelException catalogModelException) {
                return null;
            }
        }
        return uRI2;
    }

    @Override
    public synchronized void addURI(URI uRI, FileObject fileObject) throws IOException {
        URI uRI2 = FileUtil.toFile((FileObject)fileObject).toURI();
        this.addURI(uRI, uRI2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addURI(URI uRI, URI uRI2) throws IOException {
        URI uRI3;
        if (this.catalogFileObject == null) {
            return;
        }
        this.removeURI(uRI);
        URI uRI4 = FileUtil.toFile((FileObject)this.catalogFileObject).toURI();
        String string = Utilities.relativize(uRI4, uRI2);
        try {
            uRI3 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Invalid URI: " + string);
        }
        System system = this.getCatalogModel().getFactory().createSystem();
        this.getCatalogModel().startTransaction();
        try {
            this.getCatalogModel().getRootComponent().addSystem(system);
            system.setSystemIDAttr(uRI);
            system.setURIAttr(uRI3);
        }
        finally {
            this.getCatalogModel().endTransaction();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeURI(URI uRI) throws IOException {
        System system = null;
        this.getCatalogModel().sync();
        for (System system2 : this.getCatalogModel().getRootComponent().getSystems()) {
            if (!system2.getSystemIDAttr().equals(uRI.toString())) continue;
            system = system2;
            break;
        }
        if (system != null) {
            this.getCatalogModel().startTransaction();
            try {
                this.getCatalogModel().getRootComponent().removeSystem(system);
            }
            finally {
                this.getCatalogModel().endTransaction();
            }
            this.save();
        }
    }

    @Override
    public Collection<CatalogEntry> getCatalogEntries() {
        CatalogEntryImpl catalogEntryImpl;
        ArrayList<CatalogEntry> arrayList = new ArrayList<CatalogEntry>();
        if (this.getCatalogModel() == null || this.getCatalogModel().getRootComponent() == null) {
            return arrayList;
        }
        for (System catalogComponent : this.getCatalogModel().getRootComponent().getSystems()) {
            catalogEntryImpl = new CatalogEntryImpl(CatalogElement.system, catalogComponent.getSystemIDAttr(), catalogComponent.getURIAttr());
            arrayList.add(catalogEntryImpl);
        }
        for (NextCatalog nextCatalog : this.getCatalogModel().getRootComponent().getNextCatalogs()) {
            catalogEntryImpl = new CatalogEntryImpl(CatalogElement.nextCatalog, nextCatalog.getCatalogAttr(), null);
            arrayList.add(catalogEntryImpl);
        }
        return arrayList;
    }

    @Override
    public boolean isWellformed() {
        return this.getCatalogModel().getState().equals((Object)Model.State.VALID);
    }

    @Override
    public Model.State getState() {
        return this.getCatalogModel().getState();
    }

    @Override
    public FileObject getCatalogFileObject() {
        return this.catalogFileObject;
    }

    @Override
    public void addPropertychangeListener(PropertyChangeListener propertyChangeListener) {
        this.getCatalogModel().addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getCatalogModel().removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNextCatalog(URI uRI, boolean bl) throws IOException {
        if (this.catalogFileObject == null) {
            return;
        }
        String string = uRI.toString();
        if (uRI.isAbsolute() && bl) {
            string = Utilities.relativize(FileUtil.toFile((FileObject)this.catalogFileObject).toURI(), uRI);
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Invalid URI: " + string);
        }
        try {
            this.removeNextCatalog(uRI);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NextCatalog nextCatalog = this.getCatalogModel().getFactory().createNextCatalog();
        this.getCatalogModel().startTransaction();
        try {
            this.getCatalogModel().getRootComponent().addNextCatalog(nextCatalog);
            nextCatalog.setCatalogAttr(uRI);
        }
        finally {
            this.getCatalogModel().endTransaction();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNextCatalog(URI uRI) throws IOException {
        NextCatalog nextCatalog = null;
        for (NextCatalog nextCatalog2 : this.getCatalogModel().getRootComponent().getNextCatalogs()) {
            if (!nextCatalog2.getCatalogAttr().equals(uRI.toString())) continue;
            nextCatalog = nextCatalog2;
            break;
        }
        if (nextCatalog != null) {
            this.getCatalogModel().startTransaction();
            try {
                this.getCatalogModel().getRootComponent().removeNextCatalog(nextCatalog);
            }
            finally {
                this.getCatalogModel().endTransaction();
            }
            this.save();
        }
    }

    protected void save() {
        FileObject fileObject = (FileObject)this.getCatalogModel().getModelSource().getLookup().lookup(FileObject.class);
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CatalogModel getCatalogModel() {
        return CatalogModelFactory.getInstance().getModel(this.getModelSource());
    }

    public void setCatalogModel(CatalogModel catalogModel) {
        this.catalogModel = catalogModel;
    }

    public ModelSource getModelSource() {
        return this.modelSource;
    }
}

