/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.sun.dd.api.cmp.SunCmpMapping;
import org.netbeans.modules.j2ee.sun.dd.api.cmp.SunCmpMappings;
import org.netbeans.modules.j2ee.sun.persistence.mapping.ejb.DevelopmentConversionHelper;
import org.netbeans.modules.j2ee.sun.persistence.mapping.ejb.DevelopmentNameMapper;
import org.netbeans.modules.j2ee.sun.persistence.mapping.ejb.EJBDevelopmentModel;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

public class EJBDevelopmentInfoHelper
implements EJBInfoHelper {
    private final ResourceBundle bundle = NbBundle.getBundle(EJBDevelopmentInfoHelper.class);
    private static final char UNDERLINE = '_';
    private static final String DBSCHEMA_EXTENSION = "dbschema";
    private EjbJar bundleDescriptor;
    private WeakReference sourceFileMapRef;
    private DevelopmentNameMapper nameMapper;
    private Model model;

    public EJBDevelopmentInfoHelper(SunCmpMappings mappings, SourceFileMap sourceFileMap) {
        this(mappings, sourceFileMap, null, null);
    }

    EJBDevelopmentInfoHelper(SunCmpMappings mappings, SourceFileMap sourceFileMap, DevelopmentNameMapper nameMapper, Model model) {
        this.setSourceFileMap(sourceFileMap);
        this.nameMapper = nameMapper;
        this.model = model;
        this.putSchemasInCache(mappings);
    }

    private EjbJar getBundleDescriptor() {
        if (this.bundleDescriptor == null) {
            try {
                FileObject[] result = this.getSourceFileMap().findSourceFile("ejb-jar.xml");
                if (result == null || result.length <= 0) {
                    throw new IllegalStateException(this.bundle.getString("ERR_EjbJarRequired"));
                }
                this.bundleDescriptor = DDProvider.getDefault().getDDRoot(result[0]);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.bundleDescriptor;
    }

    private FileObject[] getSourceRoots() {
        return this.getSourceFileMap().getSourceRoots();
    }

    public String getEjbJarDisplayName() {
        return this.getBundleDescriptor().getDefaultDisplayName();
    }

    public Collection getAvailableSchemaNames() {
        FileObject[] sourceRoots = this.getSourceRoots();
        ArrayList<String> returnList = new ArrayList<String>();
        int count = sourceRoots != null ? sourceRoots.length : 0;
        for (int i = 0; i < count; ++i) {
            Enumeration allSchemaFiles = this.getAllOfType(sourceRoots[i], DBSCHEMA_EXTENSION);
            while (allSchemaFiles.hasMoreElements()) {
                FileObject next = (FileObject)allSchemaFiles.nextElement();
                returnList.add(this.getSourceFileMap().getDistributionPath(next).getPath());
            }
        }
        return returnList;
    }

    private Enumeration getAllOfType(FileObject from, final String ext) {
        return Enumerations.filter((Enumeration)from.getChildren(true), (Enumerations.Processor)new Enumerations.Processor(){

            public Object process(Object obj, Collection allwaysNull) {
                return ((FileObject)obj).hasExt(ext) ? obj : null;
            }
        });
    }

    public String getSchemaNameToGenerate() {
        return this.getSourceFileMap().getContextName() + '_' + this.getEjbJarDisplayName();
    }

    public SchemaElement getSchema(String schemaName) {
        return SchemaElement.forName((String)schemaName, (Object)this.getSourceRoots());
    }

    public Collection getEjbNames() {
        EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
        Entity[] entityBeans = allBeans.getEntity();
        int count = entityBeans != null ? entityBeans.length : 0;
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Entity ejb = entityBeans[i];
            if (!"Container".equals(ejb.getPersistenceType())) continue;
            returnList.add(ejb.getEjbName());
        }
        return returnList;
    }

    public Collection getFieldsForEjb(String ejbName) {
        return this.getNameMapperInternal().getFieldsForEjb(ejbName);
    }

    public Collection getRelationshipsForEjb(String ejbName) {
        return this.getNameMapperInternal().getRelationshipFieldsForEjb(ejbName);
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public AbstractNameMapper getNameMapper() {
        return this.getNameMapperInternal();
    }

    public AbstractNameMapper createUniqueNameMapper() {
        return new DevelopmentNameMapper(this.getBundleDescriptor());
    }

    private DevelopmentNameMapper getNameMapperInternal() {
        if (this.nameMapper == null) {
            this.nameMapper = new DevelopmentNameMapper(this.getBundleDescriptor());
        }
        return this.nameMapper;
    }

    public ConversionHelper createConversionHelper() {
        return new DevelopmentConversionHelper(this.getNameMapperInternal(), this.getModel());
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = new EJBDevelopmentModel(this.getNameMapperInternal(), this.getClassLoader(), this.getSourceRoots());
        }
        return this.model;
    }

    private void putSchemasInCache(SunCmpMappings mappings) {
        if (mappings != null) {
            SunCmpMapping[] mapping = mappings.getSunCmpMapping();
            int count = mapping != null ? mapping.length : 0;
            for (int i = 0; i < count; ++i) {
                String schemaName = mapping[i].getSchema();
                if (StringHelper.isEmpty((String)schemaName)) continue;
                this.getSchema(schemaName.trim());
            }
        }
    }

    private SourceFileMap getSourceFileMap() {
        SourceFileMap sfm = null;
        if (this.sourceFileMapRef != null) {
            sfm = (SourceFileMap)this.sourceFileMapRef.get();
        }
        return sfm;
    }

    private void setSourceFileMap(SourceFileMap sourceFileMap) {
        this.sourceFileMapRef = new WeakReference<SourceFileMap>(sourceFileMap);
    }
}

