/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.netbeans.modules.servicetag.RegistrationData;

public class NbConnectionSupport {
    private static String NB_REGISTRATION_HOST = "https://inventory.sun.com";
    private static String SANDBOX_TESTING_HOST = "https://connection-tst.sun.com";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.reglib.NbConnectionSupport");

    private NbConnectionSupport() {
    }

    public static URL getRegistrationURL(String string, String string2) {
        String string3 = System.getProperty("nb.registration.host");
        string3 = string3 == null ? NB_REGISTRATION_HOST + "/RegistrationWeb/register" : string3 + "/RegistrationWeb/register";
        if ((string3 = string3.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        String string4 = NbConnectionSupport.rewriteURL(string3, string, string2);
        try {
            return new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            InternalError internalError = new InternalError(malformedURLException.getMessage());
            internalError.initCause(malformedURLException);
            throw internalError;
        }
    }

    public static String getRegistrationQueryHost() {
        String string = System.getProperty("nb.registration.host");
        if (string == null) {
            string = NB_REGISTRATION_HOST;
        }
        if ((string = string.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        return string;
    }

    private static String rewriteURL(String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.trim());
        if (stringBuilder.charAt((n = stringBuilder.length()) - 1) != '/') {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        stringBuilder.append("?");
        stringBuilder.append("product=" + string3);
        stringBuilder.append("&");
        stringBuilder.append("locale=").append(Locale.getDefault().getLanguage());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean postRegistrationData(URL uRL, RegistrationData registrationData) {
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setAllowUserInteraction(false);
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
            httpsURLConnection.connect();
            LOG.log(Level.FINE, "POSTing registration data at " + uRL);
            OutputStream outputStream = httpsURLConnection.getOutputStream();
            try {
                registrationData.storeToXML(outputStream);
                LOG.log(Level.FINE, "Registration data: " + registrationData.toString());
                outputStream.flush();
            }
            finally {
                outputStream.close();
            }
            int n = httpsURLConnection.getResponseCode();
            LOG.log(Level.FINE, "POST return status = " + n);
            NbConnectionSupport.printReturnData(httpsURLConnection, n);
            return n == 200;
        }
        catch (MalformedURLException malformedURLException) {
            InternalError internalError = new InternalError("Error in registering: " + malformedURLException.getMessage());
            internalError.initCause(malformedURLException);
            throw internalError;
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Post registration data failed:", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printReturnData(HttpURLConnection httpURLConnection, int n) throws IOException {
        InputStream inputStream = null;
        inputStream = n < 400 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            bufferedReader.close();
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(String string, String string2) {
        try {
            URL uRL = new URL(string + "/ProductRegistrationService/status/" + string2);
            LOG.log(Level.FINE, "Query URL: " + uRL);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("GET");
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setAllowUserInteraction(false);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.connect();
            int n = httpsURLConnection.getResponseCode();
            LOG.log(Level.FINE, "Response code = " + n);
            if (n == 200) {
                Object object;
                InputStream inputStream = httpsURLConnection.getInputStream();
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    String string3;
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string3 = ((BufferedReader)object).readLine()) != null) {
                        stringBuffer.append(string3);
                    }
                    ((BufferedReader)object).close();
                }
                finally {
                    inputStream.close();
                }
                object = stringBuffer.toString();
                LOG.log(Level.FINE, "Response: " + (String)object);
                return !((String)object).equals("NOT REGISTERED");
            }
            if (n == 404) {
                return true;
            }
            return true;
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Error: " + exception.getMessage(), exception);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered2(String string, String string2) {
        try {
            URL uRL = new URL(string + "/ProductRegistrationService/status/" + string2);
            LOG.log(Level.FINE, "Query URL: " + uRL);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("GET");
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setAllowUserInteraction(false);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.connect();
            int n = httpsURLConnection.getResponseCode();
            LOG.log(Level.FINE, "Response code = " + n);
            if (n == 200) {
                Object object;
                InputStream inputStream = httpsURLConnection.getInputStream();
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    String string3;
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string3 = ((BufferedReader)object).readLine()) != null) {
                        stringBuffer.append(string3);
                    }
                    ((BufferedReader)object).close();
                }
                finally {
                    inputStream.close();
                }
                object = stringBuffer.toString();
                LOG.log(Level.FINE, "Response: " + (String)object);
                return ((String)object).equals("REGISTERED");
            }
            if (n == 404) {
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Error: " + exception.getMessage(), exception);
            return false;
        }
    }
}

