/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.impl.AXIDocumentImpl;
import org.netbeans.modules.xml.axi.impl.AXIModelListener;
import org.netbeans.modules.xml.axi.impl.AXIModelUpdater;
import org.netbeans.modules.xml.axi.impl.OtherAXIModelListener;
import org.netbeans.modules.xml.axi.impl.SchemaModelListener;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AXIModelImpl
extends AXIModel {
    private AXIModelListener propertyListener;
    private SchemaModelListener schemaModelListener;
    private OtherAXIModelListener axiModelListener = new OtherAXIModelListener(this);
    private WeakHashMap<AXIModel, ComponentListener> listenerMap = new WeakHashMap();
    private boolean designPatternMode = false;
    private boolean isAXIDocumentInitialized = false;
    private SchemaGenerator.Pattern schemaDesignPattern;
    private HashMap<String, NamedReferenceable> mapReferenceable = new HashMap();
    private boolean isForceSync = false;

    public AXIModelImpl(ModelSource modelSource) {
        super(modelSource);
        this.propertyListener = new AXIModelListener();
        this.addPropertyChangeListener(this.propertyListener);
        this.schemaModelListener = new SchemaModelListener(this);
        this.getSchemaModel().addPropertyChangeListener((PropertyChangeListener)this.schemaModelListener);
    }

    boolean isAXIDocumentInitialized() {
        return this.isAXIDocumentInitialized;
    }

    void initializeAXIDocument() {
        AXIDocument aXIDocument = this.getRoot();
        Schema schema = (Schema)aXIDocument.getPeer();
        if (schema == null) {
            aXIDocument.setPeer((SchemaComponent)this.getSchemaModel().getSchema());
        }
        Util.updateAXIDocument(aXIDocument);
        this.isAXIDocumentInitialized = true;
        SchemaGenerator.Pattern pattern = null;
        if (pattern != null) {
            this.setSchemaDesignPattern(pattern);
        } else {
            this.setSchemaDesignPattern(SchemaGenerator.DEFAULT_DESIGN_PATTERN);
        }
    }

    public boolean fromSameSchemaModel(SchemaComponent schemaComponent) {
        return this.getSchemaModel() == schemaComponent.getModel();
    }

    public AXIComponent lookupFromOtherModel(SchemaComponent schemaComponent) {
        if (!schemaComponent.isInDocumentModel()) {
            return null;
        }
        AXIModelFactory aXIModelFactory = AXIModelFactory.getDefault();
        AXIModelImpl aXIModelImpl = (AXIModelImpl)aXIModelFactory.getModel(schemaComponent.getModel());
        return aXIModelImpl != null ? aXIModelImpl.lookup(schemaComponent) : null;
    }

    public AXIComponent lookup(SchemaComponent schemaComponent) {
        return ((AXIDocumentImpl)this.getRoot()).findChild(schemaComponent);
    }

    protected boolean needsSync() {
        if (this.isForceSync) {
            return true;
        }
        if (!this.isAXIDocumentInitialized()) {
            return true;
        }
        if (this.designPatternMode || this.isIntransaction()) {
            return false;
        }
        if (this.axiModelListener != null) {
            return this.axiModelListener.needsSync() || this.schemaModelListener.needsSync();
        }
        return this.schemaModelListener.needsSync();
    }

    void disableAutoSync() {
        this.designPatternMode = true;
        super.getAccess().setAutoSync(false);
    }

    void enableAutoSync() {
        this.designPatternMode = false;
        super.getAccess().setAutoSync(true);
    }

    protected void syncStarted() {
        try {
            this.getSchemaModel().sync();
        }
        catch (IOException iOException) {
            this.setState(Model.State.NOT_SYNCED);
        }
    }

    protected void syncCompleted() {
        this.schemaModelListener.syncCompleted();
        if (this.axiModelListener != null) {
            this.axiModelListener.syncCompleted();
        }
        this.propertyListener.clearEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (!this.needsSync()) {
            return;
        }
        try {
            SchemaModel schemaModel = this.getSchemaModel();
            synchronized (schemaModel) {
                super.sync();
            }
        }
        catch (IOException iOException) {
            this.setState(Model.State.NOT_SYNCED);
        }
        finally {
            this.setForceSync(false);
        }
    }

    public synchronized boolean doSync() {
        AXIModelUpdater aXIModelUpdater = new AXIModelUpdater(this);
        return aXIModelUpdater.doSync();
    }

    @Override
    public SchemaGenerator.Pattern getSchemaDesignPattern() {
        return this.schemaDesignPattern;
    }

    @Override
    public void setSchemaDesignPattern(SchemaGenerator.Pattern pattern) {
        this.schemaDesignPattern = pattern;
    }

    public AXIModelListener getPropertyChangeListener() {
        return this.propertyListener;
    }

    public boolean validate() {
        Model.State state = this.getSchemaModel().getState();
        return state == Model.State.VALID;
    }

    @Override
    public List<AXIModel> getReferencedModels() {
        List<AXIModel> list = Collections.emptyList();
        Schema schema = this.getSchemaModel().getSchema();
        if (schema == null) {
            return list;
        }
        Collection collection = schema.getSchemaReferences();
        if (collection == null || collection.size() == 0) {
            return list;
        }
        list = new ArrayList<AXIModel>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                SchemaModelReference schemaModelReference = (SchemaModelReference)iterator.next();
                Schema schema2 = schemaModelReference.resolveReferencedModel().getSchema();
                AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModelReference.resolveReferencedModel());
                list.add(aXIModel);
            }
            catch (CatalogModelException catalogModelException) {}
        }
        return Collections.unmodifiableList(list);
    }

    void buildReferenceableCache() {
        this.listenerMap.clear();
        Schema schema = this.getSchemaModel().getSchema();
        if (schema == null) {
            return;
        }
        this.buildCache(schema);
        Collection collection = schema.getSchemaReferences();
        if (collection == null || collection.size() == 0) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                SchemaModelReference schemaModelReference = (SchemaModelReference)iterator.next();
                Schema schema2 = schemaModelReference.resolveReferencedModel().getSchema();
                this.buildCache(schema2);
                if (!this.getRoot().canVisitChildren()) continue;
                AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModelReference.resolveReferencedModel());
                this.listenToReferencedModel(aXIModel);
            }
            catch (Exception exception) {}
        }
    }

    public void listenToReferencedModel(AXIModel aXIModel) {
        if (this.listenerMap.get((Object)aXIModel) == null) {
            ComponentListener componentListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)((Object)this.axiModelListener), (Object)((Object)aXIModel));
            aXIModel.addComponentListener(componentListener);
            this.listenerMap.put(aXIModel, componentListener);
        }
    }

    private void buildCache(Schema schema) {
        for (SchemaComponent schemaComponent : schema.getChildren()) {
            if (!(schemaComponent instanceof NamedReferenceable)) continue;
            NamedReferenceable namedReferenceable = (NamedReferenceable)schemaComponent;
            this.mapReferenceable.put(schema.getTargetNamespace() + ":" + namedReferenceable.getName(), namedReferenceable);
        }
    }

    public SchemaComponent getReferenceableSchemaComponent(NamedComponentReference namedComponentReference) {
        String string = namedComponentReference.getQName().getNamespaceURI() + ":" + namedComponentReference.getQName().getLocalPart();
        Class clazz = namedComponentReference.getType();
        NamedReferenceable namedReferenceable = this.mapReferenceable.get(string);
        if (namedReferenceable != null && clazz.isAssignableFrom(namedReferenceable.getClass())) {
            return (SchemaComponent)namedReferenceable;
        }
        return (SchemaComponent)namedComponentReference.get();
    }

    public String toString() {
        if (this.getRoot() == null) {
            return null;
        }
        return this.getRoot().getTargetNamespace();
    }

    public void setForceSync(boolean bl) {
        this.isForceSync = bl;
    }

    public AXIComponent findChild(SchemaComponent schemaComponent) {
        AXIDocumentImpl aXIDocumentImpl = (AXIDocumentImpl)this.getRoot();
        return aXIDocumentImpl.findChild(schemaComponent);
    }
}

