/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeNotationDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_NAME = "name";
    public static final String PROP_PUBLIC_ID = "publicId";
    public static final String PROP_SYSTEM_ID = "systemId";
    private String name;
    private String systemId;
    private String publicId;

    public TreeNotationDecl(String string, String string2, String string3) throws InvalidArgumentException {
        this.checkName(string);
        this.name = string;
        this.checkPublicId(string2);
        this.checkSystemId(string3);
        this.checkExternalId(string2, string3);
        this.systemId = string3;
        this.publicId = string2;
    }

    protected TreeNotationDecl(TreeNotationDecl treeNotationDecl) {
        super(treeNotationDecl);
        this.name = treeNotationDecl.name;
        this.publicId = treeNotationDecl.publicId;
        this.systemId = treeNotationDecl.systemId;
    }

    public Object clone() {
        return new TreeNotationDecl(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeNotationDecl treeNotationDecl = (TreeNotationDecl)object;
        if (!Util.equals(this.getName(), treeNotationDecl.getName())) {
            return false;
        }
        if (!Util.equals(this.getSystemId(), treeNotationDecl.getSystemId())) {
            return false;
        }
        return Util.equals(this.getPublicId(), treeNotationDecl.getPublicId());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeNotationDecl treeNotationDecl = (TreeNotationDecl)treeObject;
        this.setNameImpl(treeNotationDecl.getName());
        this.setSystemIdImpl(treeNotationDecl.getSystemId());
        this.setPublicIdImpl(treeNotationDecl.getPublicId());
    }

    public String getName() {
        return this.name;
    }

    private final void setNameImpl(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(PROP_NAME, string2, string);
    }

    public final void setName(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(string);
        this.setNameImpl(string);
    }

    protected final void checkName(String string) throws InvalidArgumentException {
        TreeUtilities.checkNotationDeclName(string);
    }

    public String getPublicId() {
        return this.publicId;
    }

    private final void setPublicIdImpl(String string) {
        String string2 = this.publicId;
        this.publicId = string;
        this.firePropertyChange(PROP_PUBLIC_ID, string2, string);
    }

    public final void setPublicId(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.publicId, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkPublicId(string);
        this.checkExternalId(string, this.systemId);
        this.setPublicIdImpl(string);
    }

    protected final void checkPublicId(String string) throws InvalidArgumentException {
        TreeUtilities.checkNotationDeclPublicId(string);
    }

    public String getSystemId() {
        return this.systemId;
    }

    private final void setSystemIdImpl(String string) {
        String string2 = this.systemId;
        this.systemId = string;
        this.firePropertyChange(PROP_SYSTEM_ID, string2, string);
    }

    public final void setSystemId(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.systemId, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkSystemId(string);
        this.checkExternalId(this.publicId, string);
        this.setSystemIdImpl(string);
    }

    protected final void checkSystemId(String string) throws InvalidArgumentException {
        TreeUtilities.checkNotationDeclSystemId(string);
    }

    protected final void checkExternalId(String string, String string2) throws InvalidArgumentException {
        if (string == null && string2 == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_nulls"), new NullPointerException());
        }
    }
}

