/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractTreeDocument;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;

public class TreeDocumentFragment
extends AbstractTreeDocument
implements TreeDocumentRoot {
    public static final String PROP_VERSION = "version";
    public static final String PROP_ENCODING = "encoding";
    private TreeEventManager eventManager;
    private String version;
    private String encoding;
    static /* synthetic */ Class class$org$netbeans$tax$spec$DocumentFragment$Child;

    public TreeDocumentFragment(String string, String string2) throws InvalidArgumentException {
        this.checkVersion(string);
        this.checkEncoding(string2);
        this.checkHeader(string, string2);
        this.version = string;
        this.encoding = string2;
        this.eventManager = new TreeEventManager();
    }

    public TreeDocumentFragment() throws InvalidArgumentException {
        this(null, null);
    }

    protected TreeDocumentFragment(TreeDocumentFragment treeDocumentFragment, boolean bl) {
        super(treeDocumentFragment, bl);
        this.version = treeDocumentFragment.version;
        this.encoding = treeDocumentFragment.encoding;
        this.eventManager = new TreeEventManager(treeDocumentFragment.eventManager);
    }

    public Object clone(boolean bl) {
        return new TreeDocumentFragment(this, bl);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeDocumentFragment treeDocumentFragment = (TreeDocumentFragment)object;
        if (!Util.equals(this.getVersion(), treeDocumentFragment.getVersion())) {
            return false;
        }
        return Util.equals(this.getEncoding(), treeDocumentFragment.getEncoding());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeDocumentFragment treeDocumentFragment = (TreeDocumentFragment)treeObject;
        try {
            this.setVersionImpl(treeDocumentFragment.getVersion());
            this.setEncodingImpl(treeDocumentFragment.getEncoding());
        }
        catch (Exception exception) {
            throw new CannotMergeException(treeObject, exception);
        }
    }

    public String getVersion() {
        return this.version;
    }

    private final void setVersionImpl(String string) {
        String string2 = this.version;
        this.version = string;
        this.firePropertyChange(PROP_VERSION, string2, string);
    }

    public final void setVersion(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.version, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkVersion(string);
        this.checkHeader(string, this.encoding);
        this.setVersionImpl(string);
    }

    protected final void checkVersion(String string) throws InvalidArgumentException {
        TreeUtilities.checkDocumentFragmentVersion(string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void setEncodingImpl(String string) {
        String string2 = this.encoding;
        this.encoding = string;
        this.firePropertyChange(PROP_ENCODING, string2, string);
    }

    public final void setEncoding(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.encoding, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkEncoding(string);
        this.checkHeader(this.version, string);
        this.setEncodingImpl(string);
    }

    protected final void checkEncoding(String string) throws InvalidArgumentException {
        TreeUtilities.checkDocumentFragmentEncoding(string);
    }

    public final void setHeader(String string, String string2) throws ReadOnlyException, InvalidArgumentException {
        boolean bl;
        boolean bl2 = !Util.equals(this.version, string);
        boolean bl3 = bl = !Util.equals(this.encoding, string2);
        if (!bl2 && !bl) {
            return;
        }
        this.checkReadOnly();
        if (bl2) {
            this.checkVersion(string);
        }
        if (bl) {
            this.checkEncoding(string2);
        }
        this.checkHeader(string, string2);
        if (bl2) {
            this.setVersionImpl(string);
        }
        if (bl) {
            this.setEncodingImpl(string2);
        }
    }

    protected final void checkHeader(String string, String string2) throws InvalidArgumentException {
        if (string != null && string2 == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_document_fragment_header"), new NullPointerException());
        }
    }

    public TreeEventManager getRootEventManager() {
        return this.eventManager;
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected class ChildListContentManager
    extends AbstractTreeDocument.ChildListContentManager {
        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeDocumentFragment.this;
        }

        public void checkAssignableObject(Object object) {
            super.checkAssignableObject(object);
            this.checkAssignableClass(class$org$netbeans$tax$spec$DocumentFragment$Child == null ? (class$org$netbeans$tax$spec$DocumentFragment$Child = TreeDocumentFragment.class$("org.netbeans.tax.spec.DocumentFragment$Child")) : class$org$netbeans$tax$spec$DocumentFragment$Child, object);
        }
    }
}

