/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.utils;

import java.io.File;
import java.util.Collection;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class FileSystemsProvider {
    private static final FileSystemsProvider DEFAULT = new DefaultProvider();

    private static FileSystemsProvider getDefault() {
        return DEFAULT;
    }

    public static String getCaseInsensitivePath(CharSequence charSequence) {
        return FileSystemsProvider.getDefault().getCaseInsensitivePathImpl(charSequence);
    }

    public static Data get(File file) {
        return FileSystemsProvider.getDefault().getImpl(file);
    }

    public static Data get(CharSequence charSequence) {
        return FileSystemsProvider.getDefault().getImpl(charSequence);
    }

    protected abstract Data getImpl(File var1);

    protected abstract Data getImpl(CharSequence var1);

    protected abstract String getCaseInsensitivePathImpl(CharSequence var1);

    private static class DefaultProvider
    extends FileSystemsProvider {
        private FileSystemsProvider[] cache;

        DefaultProvider() {
            Collection collection = Lookup.getDefault().lookupAll(FileSystemsProvider.class);
            this.cache = collection.toArray(new FileSystemsProvider[collection.size()]);
        }

        public Data getImpl(File file) {
            for (FileSystemsProvider fileSystemsProvider : this.cache) {
                Data data = fileSystemsProvider.getImpl(file);
                if (data == null) continue;
                return data;
            }
            return null;
        }

        public Data getImpl(CharSequence charSequence) {
            for (FileSystemsProvider fileSystemsProvider : this.cache) {
                Data data = fileSystemsProvider.getImpl(charSequence);
                if (data == null) continue;
                return data;
            }
            return null;
        }

        public String getCaseInsensitivePathImpl(CharSequence charSequence) {
            for (FileSystemsProvider fileSystemsProvider : this.cache) {
                String string = fileSystemsProvider.getCaseInsensitivePathImpl(charSequence);
                if (string == null) continue;
                return string;
            }
            return ((Object)charSequence).toString();
        }
    }

    public static final class Data {
        public final FileSystem fileSystem;
        public final String path;

        public Data(FileSystem fileSystem, String string) {
            this.fileSystem = fileSystem;
            this.path = string;
        }

        public String toString() {
            return this.fileSystem.getDisplayName() + ":" + this.path;
        }
    }
}

