/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.ui.Icons;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSymbolDescriptor
extends SymbolDescriptor {
    private final String displayName;
    private final ElementHandle<TypeElement> owner;
    private final ElementHandle<?> me;
    private final ElementKind kind;
    private final Set<Modifier> modifiers;
    private final FileObject root;
    private final Project project;
    private FileObject cachedFo;

    public JavaSymbolDescriptor(String string, ElementKind elementKind, Set<Modifier> set, ElementHandle<TypeElement> elementHandle, ElementHandle<?> elementHandle2, Project project, FileObject fileObject) {
        assert (string != null);
        assert (elementKind != null);
        assert (set != null);
        assert (elementHandle != null);
        assert (elementHandle2 != null);
        this.displayName = string;
        this.kind = elementKind;
        this.modifiers = set;
        this.owner = elementHandle;
        this.me = elementHandle2;
        this.root = fileObject;
        this.project = project;
    }

    public Icon getIcon() {
        return Icons.getElementIcon((ElementKind)this.kind, this.modifiers);
    }

    public String getSymbolName() {
        return this.displayName;
    }

    public String getOwnerName() {
        return this.owner.getQualifiedName();
    }

    public FileObject getFileObject() {
        if (this.cachedFo == null) {
            ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.root}));
            this.cachedFo = SourceUtils.getFile(this.owner, (ClasspathInfo)classpathInfo);
        }
        return this.cachedFo;
    }

    public void open() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        ElementOpen.open(compilationController.getClasspathInfo(), (ElementHandle<? extends Element>)JavaSymbolDescriptor.this.me);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public String getProjectName() {
        return this.project == null ? "" : ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public Icon getProjectIcon() {
        return this.project == null ? null : ProjectUtils.getInformation((Project)this.project).getIcon();
    }

    public int getOffset() {
        return -1;
    }
}

