/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class Xsd2Java {
    public static final String JAXB_SCRIPT_PATH = "modules/ext/build-jaxb.xml";
    public static final String PROP_XSD_FILE = "xsd.file";
    public static final String PROP_PACKAGE_NAME = "packageName";
    public static final String PROP_JAXB_BASE = "jaxb.base";
    public static final String PROP_JAXB_JAR = "jaxb.jar";
    public static final String PROP_JAXB_SRC_JAR = "jaxb.src.jar";
    public static final String PROP_USER_BUILD_PROPERTIES = "user.build.properties.file";
    private FileObject xsdFile;
    private String packageName;
    private String jaxbFolder;
    private String jaxbJarPath;
    private String jaxbSourceJarPath;

    public Xsd2Java(FileObject fileObject, String string) {
        this.xsdFile = fileObject;
        this.packageName = string;
        this.jaxbFolder = Xsd2Java.deriveJaxbBase(fileObject);
        this.jaxbJarPath = Xsd2Java.deriveJaxbJarPath(fileObject);
        this.jaxbSourceJarPath = Xsd2Java.deriveJaxbSourceJarPath(fileObject);
    }

    private static String deriveJaxbBase(FileObject fileObject) {
        return fileObject.getName() + "-jaxb";
    }

    private static String deriveJaxbJarPath(FileObject fileObject) {
        return fileObject.getName() + ".jar";
    }

    private static String deriveJaxbSourceJarPath(FileObject fileObject) {
        return fileObject.getName() + "-src.jar";
    }

    public boolean compile() throws IOException {
        if (this.getJaxbJarFile() != null) {
            return true;
        }
        FileObject fileObject = this.getOrCreateJaxbFolder();
        FileObject fileObject2 = SaasServicesModel.getWebServiceHome().getParent().getParent().getFileObject("build.properties");
        File file = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)fileObject));
        File file2 = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.xsdFile));
        File file3 = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)fileObject2));
        Properties properties = new Properties();
        properties.setProperty(PROP_XSD_FILE, file2.getPath());
        properties.setProperty(PROP_PACKAGE_NAME, this.packageName);
        properties.setProperty(PROP_JAXB_BASE, file.getPath());
        properties.setProperty(PROP_JAXB_JAR, this.jaxbJarPath);
        properties.setProperty(PROP_JAXB_SRC_JAR, this.jaxbSourceJarPath);
        properties.setProperty(PROP_USER_BUILD_PROPERTIES, file3.getPath());
        return this.createJaxBJar(properties);
    }

    public boolean recompile() throws IOException {
        FileObject fileObject = this.xsdFile.getParent().getFileObject(this.jaxbFolder);
        if (fileObject != null) {
            fileObject.delete();
        }
        return this.compile();
    }

    public FileObject getJaxbFolder() {
        return this.xsdFile.getParent().getFileObject(this.jaxbFolder);
    }

    public FileObject getOrCreateJaxbFolder() throws IOException {
        FileObject fileObject = this.getJaxbFolder();
        if (fileObject == null) {
            fileObject = this.xsdFile.getParent().createFolder(this.jaxbFolder);
        }
        return fileObject;
    }

    public FileObject getJaxbJarFile() {
        FileObject fileObject = this.getJaxbFolder();
        if (fileObject == null) {
            return null;
        }
        return fileObject.getFileObject(this.jaxbJarPath);
    }

    public FileObject getJaxbSourceJarFile() {
        FileObject fileObject = this.getJaxbFolder();
        if (fileObject == null) {
            return null;
        }
        return fileObject.getFileObject(this.jaxbSourceJarPath);
    }

    private boolean createJaxBJar(Properties properties) {
        try {
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{"xjc-jar"}, (Properties)properties);
            executorTask.waitFinished();
            return executorTask.result() == 0;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private File getAntScript() {
        return InstalledFileLocator.getDefault().locate(JAXB_SCRIPT_PATH, "", false);
    }
}

