/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.net.URL;
import java.util.Comparator;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskComparator {
    private static Comparator<Task> DEFAULT_COMPARATOR;

    private TaskComparator() {
    }

    public static Comparator<Task> getDefault() {
        if (null == DEFAULT_COMPARATOR) {
            DEFAULT_COMPARATOR = new Comparator<Task>(){

                @Override
                public int compare(Task task, Task task2) {
                    int n = 0;
                    n = Accessor.getGroup(task).compareTo(Accessor.getGroup(task2));
                    if (0 == n) {
                        URL uRL = Accessor.getURL(task);
                        URL uRL2 = Accessor.getURL(task2);
                        if (null == uRL && null != uRL2) {
                            n = -1;
                        } else if (null != uRL && null == uRL2) {
                            n = 1;
                        } else if (null != uRL && null != uRL2) {
                            n = uRL.toString().compareTo(uRL2.toString());
                        } else {
                            FileObject fileObject = Accessor.getFile(task);
                            FileObject fileObject2 = Accessor.getFile(task2);
                            n = fileObject.getPath().compareTo(fileObject2.getPath());
                        }
                    }
                    if (0 == n) {
                        if (Accessor.getLine(task) <= 0 && Accessor.getLine(task2) > 0) {
                            n = -1;
                        } else if (Accessor.getLine(task) > 0 && Accessor.getLine(task2) <= 0) {
                            n = 1;
                        } else if (Accessor.getLine(task) > 0 && Accessor.getLine(task2) > 0) {
                            n = Accessor.getLine(task) - Accessor.getLine(task2);
                        }
                    }
                    if (0 == n) {
                        n = Accessor.getDescription(task).compareTo(Accessor.getDescription(task2));
                    }
                    return n;
                }
            };
        }
        return DEFAULT_COMPARATOR;
    }

    public static Comparator<Task> getDescriptionComparator(boolean bl) {
        return new DescriptionComparator(bl);
    }

    public static Comparator<Task> getLocationComparator(boolean bl) {
        return new LocationComparator(bl);
    }

    public static Comparator<Task> getFileComparator(boolean bl) {
        return new FileComparator(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationComparator
    implements Comparator<Task> {
        private boolean asc;

        public LocationComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = 0;
            String string = Accessor.getLocation(task);
            String string2 = Accessor.getLocation(task2);
            if (null == string && null != string2) {
                n = -1;
            } else if (null != string && null == string2) {
                n = 1;
            } else if (null != string && null != string2) {
                n = string.compareTo(string2);
            }
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LocationComparator locationComparator = (LocationComparator)object;
            return this.asc == locationComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 99 * n + (this.asc ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileComparator
    implements Comparator<Task> {
        private boolean asc;

        public FileComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = 0;
            String string = Accessor.getFileNameExt(task);
            String string2 = Accessor.getFileNameExt(task2);
            if (null == string && null != string2) {
                n = -1;
            } else if (null != string && null == string2) {
                n = 1;
            } else if (null != string && null != string2) {
                n = string.compareTo(string2);
            }
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FileComparator fileComparator = (FileComparator)object;
            return this.asc == fileComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 89 * n + (this.asc ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptionComparator
    implements Comparator<Task> {
        private boolean asc;

        public DescriptionComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = Accessor.getDescription(task).compareTo(Accessor.getDescription(task2));
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DescriptionComparator descriptionComparator = (DescriptionComparator)object;
            return this.asc == descriptionComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 69 * n + (this.asc ? 1 : 0);
            return n;
        }
    }
}

