/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentEditorScanningScope
extends TaskScanningScope
implements PropertyChangeListener,
Runnable {
    private FileObject currentFile = null;
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;

    public CurrentEditorScanningScope(String string, String string2, Image image) {
        super(string, string2, image);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("StatusBarLabel", NbBundle.getMessage(CurrentEditorScanningScope.class, (String)"LBL_CurrentFileStatusMessage"));
        this.lookupContent.add(hashMap);
    }

    public static CurrentEditorScanningScope create() {
        return new CurrentEditorScanningScope(NbBundle.getBundle(CurrentEditorScanningScope.class).getString("LBL_CurrentEditorScope"), NbBundle.getBundle(CurrentEditorScanningScope.class).getString("HINT_CurrentEditorScope"), ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/cur_editor_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(1);
        if (null != this.currentFile) {
            arrayList.add(this.currentFile);
        }
        return arrayList.iterator();
    }

    public boolean isInScope(FileObject fileObject) {
        if (null == fileObject) {
            return false;
        }
        return null != this.currentFile && this.currentFile.equals(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        CurrentEditorScanningScope currentEditorScanningScope = this;
        synchronized (currentEditorScanningScope) {
            if (null == this.lookup) {
                this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
            }
        }
        return this.lookup;
    }

    public void attach(TaskScanningScope.Callback callback) {
        if (null != callback && null == this.callback) {
            WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        } else if (null == callback && null != this.callback) {
            WindowManager.getDefault().getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            if (null != this.currentFile) {
                this.lookupContent.remove((Object)this.currentFile);
            }
            this.currentFile = null;
        }
        if (null != callback && callback != this.callback) {
            this.callback = callback;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
        this.callback = callback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activatedNodes".equals(propertyChangeEvent.getPropertyName()) || "opened".equals(propertyChangeEvent.getPropertyName()) || "activated".equals(propertyChangeEvent.getPropertyName())) {
            this.run();
        }
    }

    @Override
    public void run() {
        this.switchCurrentFile(true);
    }

    private void switchCurrentFile(boolean bl) {
        FileObject fileObject = this.getCurrentFile();
        if (null == this.currentFile && null != fileObject || null != this.currentFile && null == fileObject || null != this.currentFile && null != fileObject && !this.currentFile.equals(fileObject)) {
            if (null != this.currentFile) {
                this.lookupContent.remove((Object)this.currentFile);
            }
            if (null != fileObject) {
                this.lookupContent.add((Object)fileObject);
            }
            this.currentFile = fileObject;
            if (null != this.callback && bl) {
                this.callback.refresh();
            }
        } else {
            this.currentFile = fileObject;
        }
    }

    private FileObject getCurrentFile() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        TopComponent topComponent = registry.getActivated();
        FileObject fileObject = this.getFileFromTopComponent(topComponent);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(3);
        if (null == fileObject) {
            ArrayList arrayList2 = new ArrayList(registry.getOpened());
            for (TopComponent topComponent2 : arrayList2) {
                FileObject fileObject2 = this.getFileFromTopComponent(topComponent2);
                if (null == fileObject2) continue;
                arrayList.add(fileObject2);
            }
            if (null != this.currentFile && arrayList.contains(this.currentFile)) {
                fileObject = this.currentFile;
            } else if (arrayList.size() > 0) {
                fileObject = (FileObject)arrayList.get(0);
            }
        }
        return fileObject;
    }

    private FileObject getFileFromTopComponent(TopComponent topComponent) {
        DataObject dataObject;
        if (null == topComponent || !topComponent.isShowing()) {
            return null;
        }
        if (WindowManager.getDefault().isOpenedEditorTopComponent(topComponent) && null != (dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class))) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }
}

