/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.utils;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.utils.FilteredKeymap;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ContextBindingSupport {
    private static final ContextBindingSupport INSTANCE = new ContextBindingSupport();
    private RequestProcessor contextRetrievalRP;

    public static final ContextBindingSupport getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupContext(final JEditorPane jEditorPane, final ActionListener actionListener) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)"text/x-c++");
        jEditorPane.setEditorKit(editorKit);
        if (EventQueue.isDispatchThread()) {
            Class<ContextBindingSupport> clazz = ContextBindingSupport.class;
            synchronized (ContextBindingSupport.class) {
                if (this.contextRetrievalRP == null) {
                    this.contextRetrievalRP = new RequestProcessor("Context Retrieval", 1);
                }
                this.contextRetrievalRP.post(new Runnable(){

                    public void run() {
                        final Context context = ContextBindingSupport.this.retrieveContext();
                        if (context != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ContextBindingSupport.setupContext(jEditorPane, context.fileObject, context.line);
                                    if (actionListener != null) {
                                        actionListener.actionPerformed(null);
                                    }
                                }
                            });
                        }
                    }
                });
                // ** MonitorExit[var4_4] (shouldn't be in output)
                ContextBindingSupport.setupUI(jEditorPane);
            }
        } else {
            Context context = this.retrieveContext();
            if (context != null) {
                ContextBindingSupport.setupContext(jEditorPane, context.fileObject, context.line);
            } else {
                ContextBindingSupport.setupUI(jEditorPane);
            }
            if (actionListener != null) {
                actionListener.actionPerformed(null);
            }
        }
    }

    protected Context retrieveContext() {
        ArrayList arrayList = new ArrayList(Lookup.getDefault().lookupAll(ContextProvider.class));
        for (ContextProvider contextProvider : arrayList) {
            Context context = contextProvider.retrieveContext();
            if (context == null) continue;
            return context;
        }
        FileObject fileObject = EditorContextBridge.getContext().getCurrentFileObject();
        if (fileObject != null) {
            return new Context(fileObject, EditorContextBridge.getContext().getCurrentLineNumber());
        }
        fileObject = EditorContextBridge.getContext().getMostRecentFileObject();
        if (fileObject != null) {
            return new Context(fileObject, EditorContextDispatcher.getDefault().getMostRecentLineNumber());
        }
        return null;
    }

    private static void setupContext(JEditorPane jEditorPane, FileObject fileObject, int n) {
        StyledDocument styledDocument;
        ContextBindingSupport.setupUI(jEditorPane);
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            DialogBinding.bindComponentToDocument((Document)styledDocument, (int)n2, (int)0, (JTextComponent)jEditorPane);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
    }

    private static void setupUI(JEditorPane jEditorPane) {
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField("M");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(jTextField.getBackground());
        jScrollPane.setBorder(jTextField.getBorder());
        jScrollPane.setBackground(jTextField.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jScrollPane.setViewportView(jPanel);
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    public static interface ContextProvider {
        public Context retrieveContext();
    }

    public static final class Context {
        public final FileObject fileObject;
        public final int line;

        public Context(FileObject fileObject, int n) {
            this.fileObject = fileObject;
            this.line = n <= 0 ? 0 : n;
        }
    }
}

