/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DebuggerBreakpointAnnotation
extends BreakpointAnnotation {
    private String type;
    private CndBreakpoint breakpoint;

    public DebuggerBreakpointAnnotation(String string, Line line, CndBreakpoint cndBreakpoint) {
        this.type = string;
        this.breakpoint = cndBreakpoint;
        this.attach((Annotatable)line);
    }

    public String getAnnotationType() {
        return this.type;
    }

    public Line getLine() {
        return (Line)this.getAttachedAnnotatable();
    }

    public String getShortDescription() {
        if (this.type.endsWith("_broken")) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_BREAKPOINT_BROKEN");
        }
        if ("Breakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_BREAKPOINT");
        }
        if ("DisabledBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_BREAKPOINT");
        }
        if ("CondBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_CONDITIONAL_BREAKPOINT");
        }
        if ("DisabledCondBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT");
        }
        if ("FunctionBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_FUNCTION_BREAKPOINT");
        }
        if ("DisabledFunctionBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_FUNCTION_BREAKPOINT");
        }
        if ("CondFuncBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_CONDITIONAL_FUNCTION_BREAKPOINT");
        }
        if ("DisabledCondFuncBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_CONDITIONAL_FUNCTION_BREAKPOINT");
        }
        if ("AddressBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_ADDRESS_BREAKPOINT");
        }
        if ("DisabledAddressBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_ADDRESS_BREAKPOINT");
        }
        if ("CondAddrBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_CONDITIONAL_ADDRESS_BREAKPOINT");
        }
        if ("DisabledCondAddrBreakpoint".equals(this.type)) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_CONDITIONAL_ADDRESS_BREAKPOINT");
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }
}

