/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.openide.modules.ModuleInstall;
import org.openide.util.WeakListeners;

class EditorBookmarksModule
extends ModuleInstall {
    private static final String DOCUMENT_TRACKER_PROP = "EditorBookmarksModule.DOCUMENT_TRACKER_PROP";
    private BookmarksInitializer bookmarksInitializer;
    private PropertyChangeListener annotationTypesListener;

    EditorBookmarksModule() {
    }

    public void restored() {
        BookmarksPersistence.init();
        this.bookmarksInitializer = new BookmarksInitializer();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final Iterator iterator = EditorRegistry.componentList().iterator();
                if (!iterator.hasNext()) {
                    return;
                }
                AnnotationType annotationType = AnnotationTypes.getTypes().getType("editor-bookmark");
                if (annotationType == null) {
                    EditorBookmarksModule.this.annotationTypesListener = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            AnnotationType annotationType = AnnotationTypes.getTypes().getType("editor-bookmark");
                            if (annotationType != null) {
                                AnnotationTypes.getTypes().removePropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                                while (iterator.hasNext()) {
                                    JTextComponent jTextComponent = (JTextComponent)iterator.next();
                                    BookmarkList.get(jTextComponent.getDocument());
                                }
                            }
                        }
                    };
                    AnnotationTypes.getTypes().addPropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                } else {
                    while (iterator.hasNext()) {
                        BookmarkList.get(((JTextComponent)iterator.next()).getDocument());
                    }
                }
            }
        });
    }

    public boolean closing() {
        this.finish();
        return super.closing();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        BookmarksPersistence.destroy();
        if (this.bookmarksInitializer != null) {
            this.bookmarksInitializer.destroy();
        }
    }

    private class BookmarksInitializer
    implements PropertyChangeListener {
        private PropertyChangeListener documentListener;

        BookmarksInitializer() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
            this.documentListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == EditorRegistry.class) {
                if (propertyChangeEvent.getPropertyName() == null || "focusGained".equals(propertyChangeEvent.getPropertyName())) {
                    JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                    BookmarkList.get(jTextComponent.getDocument());
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)jTextComponent.getClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP);
                    if (propertyChangeListener == null) {
                        jTextComponent.putClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP, this.documentListener);
                        jTextComponent.addPropertyChangeListener(this.documentListener);
                    }
                }
                return;
            }
            if (propertyChangeEvent.getSource() instanceof JTextComponent) {
                Document document;
                if ((propertyChangeEvent.getPropertyName() == null || "document".equals(propertyChangeEvent.getPropertyName())) && (document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    BookmarkList.get(document);
                }
                return;
            }
        }

        void destroy() {
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

