/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.completion.AttributeResultItem;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.ElementResultItem;
import org.netbeans.modules.xml.schema.completion.ValueResultItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.model.Form;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionUtil {
    private static final Logger logger = Logger.getLogger(CompletionUtil.class.getName());

    private CompletionUtil() {
    }

    public static void printPath(List<QName> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (QName qName : list) {
            if (stringBuffer.toString().equals("")) {
                stringBuffer.append(qName);
                continue;
            }
            stringBuffer.append("/" + qName);
        }
    }

    public static boolean isRoot(String string, CompletionModelProvider.CompletionModel completionModel) {
        if (completionModel == null) {
            return false;
        }
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(completionModel.getSchemaModel());
        for (AbstractElement abstractElement : aXIModel.getRoot().getChildElements()) {
            if (!string.endsWith(abstractElement.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getPrefixFromTag(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? null : string.substring(0, string.indexOf(":"));
    }

    public static String getLocalNameFromTag(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? string : string.substring(string.indexOf(":") + 1, string.length());
    }

    public static String getPrefixFromXMLNS(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? null : string.substring(string.indexOf(":") + 1);
    }

    public static List<String> getPrefixesAgainstNamespace(CompletionContextImpl completionContextImpl, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : completionContextImpl.getDeclaredNamespaces().keySet()) {
            String string3 = completionContextImpl.getDeclaredNamespaces().get(string2);
            if (!string3.equals(string)) continue;
            arrayList.add(CompletionUtil.getPrefixFromXMLNS(string2));
        }
        return arrayList;
    }

    public static void loadSchemaURIs(String string, List<URI> list, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll("\n", " "), " ");
        while (stringTokenizer.hasMoreTokens()) {
            URI uRI = null;
            try {
                String string2;
                String string3 = stringTokenizer.nextToken().trim();
                if (bl) {
                    uRI = URI.create(string3);
                    if (uRI == null) continue;
                    list.add(uRI);
                    continue;
                }
                if (!stringTokenizer.hasMoreTokens() || (uRI = URI.create(string2 = stringTokenizer.nextToken().trim())) == null) continue;
                list.add(uRI);
            }
            catch (Exception exception) {}
        }
    }

    public static List<CompletionResultItem> getAttributes(CompletionContextImpl completionContextImpl) {
        Element element = CompletionUtil.findAXIElementAtContext(completionContextImpl);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        for (AbstractAttribute abstractAttribute : element.getAttributes()) {
            AXIComponent aXIComponent = abstractAttribute.getOriginal();
            if (aXIComponent.getTargetNamespace() == null) {
                CompletionResultItem completionResultItem = CompletionUtil.createResultItem(aXIComponent, null, completionContextImpl);
                if (completionResultItem == null) continue;
                arrayList.add(completionResultItem);
                continue;
            }
            if (aXIComponent instanceof AnyAttribute) {
                arrayList.addAll(CompletionUtil.substituteAny((AXIComponent)((AnyAttribute)aXIComponent), completionContextImpl));
                continue;
            }
            CompletionUtil.addNSAwareCompletionItems(aXIComponent, completionContextImpl, null, arrayList);
        }
        return arrayList;
    }

    public static List<CompletionResultItem> getElements(CompletionContextImpl completionContextImpl) {
        Element element = CompletionUtil.findAXIElementAtContext(completionContextImpl);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        for (AbstractElement abstractElement : element.getChildElements()) {
            AXIComponent aXIComponent = abstractElement.getOriginal();
            if (aXIComponent.getTargetNamespace() == null) {
                CompletionResultItem completionResultItem = CompletionUtil.createResultItem(aXIComponent, null, completionContextImpl);
                if (completionResultItem == null) continue;
                arrayList.add(completionResultItem);
                continue;
            }
            if (aXIComponent instanceof AnyElement) {
                arrayList.addAll(CompletionUtil.substituteAny((AXIComponent)((AnyElement)aXIComponent), completionContextImpl));
                continue;
            }
            CompletionUtil.addNSAwareCompletionItems(aXIComponent, completionContextImpl, null, arrayList);
        }
        return arrayList;
    }

    public static List<CompletionResultItem> getElementValues(CompletionContextImpl completionContextImpl) {
        Element element = CompletionUtil.findAXIElementAtContext(completionContextImpl);
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        if (element == null) {
            return null;
        }
        AXIType aXIType = element.getType();
        if (aXIType == null || !(aXIType instanceof Datatype) || ((Datatype)aXIType).getEnumerations() == null) {
            return null;
        }
        for (Object e : ((Datatype)aXIType).getEnumerations()) {
            Object object;
            if (completionContextImpl.getTypedChars() == null || completionContextImpl.getTypedChars().equals("")) {
                object = new ValueResultItem((AXIComponent)element, (String)e, completionContextImpl);
                arrayList.add((CompletionResultItem)object);
                continue;
            }
            object = (String)e;
            if (!((String)object).startsWith(completionContextImpl.getTypedChars())) continue;
            ValueResultItem valueResultItem = new ValueResultItem((AXIComponent)element, (String)e, completionContextImpl);
            arrayList.add(valueResultItem);
        }
        return arrayList;
    }

    public static List<CompletionResultItem> getAttributeValues(CompletionContextImpl completionContextImpl) {
        Element element = CompletionUtil.findAXIElementAtContext(completionContextImpl);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        Attribute attribute = null;
        for (Object object : element.getAttributes()) {
            if (object instanceof AnyAttribute || !object.getName().equals(completionContextImpl.getAttribute())) continue;
            attribute = (Attribute)object;
            break;
        }
        if (attribute == null) {
            return null;
        }
        AXIType aXIType = attribute.getType();
        if (aXIType == null || !(aXIType instanceof Datatype) || ((Datatype)aXIType).getEnumerations() == null) {
            return null;
        }
        for (Object e : ((Datatype)aXIType).getEnumerations()) {
            Object object;
            if (completionContextImpl.getTypedChars() == null || completionContextImpl.getTypedChars().equals("")) {
                object = new ValueResultItem((AXIComponent)attribute, (String)e, completionContextImpl);
                arrayList.add((CompletionResultItem)object);
                continue;
            }
            object = (String)e;
            if (!((String)object).startsWith(completionContextImpl.getTypedChars())) continue;
            ValueResultItem valueResultItem = new ValueResultItem((AXIComponent)attribute, (String)e, completionContextImpl);
            arrayList.add(valueResultItem);
        }
        return arrayList;
    }

    private static void addNSAwareCompletionItems(AXIComponent aXIComponent, CompletionContextImpl completionContextImpl, CompletionModelProvider.CompletionModel completionModel, List<CompletionResultItem> list) {
        String string = completionContextImpl.getTypedChars();
        CompletionResultItem completionResultItem = null;
        if (!CompletionUtil.isFormQualified(aXIComponent)) {
            completionResultItem = CompletionUtil.createResultItem(aXIComponent, null, completionContextImpl);
            if (completionResultItem == null) {
                return;
            }
            if (string == null) {
                list.add(completionResultItem);
            } else if (completionResultItem.getReplacementText().startsWith(string)) {
                list.add(completionResultItem);
            }
            return;
        }
        List<String> list2 = CompletionUtil.getPrefixes(completionContextImpl, aXIComponent, completionModel);
        if (list2.size() == 0) {
            list2.add(null);
        }
        for (String string2 : list2) {
            completionResultItem = CompletionUtil.createResultItem(aXIComponent, string2, completionContextImpl);
            if (completionResultItem == null) continue;
            if (string == null) {
                list.add(completionResultItem);
                continue;
            }
            if (!completionResultItem.getReplacementText().startsWith(string)) continue;
            list.add(completionResultItem);
        }
    }

    private static CompletionResultItem createResultItem(AXIComponent aXIComponent, String string, CompletionContextImpl completionContextImpl) {
        CompletionResultItem completionResultItem = null;
        if (aXIComponent instanceof AbstractElement) {
            completionResultItem = string == null ? new ElementResultItem((AbstractElement)aXIComponent, (CompletionContext)completionContextImpl) : new ElementResultItem((AbstractElement)aXIComponent, string, completionContextImpl);
        }
        if (aXIComponent instanceof AbstractAttribute) {
            Attribute attribute = (Attribute)aXIComponent;
            if (string == null) {
                if (!completionContextImpl.getExistingAttributes().contains(attribute.getName())) {
                    completionResultItem = new AttributeResultItem((AbstractAttribute)aXIComponent, (CompletionContext)completionContextImpl);
                }
            } else if (!completionContextImpl.getExistingAttributes().contains(string + ":" + attribute.getName())) {
                completionResultItem = new AttributeResultItem((AbstractAttribute)aXIComponent, string, completionContextImpl);
            }
        }
        return completionResultItem;
    }

    private static List<String> getPrefixes(CompletionContextImpl completionContextImpl, AXIComponent aXIComponent, CompletionModelProvider.CompletionModel completionModel) {
        List<Object> list = new ArrayList();
        if (completionModel == null) {
            if (completionContextImpl.getDefaultNamespace() != null && !completionContextImpl.getDefaultNamespace().equals(aXIComponent.getTargetNamespace())) {
                list = CompletionUtil.getPrefixesAgainstNamespace(completionContextImpl, aXIComponent.getTargetNamespace());
                if (list.size() != 0) {
                    return list;
                }
                String string = completionContextImpl.suggestPrefix("ns1");
                CompletionModelEx completionModelEx = new CompletionModelEx(completionContextImpl, string, aXIComponent.getModel().getSchemaModel());
                completionContextImpl.addCompletionModel(completionModelEx);
                list.add(string);
                return list;
            }
            return CompletionUtil.getPrefixesAgainstNamespace(completionContextImpl, aXIComponent.getTargetNamespace());
        }
        list = CompletionUtil.getPrefixesAgainstNamespace(completionContextImpl, completionModel.getTargetNamespace());
        if (list.size() == 0) {
            list.add(completionModel.getSuggestedPrefix());
        }
        return list;
    }

    private static boolean isFormQualified(AXIComponent aXIComponent) {
        if (aXIComponent instanceof Attribute) {
            AXIComponent aXIComponent2 = aXIComponent.getOriginal();
            if (((Attribute)aXIComponent2).isReference() || aXIComponent2.getParent() instanceof AXIDocument) {
                return true;
            }
            Attribute attribute = (Attribute)aXIComponent;
            return attribute.getForm() == Form.QUALIFIED;
        }
        if (aXIComponent instanceof Element) {
            AXIComponent aXIComponent3 = aXIComponent.getOriginal();
            if (((Element)aXIComponent3).isReference() || aXIComponent3.getParent() instanceof AXIDocument) {
                return true;
            }
            Element element = (Element)aXIComponent;
            return element.getForm() == Form.QUALIFIED;
        }
        return false;
    }

    public static Element findAXIElementAtContext(CompletionContextImpl completionContextImpl) {
        List<QName> list = completionContextImpl.getPathFromRoot();
        if (list == null || list.size() == 0) {
            return null;
        }
        CompletionModelProvider.CompletionModel completionModel = null;
        QName qName = completionContextImpl.getPathFromRoot().get(0);
        String string = qName.getNamespaceURI();
        completionModel = string != null && string.equals("") ? completionContextImpl.getActiveNoNSModel() : completionContextImpl.getCompletionModelMap().get(string);
        if (completionModel == null) {
            return null;
        }
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(completionModel.getSchemaModel());
        AXIDocument aXIDocument = aXIModel.getRoot();
        if (aXIDocument == null) {
            return null;
        }
        AXIComponent aXIComponent = null;
        for (QName qName2 : list) {
            aXIComponent = CompletionUtil.findChildElement((AXIComponent)aXIDocument, qName2);
            aXIDocument = aXIComponent;
        }
        if (aXIComponent != null && aXIComponent instanceof Element) {
            return (Element)aXIComponent;
        }
        return null;
    }

    private static AXIComponent findChildElement(AXIComponent aXIComponent, QName qName) {
        if (aXIComponent == null) {
            return null;
        }
        for (AbstractElement abstractElement : aXIComponent.getChildElements()) {
            if (!(abstractElement instanceof Element)) continue;
            Element element = (Element)abstractElement;
            if (!qName.getLocalPart().equals(element.getName())) continue;
            return abstractElement;
        }
        return null;
    }

    private static List<CompletionResultItem> substituteAny(AXIComponent aXIComponent, CompletionContextImpl completionContextImpl) {
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        String string = aXIComponent.getTargetNamespace();
        String string2 = aXIComponent.getModel().getRoot().getTargetNamespace();
        for (CompletionModelProvider.CompletionModel completionModel : completionContextImpl.getCompletionModels()) {
            if (completionModel == null) continue;
            if (string.equals("##other") && string2 != null && !string2.equals(completionModel.getTargetNamespace())) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (string.equals("##targetNamespace") && string2 != null && string2.equals(completionModel.getTargetNamespace())) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (string.equals("##local") && completionModel.getTargetNamespace() == null) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (!string.startsWith("##") && completionModel.getTargetNamespace() != null && string.indexOf(completionModel.getTargetNamespace()) != -1) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (!string.equals("##any")) continue;
            CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
        }
        return arrayList;
    }

    private static void populateItemsForAny(CompletionModelProvider.CompletionModel completionModel, AXIComponent aXIComponent, CompletionContextImpl completionContextImpl, List<CompletionResultItem> list) {
        if (completionModel == null) {
            return;
        }
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(completionModel.getSchemaModel());
        if (aXIComponent instanceof AnyElement) {
            for (Element element : aXIModel.getRoot().getElements()) {
                CompletionUtil.addNSAwareCompletionItems((AXIComponent)element, completionContextImpl, completionModel, list);
            }
        }
        if (aXIComponent instanceof AnyAttribute) {
            for (Element element : aXIModel.getRoot().getAttributes()) {
                CompletionUtil.addNSAwareCompletionItems((AXIComponent)element, completionContextImpl, completionModel, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getNamespacesFromStartTags(Document document) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            String string = null;
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id() == XMLTokenId.ARGUMENT && ((Object)token.text()).toString().startsWith("xmlns")) {
                    string = ((Object)token.text()).toString();
                }
                if (token.id() != XMLTokenId.VALUE || string == null) continue;
                String string2 = ((Object)token.text()).toString();
                if (string2.length() >= 2 && (string2.startsWith("'") || string2.startsWith("\""))) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                    string = null;
                    continue;
                }
                hashMap.put(string2, CompletionUtil.getPrefixFromXMLNS(string));
                string = null;
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDTDBasedDocument(Document document) {
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id() == XMLTokenId.TAG) {
                    boolean bl = false;
                    return bl;
                }
                if (token.id() != XMLTokenId.DECLARATION) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNamespaceInsertionOffset(Document document) {
        int n = 0;
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id() != XMLTokenId.TAG || !((Object)token.text()).toString().equals(">")) continue;
                n = token.offset(tokenHierarchy);
                break;
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocRoot getDocRoot(Document document) {
        ((AbstractDocument)document).readLock();
        try {
            Object object;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            ArrayList<DocRootAttribute> arrayList = new ArrayList<DocRootAttribute>();
            String string = null;
            while (tokenSequence.moveNext()) {
                Token token;
                object = tokenSequence.token();
                if (object.id() != XMLTokenId.TAG) continue;
                String string2 = ((Object)object.text()).toString();
                if (string == null && string2.startsWith("<")) {
                    string = string2.substring(1, string2.length());
                }
                String string3 = null;
                while (tokenSequence.moveNext() && ((token = tokenSequence.token()).id() != XMLTokenId.TAG || !((Object)token.text()).toString().equals(">"))) {
                    if (token.id() == XMLTokenId.ARGUMENT) {
                        string3 = ((Object)token.text()).toString();
                    }
                    if (token.id() != XMLTokenId.VALUE || string3 == null) continue;
                    String string4 = ((Object)token.text()).toString();
                    if (string4 == null || string4.length() == 1) {
                        string4 = null;
                    } else if (string4.startsWith("'") || string4.startsWith("\"")) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    arrayList.add(new DocRootAttribute(string3, string4));
                    string3 = null;
                }
                if (string == null) continue;
                break;
            }
            object = new DocRoot(string, arrayList);
            return object;
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
    }

    public static boolean canProvideCompletion(BaseDocument baseDocument) {
        FileObject fileObject = CompletionUtil.getPrimaryFile();
        if (fileObject == null) {
            return false;
        }
        if ("xml".equals(fileObject.getExt())) {
            if (CompletionUtil.isDTDBasedDocument((Document)baseDocument)) {
                return false;
            }
            DocRoot docRoot = CompletionUtil.getDocRoot((Document)baseDocument);
            if (docRoot != null && !docRoot.declaresNamespace()) {
                return false;
            }
        }
        return true;
    }

    public static FileObject getPrimaryFile() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return null;
        }
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    public static class DocRootAttribute {
        private String name;
        private String value;

        DocRootAttribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocRoot {
        private String name;
        private List<DocRootAttribute> attributes;

        DocRoot(String string, List<DocRootAttribute> list) {
            this.name = string;
            this.attributes = new ArrayList<DocRootAttribute>(list);
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return CompletionUtil.getPrefixFromTag(this.name);
        }

        public List<DocRootAttribute> getAttributes() {
            return this.attributes;
        }

        public boolean declaresNamespace() {
            for (DocRootAttribute docRootAttribute : this.getAttributes()) {
                if (!docRootAttribute.getName().startsWith("xmlns")) continue;
                return true;
            }
            return false;
        }
    }
}

